/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import com.google.gwt.dev.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class DiskCache {
    public static DiskCache INSTANCE = new DiskCache();
    private boolean atEnd = true;
    private final RandomAccessFile file;

    private DiskCache() {
        try {
            File temp = File.createTempFile("gwt", "byte-cache");
            temp.deleteOnExit();
            this.file = new RandomAccessFile(temp, "rw");
            this.file.setLength(0L);
            this.registerShutdownHook();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize byte cache", e);
        }
    }

    public synchronized byte[] readByteArray(long token) {
        try {
            this.atEnd = false;
            this.file.seek(token);
            int length = this.file.readInt();
            byte[] result = new byte[length];
            this.file.readFully(result);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read from byte cache", e);
        }
    }

    public <T> T readObject(long token, Class<T> type) {
        try {
            byte[] bytes = this.readByteArray(token);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            return Util.readStreamAsObject(in, type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unexpected exception deserializing from disk cache", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception deserializing from disk cache", e);
        }
    }

    public String readString(long token) {
        return Util.toString(this.readByteArray(token));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long transferFromStream(InputStream in) throws IOException {
        assert (in != null);
        byte[] buf = Util.takeThreadLocalBuf();
        try {
            int bytesRead;
            long position = this.moveToEndPosition();
            this.file.writeInt(-1);
            int length = 0;
            while ((bytesRead = in.read(buf)) != -1) {
                this.file.write(buf, 0, bytesRead);
                length += bytesRead;
            }
            this.file.seek(position);
            this.file.writeInt(length);
            this.atEnd = false;
            long l = position;
            return l;
        }
        finally {
            Util.releaseThreadLocalBuf(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void transferToStream(long token, OutputStream out) throws IOException {
        byte[] buf = Util.takeThreadLocalBuf();
        try {
            int length;
            int read;
            this.atEnd = false;
            this.file.seek(token);
            int bufLen = buf.length;
            for (length = this.file.readInt(); length > bufLen; length -= read) {
                read = this.file.read(buf, 0, bufLen);
                out.write(buf, 0, read);
            }
            while (length > 0) {
                read = this.file.read(buf, 0, length);
                length -= read;
                out.write(buf, 0, read);
            }
        }
        finally {
            Util.releaseThreadLocalBuf(buf);
        }
    }

    public synchronized long writeByteArray(byte[] bytes) {
        try {
            long position = this.moveToEndPosition();
            this.file.writeInt(bytes.length);
            this.file.write(bytes);
            return position;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write to byte cache", e);
        }
    }

    public long writeObject(Object object) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Util.writeObjectToStream(out, object);
            return this.writeByteArray(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException on in-memory stream", e);
        }
    }

    public long writeString(String str) {
        return this.writeByteArray(Util.getBytes(str));
    }

    private long moveToEndPosition() throws IOException {
        if (this.atEnd) {
            return this.file.getFilePointer();
        }
        long position = this.file.length();
        this.file.seek(position);
        this.atEnd = true;
        return position;
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DiskCache.this.file.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }));
    }
}

