/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import com.google.gwt.dev.Permutation;
import com.google.gwt.dev.cfg.BindingProperties;
import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.util.StringKey;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.TreeMultimap;
import java.util.List;
import java.util.Set;

public class CollapsedPropertyKey
extends StringKey {
    private final Permutation permutation;

    private static String collapse(List<BindingProperties> allPropertiesSets) {
        TreeMultimap<String, String> propertyValuesByPropertyName = TreeMultimap.create();
        for (BindingProperties bindingProperties : allPropertiesSets) {
            BindingProperty[] properties = bindingProperties.getOrderedProps();
            String[] values = bindingProperties.getOrderedPropValues();
            for (int i = 0; i < properties.length; ++i) {
                BindingProperty property = properties[i];
                String value = values[i];
                propertyValuesByPropertyName.put(property.getName(), value);
                for (Set set : property.getCollapsedValuesSets()) {
                    if (!set.contains(value)) continue;
                    propertyValuesByPropertyName.putAll(property.getName(), set);
                }
            }
        }
        return ((Object)propertyValuesByPropertyName).toString();
    }

    public CollapsedPropertyKey(Permutation permutation) {
        super(CollapsedPropertyKey.collapse(permutation.getProperties().getSoftProperties()));
        this.permutation = permutation;
    }

    public CollapsedPropertyKey(BindingProperties props) {
        super(CollapsedPropertyKey.collapse(ImmutableList.of(props)));
        this.permutation = null;
    }

    public Permutation getPermutation() {
        return this.permutation;
    }
}

