/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class BrowserLauncher {
    private static Launcher launcher;

    public static void browse(String url) throws IOException, URISyntaxException {
        if (launcher == null) {
            BrowserLauncher.findLauncher();
        }
        launcher.browse(url);
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        if (args.length == 0) {
            System.err.println("Usage: BrowserLauncher url...");
            System.exit(1);
        }
        for (String url : args) {
            BrowserLauncher.browse(url);
        }
    }

    private static void findLauncher() {
        try {
            launcher = new Jdk16Launcher();
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            String osName = System.getProperty("os.name");
            launcher = osName.startsWith("Mac OS") ? new MacLauncher() : (osName.startsWith("Windows") ? new WindowsLauncher() : new UnixExecBrowserLauncher());
            return;
        }
    }

    private static class WindowsLauncher
    implements Launcher {
        private WindowsLauncher() {
        }

        @Override
        public void browse(String url) throws IOException {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
        }
    }

    private static class UnixExecBrowserLauncher
    implements Launcher {
        private static final String[] browsers = new String[]{"xdg-open", "gvfs-open", "gnome-open", "firefox", "opera", "konqueror", "chrome", "chromium", "epiphany", "seamonkey", "mozilla", "netscape", "galeon", "kazehakase"};
        private String browserExecutable;

        public UnixExecBrowserLauncher() throws UnsupportedOperationException {
            for (String browser : browsers) {
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{"which", browser});
                    if (process.waitFor() != 0) continue;
                    this.browserExecutable = browser;
                    return;
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            throw new UnsupportedOperationException("no suitable browser found");
        }

        @Override
        public void browse(String url) throws IOException {
            Runtime.getRuntime().exec(new String[]{this.browserExecutable, url});
        }
    }

    private static abstract class ReflectiveLauncher
    implements Launcher {
        protected Object browseObject;
        protected Method browseMethod;

        private ReflectiveLauncher() {
        }

        @Override
        public void browse(String url) throws IOException, URISyntaxException {
            Object arg = this.convertUrl(url);
            ReflectiveOperationException caught = null;
            try {
                this.browseMethod.invoke(this.browseObject, arg);
                return;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                caught = e;
            }
            catch (IllegalAccessException e) {
                caught = e;
            }
            throw new RuntimeException("Unexpected exception", caught);
        }

        protected Object convertUrl(String url) throws URISyntaxException, MalformedURLException {
            return url;
        }
    }

    private static class MacLauncher
    extends ReflectiveLauncher {
        public MacLauncher() throws UnsupportedOperationException {
            Exception caught = null;
            try {
                Class<?> fileManager = Class.forName("com.apple.eio.FileManager");
                this.browseMethod = fileManager.getMethod("openURL", String.class);
                this.browseObject = null;
                return;
            }
            catch (SecurityException e) {
                caught = e;
            }
            catch (ClassNotFoundException e) {
                caught = e;
            }
            catch (NoSuchMethodException e) {
                caught = e;
            }
            throw new UnsupportedOperationException("Can't get openURL", caught);
        }
    }

    private static interface Launcher {
        public void browse(String var1) throws IOException, URISyntaxException;
    }

    private static class Jdk16Launcher
    extends ReflectiveLauncher {
        public Jdk16Launcher() throws UnsupportedOperationException {
            try {
                Class<?> desktopClass = Class.forName("java.awt.Desktop");
                this.browseMethod = desktopClass.getMethod("browse", URI.class);
                Method factory = desktopClass.getMethod("getDesktop", new Class[0]);
                this.browseObject = factory.invoke(null, new Object[0]);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            throw new UnsupportedOperationException("no JDK 1.6 Desktop.browse");
        }

        @Override
        protected Object convertUrl(String url) throws URISyntaxException, MalformedURLException {
            return new URL(url).toURI();
        }
    }
}

