/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.rewrite;

import com.google.gwt.dev.shell.rewrite.HostedModeClassRewriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

abstract class WriteJsoImpl
extends ClassVisitor {
    private final HostedModeClassRewriter.InstanceMethodOracle mapper;
    private String originalName;

    public static ClassVisitor create(ClassVisitor cv, String classDescriptor, Set<String> jsoDescriptors, HostedModeClassRewriter.InstanceMethodOracle mapper, HostedModeClassRewriter.SingleJsoImplData singleJsoImplData) {
        if (classDescriptor.equals(HostedModeClassRewriter.JAVASCRIPTOBJECT_IMPL_DESC)) {
            return new ForJsoDollar(cv, jsoDescriptors, mapper, singleJsoImplData);
        }
        return new ForJsoInterface(cv, mapper);
    }

    private WriteJsoImpl(ClassVisitor cv, HostedModeClassRewriter.InstanceMethodOracle mapper) {
        super(589824, cv);
        this.mapper = mapper;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.originalName = name;
        super.visit(version, 4105, name + '$', signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean isCtor = this.isCtor(name);
        if (!(isCtor || this.isStatic(access) || this.isObjectMethod(name + desc))) {
            access |= 8;
            desc = HostedModeClassRewriter.addSyntheticThisParam(this.getOriginalName(), desc);
            name = name + "$";
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    protected String getOriginalName() {
        return this.originalName;
    }

    protected boolean isCtor(String name) {
        return "<init>".equals(name);
    }

    protected boolean isObjectMethod(String signature) {
        return "java/lang/Object".equals(this.mapper.findOriginalDeclaringClass(this.originalName, signature));
    }

    protected boolean isStatic(int access) {
        return (access & 8) != 0;
    }

    protected MethodVisitor visitMethodNoRewrite(int access, String name, String desc, String signature, String[] exceptions) {
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    private static class ForJsoInterface
    extends WriteJsoImpl {
        public ForJsoInterface(ClassVisitor cv, HostedModeClassRewriter.InstanceMethodOracle mapper) {
            super(cv, mapper);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            superName = superName + '$';
            interfaces = null;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            boolean isCtor = this.isCtor(name);
            if (isCtor) {
                return null;
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }

    private static class ForJsoDollar
    extends WriteJsoImpl {
        private final Set<String> jsoDescriptors;
        private final HostedModeClassRewriter.SingleJsoImplData jsoData;

        public ForJsoDollar(ClassVisitor cv, Set<String> jsoDescriptors, HostedModeClassRewriter.InstanceMethodOracle mapper, HostedModeClassRewriter.SingleJsoImplData jsoData) {
            super(cv, mapper);
            this.jsoDescriptors = jsoDescriptors;
            this.jsoData = jsoData;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            ArrayList<String> jsoDescList = new ArrayList<String>();
            jsoDescList.addAll(this.jsoDescriptors);
            interfaces = jsoDescList.toArray(new String[jsoDescList.size()]);
            super.visit(version, access, name, signature, superName, interfaces);
            FieldVisitor fv = this.visitField(4097, "hostedModeReference", "Ljava/lang/Object;", null, null);
            if (fv != null) {
                fv.visitEnd();
            }
            for (String mangledName : this.jsoData.getMangledNames()) {
                List<Method> declarations = this.jsoData.getDeclarations(mangledName);
                List<Method> implementations = this.jsoData.getImplementations(mangledName);
                assert (declarations.size() == implementations.size()) : "Declaration / implementation size mismatch";
                Iterator<Method> declIterator = declarations.iterator();
                Iterator<Method> implIterator = implementations.iterator();
                while (declIterator.hasNext()) {
                    assert (implIterator.hasNext());
                    this.writeTrampoline(mangledName, declIterator.next(), implIterator.next());
                }
            }
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.isCtor(name)) {
                access &= 0xFFFFFFF9;
                access |= 1;
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        private void writeTrampoline(String mangledName, Method interfaceMethod, Method implementingMethod) {
            assert (implementingMethod.getArgumentTypes().length > 0);
            String localDescriptor = interfaceMethod.getDescriptor();
            Method localMethod = new Method(mangledName, localDescriptor);
            Type implementingType = Type.getType("L" + implementingMethod.getArgumentTypes()[0].getInternalName() + "$;");
            MethodVisitor mv = this.visitMethodNoRewrite(4113, localMethod.getName(), localMethod.getDescriptor(), null, null);
            if (mv != null) {
                mv.visitCode();
                int var = 0;
                int size = 0;
                for (Type t : implementingMethod.getArgumentTypes()) {
                    size += t.getSize();
                    mv.visitVarInsn(t.getOpcode(21), var);
                    var += t.getSize();
                }
                size = Math.max(size, implementingMethod.getReturnType().getSize());
                mv.visitMethodInsn(184, implementingType.getInternalName(), implementingMethod.getName(), implementingMethod.getDescriptor(), false);
                mv.visitInsn(localMethod.getReturnType().getOpcode(172));
                mv.visitMaxs(size, var);
                mv.visitEnd();
            }
        }
    }
}

