/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.rewrite;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class UseMirroredClasses
extends ClassVisitor {
    private String className;

    public UseMirroredClasses(ClassVisitor cv, String className) {
        super(589824, cv);
        this.className = className;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return null;
        }
        return new MethodInterceptor(mv, this.className);
    }

    private static class MethodInterceptor
    extends MethodVisitor {
        private static HashMap<String, HashMap<String, String>> mirrorMap = new HashMap();
        private String className;

        protected MethodInterceptor(MethodVisitor mv, String className) {
            super(589824, mv);
            this.className = className;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean dintf) {
            Map mirroredMethods = mirrorMap.get(owner);
            if (mirroredMethods == null) {
                super.visitMethodInsn(opcode, owner, name, desc, dintf);
                return;
            }
            String mirrorClassMethod = (String)mirroredMethods.get(name);
            if (mirrorClassMethod == null) {
                super.visitMethodInsn(opcode, owner, name, desc, dintf);
                return;
            }
            String[] temp = mirrorClassMethod.split(":");
            if (temp.length < 2) {
                super.visitMethodInsn(opcode, owner, name, desc, dintf);
                return;
            }
            String mirrorClass = temp[0];
            String mirrorMethod = temp[1];
            if (this.className.equals(mirrorClass.replace("/", "."))) {
                super.visitMethodInsn(opcode, owner, name, desc, dintf);
                return;
            }
            if (opcode == 184) {
                super.visitMethodInsn(opcode, mirrorClass, mirrorMethod, desc, dintf);
                return;
            }
            Type[] argTypes = Type.getArgumentTypes(desc);
            Type[] newArgTypes = new Type[argTypes.length + 1];
            newArgTypes[0] = Type.getType("L" + owner + ";");
            System.arraycopy(argTypes, 0, newArgTypes, 1, argTypes.length);
            String newDesc = Type.getMethodDescriptor(Type.getReturnType(desc), newArgTypes);
            super.visitMethodInsn(184, mirrorClass, mirrorMethod, newDesc, dintf);
        }

        static {
            HashMap<String, String> logRecordMethods = new HashMap<String, String>();
            logRecordMethods.put("getLoggerName", "com/google/gwt/logging/impl/DevModeLoggingFixes:getLoggerName");
            mirrorMap.put("java/util/logging/LogRecord", logRecordMethods);
            HashMap<String, String> logManagerMethods = new HashMap<String, String>();
            logManagerMethods.put("getLogger", "com/google/gwt/logging/impl/DevModeLoggingFixes:logManagerGetLogger");
            logManagerMethods.put("getLoggerNames", "com/google/gwt/logging/impl/DevModeLoggingFixes:logManagerGetLoggerNames");
            mirrorMap.put("java/util/logging/LogManager", logManagerMethods);
            HashMap<String, String> loggerMethods = new HashMap<String, String>();
            loggerMethods.put("getName", "com/google/gwt/logging/impl/DevModeLoggingFixes:getName");
            loggerMethods.put("getLogger", "com/google/gwt/logging/impl/DevModeLoggingFixes:loggerGetLogger");
            mirrorMap.put("java/util/logging/Logger", loggerMethods);
        }
    }
}

