/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.rewrite;

import com.google.gwt.dev.shell.rewrite.HostedModeClassRewriter;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;

class RewriteRefsToJsoClasses
extends ClassVisitor {
    protected final Set<String> jsoDescriptors;
    private HostedModeClassRewriter.InstanceMethodOracle mapper;

    public RewriteRefsToJsoClasses(ClassVisitor cv, Set<String> jsoDescriptors, HostedModeClassRewriter.InstanceMethodOracle mapper) {
        super(589824, cv);
        this.jsoDescriptors = jsoDescriptors;
        this.mapper = mapper;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return new MyMethodAdapter(mv);
    }

    private class MyMethodAdapter
    extends MethodVisitor {
        private Remapper remapper;

        public MyMethodAdapter(MethodVisitor mv) {
            super(589824, mv);
            this.remapper = new Remapper(){

                @Override
                public String map(String typeName) {
                    if (RewriteRefsToJsoClasses.this.jsoDescriptors.contains(typeName)) {
                        return HostedModeClassRewriter.JAVASCRIPTOBJECT_IMPL_DESC;
                    }
                    return typeName;
                }
            };
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (RewriteRefsToJsoClasses.this.jsoDescriptors.contains(owner)) {
                owner = owner + "$";
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitLdcInsn(Object cst) {
            cst = this.remapper.mapValue(cst);
            super.visitLdcInsn(cst);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean dintf) {
            if (RewriteRefsToJsoClasses.this.jsoDescriptors.contains(owner)) {
                if (opcode == 182) {
                    owner = RewriteRefsToJsoClasses.this.mapper.findOriginalDeclaringClass(owner, name + desc);
                }
                if (!owner.equals("java/lang/Object")) {
                    if (opcode == 182 || opcode == 183) {
                        opcode = 184;
                        desc = HostedModeClassRewriter.addSyntheticThisParam(owner, desc);
                        name = name + "$";
                    }
                    owner = owner + "$";
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc, dintf);
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            desc = this.remapper.mapType(desc);
            super.visitMultiANewArrayInsn(desc, dims);
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 189) {
                type = this.remapper.mapType(type);
            }
            super.visitTypeInsn(opcode, type);
        }
    }
}

