/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.rewrite;

import com.google.gwt.dev.shell.JavaScriptHost;
import com.google.gwt.dev.util.Name;
import java.util.Locale;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class RewriteJsniMethods
extends ClassVisitor {
    private static final Type BOOLEAN_TYPE = Type.getObjectType("java/lang/Boolean");
    private static final Type BYTE_TYPE = Type.getObjectType("java/lang/Byte");
    private static final Type CHARACTER_TYPE = Type.getObjectType("java/lang/Character");
    private static final Type CLASS_TYPE = Type.getObjectType("java/lang/Class");
    private static final Type DOUBLE_TYPE = Type.getObjectType("java/lang/Double");
    private static final Type FLOAT_TYPE = Type.getObjectType("java/lang/Float");
    private static final Type INTEGER_TYPE = Type.getObjectType("java/lang/Integer");
    private static final Type LONG_TYPE = Type.getObjectType("java/lang/Long");
    private static final Type SHORT_TYPE = Type.getObjectType("java/lang/Short");
    private static final Type VOID_TYPE = Type.getObjectType("java/lang/Void");
    private String classDesc;
    private Map<String, String> anonymousClassMap;

    public RewriteJsniMethods(ClassVisitor v, Map<String, String> anonymousClassMap) {
        super(589824, v);
        this.anonymousClassMap = anonymousClassMap;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classDesc = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean isNative = (access & 0x100) != 0;
        MethodVisitor mv = super.visitMethod(access &= 0xFFFFFEFF, name, desc, signature, exceptions);
        if (isNative) {
            mv = new MyMethodAdapter(mv, access, name, desc);
        }
        return mv;
    }

    private String getJsniSignature(String name, String descriptor) {
        int argsIndexBegin = descriptor.indexOf(40);
        int argsIndexEnd = descriptor.indexOf(41);
        assert (argsIndexBegin != -1 && argsIndexEnd != -1 && argsIndexBegin < argsIndexEnd) : "Could not find the arguments in the descriptor, " + descriptor;
        String argsDescriptor = descriptor.substring(argsIndexBegin, argsIndexEnd + 1);
        String classDescriptor = Name.InternalName.toBinaryName(this.classDesc);
        String newDescriptor = this.anonymousClassMap.get(this.classDesc);
        if (newDescriptor != null) {
            classDescriptor = Name.InternalName.toBinaryName(newDescriptor);
        }
        return "@" + classDescriptor + "::" + name + argsDescriptor;
    }

    static /* synthetic */ Type access$000() {
        return VOID_TYPE;
    }

    static /* synthetic */ Type access$100() {
        return BOOLEAN_TYPE;
    }

    static /* synthetic */ Type access$200() {
        return CHARACTER_TYPE;
    }

    static /* synthetic */ Type access$300() {
        return BYTE_TYPE;
    }

    static /* synthetic */ Type access$400() {
        return SHORT_TYPE;
    }

    static /* synthetic */ Type access$500() {
        return INTEGER_TYPE;
    }

    static /* synthetic */ Type access$600() {
        return FLOAT_TYPE;
    }

    static /* synthetic */ Type access$700() {
        return LONG_TYPE;
    }

    static /* synthetic */ Type access$800() {
        return DOUBLE_TYPE;
    }

    private class MyMethodAdapter
    extends GeneratorAdapter {
        private String descriptor;
        private boolean isStatic;
        private String name;

        public MyMethodAdapter(MethodVisitor mv, int access, String name, String desc) {
            super(589824, mv, access, name, desc);
            this.descriptor = desc;
            this.name = name;
            this.isStatic = (access & 8) != 0;
        }

        @Override
        public void box(Type type) {
            Method method = Boxing.getBoxMethod(type);
            if (method != null) {
                this.invokeStatic(method.getReturnType(), method);
            }
        }

        @Override
        public void visitCode() {
            super.visitCode();
            String jsniTarget = RewriteJsniMethods.this.getJsniSignature(this.name, this.descriptor);
            this.visitLdcInsn(jsniTarget);
            if (this.isStatic) {
                this.visitInsn(1);
            } else {
                this.loadThis();
            }
            this.loadClassArray();
            this.loadArgArray();
            Type returnType = Type.getReturnType(this.descriptor);
            JavaScriptHostInfo info = JavaScriptHostInfo.get(returnType.getSort());
            this.invokeStatic(JavaScriptHostInfo.TYPE, info.getMethod());
            if (info.requiresCast()) {
                this.checkCast(returnType);
            }
            this.returnValue();
        }

        @Override
        public void visitEnd() {
            this.visitCode();
            int maxStack = 8;
            int maxLocals = 0;
            super.visitMaxs(maxStack, maxLocals);
            super.visitEnd();
        }

        private void loadClassArray() {
            Type[] argTypes = Type.getArgumentTypes(this.descriptor);
            this.push(argTypes.length);
            this.newArray(CLASS_TYPE);
            for (int i = 0; i < argTypes.length; ++i) {
                this.dup();
                this.push(i);
                this.push(argTypes[i]);
                this.arrayStore(CLASS_TYPE);
            }
        }
    }

    private static class JavaScriptHostInfo {
        public static final Type TYPE;
        private static final Class<?>[] INVOKE_NATIVE_PARAM_CLASSES;
        private static final Type[] INVOKE_NATIVE_PARAM_TYPES;
        private static final JavaScriptHostInfo[] SORT_MAP;
        private final Method method;
        private final boolean requiresCast;

        public static JavaScriptHostInfo get(int sortType) {
            assert (sortType >= 0 && sortType < SORT_MAP.length) : "Unexpected JavaScriptHostInfo.get index - " + sortType;
            return SORT_MAP[sortType];
        }

        private static boolean matchesRealMethod(String methodName, Type returnType) {
            try {
                java.lang.reflect.Method method = JavaScriptHost.class.getDeclaredMethod(methodName, INVOKE_NATIVE_PARAM_CLASSES);
                assert ((method.getModifiers() & 8) != 0) : "Was expecting method '" + method + "' to be static";
                Type realReturnType = Type.getType(method.getReturnType());
                return realReturnType.getDescriptor().equals(returnType.getDescriptor());
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return false;
        }

        private static boolean noNulls(Object[] array) {
            for (Object element : array) {
                if (element != null) continue;
                return false;
            }
            return true;
        }

        private JavaScriptHostInfo(Type returnType, String methodName) {
            this(returnType, methodName, false);
        }

        private JavaScriptHostInfo(Type returnType, String methodName, boolean requiresCast) {
            this.requiresCast = requiresCast;
            this.method = new Method(methodName, returnType, INVOKE_NATIVE_PARAM_TYPES);
            assert (JavaScriptHostInfo.matchesRealMethod(methodName, returnType)) : "JavaScriptHostInfo for '" + this + "' does not match real method";
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean requiresCast() {
            return this.requiresCast;
        }

        public String toString() {
            return this.method.toString();
        }

        static {
            JavaScriptHostInfo objectType;
            Class[] primitives;
            TYPE = Type.getType(JavaScriptHost.class);
            INVOKE_NATIVE_PARAM_CLASSES = new Class[]{String.class, Object.class, Class[].class, Object[].class};
            SORT_MAP = new JavaScriptHostInfo[11];
            INVOKE_NATIVE_PARAM_TYPES = new Type[INVOKE_NATIVE_PARAM_CLASSES.length];
            for (int i = 0; i < INVOKE_NATIVE_PARAM_TYPES.length; ++i) {
                JavaScriptHostInfo.INVOKE_NATIVE_PARAM_TYPES[i] = Type.getType(INVOKE_NATIVE_PARAM_CLASSES[i]);
            }
            for (Class c : primitives = new Class[]{Void.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
                Type type = Type.getType(c);
                String typeName = type.getClassName();
                String firstChar = typeName.substring(0, 1).toUpperCase(Locale.ROOT);
                typeName = firstChar + typeName.substring(1);
                JavaScriptHostInfo.SORT_MAP[type.getSort()] = new JavaScriptHostInfo(type, "invokeNative" + typeName);
            }
            JavaScriptHostInfo.SORT_MAP[9] = objectType = new JavaScriptHostInfo(Type.getType(Object.class), "invokeNativeObject", true);
            JavaScriptHostInfo.SORT_MAP[10] = objectType;
            assert (JavaScriptHostInfo.noNulls(SORT_MAP)) : "Did not fully fill in JavaScriptHostInfo.SORT_MAP";
        }
    }

    private static class Boxing {
        private static final Type[] BOXED_TYPES = new Type[]{RewriteJsniMethods.access$000(), RewriteJsniMethods.access$100(), RewriteJsniMethods.access$200(), RewriteJsniMethods.access$300(), RewriteJsniMethods.access$400(), RewriteJsniMethods.access$500(), RewriteJsniMethods.access$600(), RewriteJsniMethods.access$700(), RewriteJsniMethods.access$800()};
        private static final Type[] PRIMITIVE_TYPES = new Type[]{Type.VOID_TYPE, Type.BOOLEAN_TYPE, Type.CHAR_TYPE, Type.BYTE_TYPE, Type.SHORT_TYPE, Type.INT_TYPE, Type.FLOAT_TYPE, Type.LONG_TYPE, Type.DOUBLE_TYPE};
        private static final Method[] SORT_MAP = new Method[11];

        private Boxing() {
        }

        public static Method getBoxMethod(Type type) {
            int sortType = type.getSort();
            assert (sortType >= 0 && sortType < SORT_MAP.length) : "Unexpected JavaScriptHostInfo.get index - " + sortType;
            return SORT_MAP[sortType];
        }

        static {
            assert (PRIMITIVE_TYPES.length == BOXED_TYPES.length);
            for (int i = 0; i < PRIMITIVE_TYPES.length; ++i) {
                Type primitive = PRIMITIVE_TYPES[i];
                Type boxed = BOXED_TYPES[i];
                if (boxed == null) continue;
                Boxing.SORT_MAP[i] = new Method("valueOf", boxed, new Type[]{primitive});
            }
        }
    }
}

