/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.rewrite;

import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.javac.asmbridge.EmptyVisitor;
import com.google.gwt.dev.shell.rewrite.RewriteJsniMethods;
import com.google.gwt.dev.shell.rewrite.RewriteRefsToJsoClasses;
import com.google.gwt.dev.shell.rewrite.RewriteSingleJsoImplDispatches;
import com.google.gwt.dev.shell.rewrite.UseMirroredClasses;
import com.google.gwt.dev.shell.rewrite.WriteJsoImpl;
import com.google.gwt.dev.util.log.speedtracer.DevModeEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Method;

public class HostedModeClassRewriter {
    static final String JAVASCRIPTOBJECT_DESC = "com.google.gwt.core.client.JavaScriptObject".replace('.', '/');
    static final String JAVASCRIPTOBJECT_IMPL_DESC = "com.google.gwt.core.client.JavaScriptObject$".replace('.', '/');
    static final String REFERENCE_FIELD = "hostedModeReference";
    private final Set<String> jsoImplDescs;
    private final Set<String> jsoIntfDescs;
    private final SingleJsoImplData jsoData;
    private final Map<String, List<String>> jsoSuperDescs;
    private InstanceMethodOracle mapper;

    static String addSyntheticThisParam(String owner, String methodDescriptor) {
        return "(L" + owner + ";" + methodDescriptor.substring(1);
    }

    private static String toDescriptor(String jsoSubtype) {
        return jsoSubtype.replace('.', '/');
    }

    public HostedModeClassRewriter(Set<String> jsoSubtypes, Map<String, List<String>> jsoSuperTypes, SingleJsoImplData jsoData, InstanceMethodOracle mapper) {
        HashSet<String> buildJsoIntfDescs = new HashSet<String>();
        HashSet<String> buildJsoImplDescs = new HashSet<String>();
        HashMap<String, List<String>> buildJsoSuperDescs = new HashMap<String, List<String>>();
        for (String jsoSubtype : jsoSubtypes) {
            String desc = HostedModeClassRewriter.toDescriptor(jsoSubtype);
            buildJsoIntfDescs.add(desc);
            buildJsoImplDescs.add(desc + "$");
            List<String> superTypes = jsoSuperTypes.get(jsoSubtype);
            assert (superTypes != null);
            assert (superTypes.size() > 0);
            ListIterator<String> i = superTypes.listIterator();
            while (i.hasNext()) {
                i.set(HostedModeClassRewriter.toDescriptor(i.next()));
            }
            buildJsoSuperDescs.put(desc, Collections.unmodifiableList(superTypes));
        }
        this.jsoIntfDescs = Collections.unmodifiableSet(buildJsoIntfDescs);
        this.jsoImplDescs = Collections.unmodifiableSet(buildJsoImplDescs);
        this.jsoSuperDescs = Collections.unmodifiableMap(buildJsoSuperDescs);
        this.jsoData = jsoData;
        this.mapper = mapper;
    }

    public boolean isJsoImpl(String className) {
        return this.jsoImplDescs.contains(HostedModeClassRewriter.toDescriptor(className));
    }

    public boolean isJsoIntf(String className) {
        return this.jsoIntfDescs.contains(HostedModeClassRewriter.toDescriptor(className));
    }

    public byte[] rewrite(TypeOracle typeOracle, String className, byte[] classBytes, Map<String, String> anonymousClassMap) {
        ClassWriter writer;
        SpeedTracerLogger.Event classBytesRewriteEvent = SpeedTracerLogger.start(DevModeEventType.CLASS_BYTES_REWRITE, "Class Name", className);
        String desc = HostedModeClassRewriter.toDescriptor(className);
        assert (!this.jsoIntfDescs.contains(desc));
        ClassVisitor v = writer = new ClassWriter(0);
        v = new UseMirroredClasses(v, className);
        v = new RewriteSingleJsoImplDispatches(v, typeOracle, this.jsoData);
        v = new RewriteRefsToJsoClasses(v, this.jsoIntfDescs, this.mapper);
        if (this.jsoImplDescs.contains(desc)) {
            v = WriteJsoImpl.create(v, desc, this.jsoIntfDescs, this.mapper, this.jsoData);
        }
        v = new RewriteJsniMethods(v, anonymousClassMap);
        new ClassReader(classBytes).accept(v, 0);
        classBytesRewriteEvent.end(new String[0]);
        return writer.toByteArray();
    }

    public byte[] writeJsoIntf(String className, byte[] classBytes) {
        ClassWriter writer;
        String desc = HostedModeClassRewriter.toDescriptor(className);
        assert (this.jsoIntfDescs.contains(desc));
        assert (this.jsoSuperDescs.containsKey(desc));
        List<String> superDescs = this.jsoSuperDescs.get(desc);
        assert (superDescs != null);
        assert (superDescs.size() > 0);
        final ClassWriter v = writer = new ClassWriter(0);
        String[] interfaces = superDescs.contains("java/lang/Object") ? null : superDescs.toArray(new String[superDescs.size()]);
        ((ClassVisitor)v).visit(49, 513, desc, null, "java/lang/Object", interfaces);
        if (classBytes != null) {
            EmptyVisitor cv = new EmptyVisitor(){

                @Override
                public void visitInnerClass(String name, String outerName, String innerName, int access) {
                    v.visitInnerClass(name, outerName, innerName, access);
                }

                @Override
                public void visitOuterClass(String owner, String name, String desc) {
                    v.visitOuterClass(owner, name, desc);
                }
            };
            new ClassReader(classBytes).accept(cv, 0);
        }
        ((ClassVisitor)v).visitEnd();
        return writer.toByteArray();
    }

    public static interface SingleJsoImplData {
        public List<Method> getDeclarations(String var1);

        public List<Method> getImplementations(String var1);

        public SortedSet<String> getMangledNames();

        public Set<String> getSingleJsoIntfTypes();
    }

    public static interface InstanceMethodOracle {
        public String findOriginalDeclaringClass(String var1, String var2);
    }
}

