/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.remoteui;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.shell.remoteui.ViewerServiceClient;
import com.google.gwt.dev.util.Callback;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.dev.util.log.AbstractTreeLogger;
import java.util.List;

public final class ViewerServiceTreeLogger
extends AbstractTreeLogger {
    private volatile int logHandle = -1;
    private List<Pending> pending = Lists.create();
    private final ViewerServiceClient viewerServiceClient;

    public ViewerServiceTreeLogger(ViewerServiceClient viewerServiceClient) {
        this.viewerServiceClient = viewerServiceClient;
    }

    @Override
    protected AbstractTreeLogger doBranch() {
        return new ViewerServiceTreeLogger(this.viewerServiceClient);
    }

    @Override
    protected void doCommitBranch(AbstractTreeLogger childBeingCommitted, TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        ViewerServiceTreeLogger child = (ViewerServiceTreeLogger)childBeingCommitted;
        if (this.isSent()) {
            this.sendBranch(child, type, msg, caught, helpInfo);
        } else {
            this.pending = Lists.add(this.pending, new PendingBranch(child, type, msg, caught, helpInfo));
        }
    }

    @Override
    protected void doLog(int indexOfLogEntry, TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        if (this.isSent()) {
            this.sendEntry(indexOfLogEntry, type, msg, caught, helpInfo);
        } else {
            this.pending = Lists.add(this.pending, new PendingLog(indexOfLogEntry, type, msg, caught, helpInfo));
        }
    }

    synchronized void initLogHandle(int newLogHandle) {
        assert (!this.isSent());
        this.logHandle = newLogHandle;
        for (Pending item : this.pending) {
            item.send();
        }
        this.pending = null;
    }

    void sendBranch(final ViewerServiceTreeLogger branch, TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        assert (this.isSent());
        this.viewerServiceClient.addLogBranch(branch.getBranchedIndex(), type, msg, caught, helpInfo, this.logHandle, new Callback<Integer>(){

            @Override
            public void onDone(Integer result) {
                branch.initLogHandle(result);
            }

            @Override
            public void onError(Throwable t) {
                System.err.println("An error occurred while attempting to add a log branch.");
                t.printStackTrace(System.err);
            }
        });
    }

    void sendEntry(int indexOfLogEntry, TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        assert (this.isSent());
        this.viewerServiceClient.addLogEntry(indexOfLogEntry, type, msg, caught, helpInfo, this.logHandle);
    }

    private boolean isSent() {
        return this.logHandle >= 0;
    }

    private class PendingLog
    extends Pending {
        protected final int indexOfLogEntry;

        public PendingLog(int indexOfLogEntry, TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
            super(type, msg, caught, helpInfo);
            this.indexOfLogEntry = indexOfLogEntry;
        }

        @Override
        public void send() {
            ViewerServiceTreeLogger.this.sendEntry(this.indexOfLogEntry, this.type, this.msg, this.caught, this.helpInfo);
        }
    }

    private class PendingBranch
    extends Pending {
        public final ViewerServiceTreeLogger branch;

        public PendingBranch(ViewerServiceTreeLogger branch, TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
            super(type, msg, caught, helpInfo);
            this.branch = branch;
        }

        @Override
        public void send() {
            ViewerServiceTreeLogger.this.sendBranch(this.branch, this.type, this.msg, this.caught, this.helpInfo);
        }
    }

    private abstract class Pending {
        protected final Throwable caught;
        protected final TreeLogger.HelpInfo helpInfo;
        protected final String msg;
        protected final TreeLogger.Type type;

        public Pending(TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
            this.caught = caught;
            this.msg = msg;
            this.type = type;
            this.helpInfo = helpInfo;
        }

        public abstract void send();
    }
}

