/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.remoteui;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.protobuf.ByteString;
import com.google.gwt.dev.shell.remoteui.MessageTransport;
import com.google.gwt.dev.shell.remoteui.RemoteMessageProto;
import com.google.gwt.dev.util.Callback;
import com.google.gwt.dev.util.log.AbstractTreeLogger;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class ViewerServiceClient {
    private final MessageTransport transport;
    private final TreeLogger unexpectedErrorLogger;

    public ViewerServiceClient(MessageTransport processor, TreeLogger unexpectedErrorLogger) {
        this.transport = processor;
        this.unexpectedErrorLogger = unexpectedErrorLogger;
    }

    public void addLogBranch(int indexInParent, TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo, int parentLogHandle, final Callback<Integer> callback) {
        RemoteMessageProto.Message.Request.ViewerRequest.LogData.Builder logDataBuilder = this.generateLogData(type, msg, caught, helpInfo);
        RemoteMessageProto.Message.Request.ViewerRequest.AddLogBranch.Builder addlogBranchBuilder = RemoteMessageProto.Message.Request.ViewerRequest.AddLogBranch.newBuilder();
        addlogBranchBuilder.setParentLogHandle(parentLogHandle);
        addlogBranchBuilder.setIndexInParent(indexInParent);
        addlogBranchBuilder.setLogData(logDataBuilder);
        RemoteMessageProto.Message.Request.ViewerRequest.Builder viewerRequestBuilder = RemoteMessageProto.Message.Request.ViewerRequest.newBuilder();
        viewerRequestBuilder.setRequestType(RemoteMessageProto.Message.Request.ViewerRequest.RequestType.ADD_LOG_BRANCH);
        viewerRequestBuilder.setAddLogBranch(addlogBranchBuilder);
        RemoteMessageProto.Message.Request requestMessage = this.buildRequestMessageFromViewerRequest(viewerRequestBuilder).build();
        this.transport.executeRequestAsync(requestMessage, new Callback<RemoteMessageProto.Message.Response>(){

            @Override
            public void onDone(RemoteMessageProto.Message.Response result) {
                callback.onDone(result.getViewerResponse().getAddLogBranch().getLogHandle());
            }

            @Override
            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public void addLogEntry(int indexInParent, TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo, int logHandle) {
        RemoteMessageProto.Message.Request.ViewerRequest.LogData.Builder logDataBuilder = this.generateLogData(type, msg, caught, helpInfo);
        RemoteMessageProto.Message.Request.ViewerRequest.AddLogEntry.Builder addLogEntryBuilder = RemoteMessageProto.Message.Request.ViewerRequest.AddLogEntry.newBuilder();
        addLogEntryBuilder.setLogHandle(logHandle);
        addLogEntryBuilder.setIndexInLog(indexInParent);
        addLogEntryBuilder.setLogData(logDataBuilder);
        RemoteMessageProto.Message.Request.ViewerRequest.Builder viewerRequestBuilder = RemoteMessageProto.Message.Request.ViewerRequest.newBuilder();
        viewerRequestBuilder.setRequestType(RemoteMessageProto.Message.Request.ViewerRequest.RequestType.ADD_LOG_ENTRY);
        viewerRequestBuilder.setAddLogEntry(addLogEntryBuilder);
        RemoteMessageProto.Message.Request requestMessage = this.buildRequestMessageFromViewerRequest(viewerRequestBuilder).build();
        this.transport.executeRequestAsync(requestMessage, new Callback<RemoteMessageProto.Message.Response>(){

            @Override
            public void onDone(RemoteMessageProto.Message.Response result) {
            }

            @Override
            public void onError(Throwable t) {
                ViewerServiceClient.this.unexpectedErrorLogger.log(TreeLogger.WARN, "An error occurred while attempting to add a log entry.", t);
            }
        });
    }

    public int addModuleLog(String remoteSocket, String url, String tabKey, String moduleName, String sessionKey, String agentTag, byte[] agentIcon) {
        RemoteMessageProto.Message.Request.ViewerRequest.AddLog.ModuleLog.Builder moduleLogBuilder = RemoteMessageProto.Message.Request.ViewerRequest.AddLog.ModuleLog.newBuilder();
        moduleLogBuilder.setName(moduleName);
        moduleLogBuilder.setUserAgent(agentTag);
        if (url != null) {
            moduleLogBuilder.setUrl(url);
        }
        moduleLogBuilder.setRemoteHost(remoteSocket);
        moduleLogBuilder.setSessionKey(sessionKey);
        if (tabKey != null) {
            moduleLogBuilder.setTabKey(tabKey);
        }
        if (agentIcon != null) {
            moduleLogBuilder = moduleLogBuilder.setIcon(ByteString.copyFrom(agentIcon));
        }
        RemoteMessageProto.Message.Request.ViewerRequest.AddLog.Builder addLogBuilder = RemoteMessageProto.Message.Request.ViewerRequest.AddLog.newBuilder();
        addLogBuilder.setType(RemoteMessageProto.Message.Request.ViewerRequest.AddLog.LogType.MODULE);
        addLogBuilder.setModuleLog(moduleLogBuilder);
        return this.createLogger(addLogBuilder);
    }

    public void checkCapabilities() {
        RemoteMessageProto.Message.Request.ViewerRequest.CapabilityExchange.Builder capabilityExchangeBuilder = RemoteMessageProto.Message.Request.ViewerRequest.CapabilityExchange.newBuilder();
        RemoteMessageProto.Message.Request.ViewerRequest.Builder viewerRequestBuilder = RemoteMessageProto.Message.Request.ViewerRequest.newBuilder();
        viewerRequestBuilder.setRequestType(RemoteMessageProto.Message.Request.ViewerRequest.RequestType.CAPABILITY_EXCHANGE);
        viewerRequestBuilder.setCapabilityExchange(capabilityExchangeBuilder);
        RemoteMessageProto.Message.Request.Builder request = this.buildRequestMessageFromViewerRequest(viewerRequestBuilder);
        Future<RemoteMessageProto.Message.Response> responseFuture = this.transport.executeRequestAsync(request.build());
        RemoteMessageProto.Message.Response response = this.waitForResponseOrThrowUncheckedException(responseFuture);
        RemoteMessageProto.Message.Response.ViewerResponse.CapabilityExchange capabilityExchangeResponse = response.getViewerResponse().getCapabilityExchange();
        List<RemoteMessageProto.Message.Response.ViewerResponse.CapabilityExchange.Capability> capabilityList = capabilityExchangeResponse.getCapabilitiesList();
        this.checkCapability(capabilityList, RemoteMessageProto.Message.Request.ViewerRequest.RequestType.ADD_LOG);
        this.checkCapability(capabilityList, RemoteMessageProto.Message.Request.ViewerRequest.RequestType.ADD_LOG_BRANCH);
        this.checkCapability(capabilityList, RemoteMessageProto.Message.Request.ViewerRequest.RequestType.ADD_LOG_BRANCH);
        this.checkCapability(capabilityList, RemoteMessageProto.Message.Request.ViewerRequest.RequestType.DISCONNECT_LOG);
    }

    public void disconnectLog(int logHandle) {
        RemoteMessageProto.Message.Request.ViewerRequest.DisconnectLog.Builder disconnectLogbuilder = RemoteMessageProto.Message.Request.ViewerRequest.DisconnectLog.newBuilder();
        disconnectLogbuilder.setLogHandle(logHandle);
        RemoteMessageProto.Message.Request.ViewerRequest.Builder viewerRequestBuilder = RemoteMessageProto.Message.Request.ViewerRequest.newBuilder();
        viewerRequestBuilder.setRequestType(RemoteMessageProto.Message.Request.ViewerRequest.RequestType.DISCONNECT_LOG);
        viewerRequestBuilder.setDisconnectLog(disconnectLogbuilder);
        RemoteMessageProto.Message.Request.Builder request = this.buildRequestMessageFromViewerRequest(viewerRequestBuilder);
        Future<RemoteMessageProto.Message.Response> responseFuture = this.transport.executeRequestAsync(request.build());
        this.waitForResponseOrThrowUncheckedException(responseFuture);
    }

    public void initialize(String clientId, List<String> startupURLs) {
        RemoteMessageProto.Message.Request.ViewerRequest.Initialize.Builder initializationBuilder = RemoteMessageProto.Message.Request.ViewerRequest.Initialize.newBuilder();
        initializationBuilder.setClientId(clientId);
        initializationBuilder.addAllStartupURLs(startupURLs);
        RemoteMessageProto.Message.Request.ViewerRequest.Builder viewerRequestBuilder = RemoteMessageProto.Message.Request.ViewerRequest.newBuilder();
        viewerRequestBuilder.setRequestType(RemoteMessageProto.Message.Request.ViewerRequest.RequestType.INITIALIZE);
        viewerRequestBuilder.setInitialize(initializationBuilder);
        RemoteMessageProto.Message.Request.Builder request = this.buildRequestMessageFromViewerRequest(viewerRequestBuilder);
        Future<RemoteMessageProto.Message.Response> responseFuture = this.transport.executeRequestAsync(request.build());
        this.waitForResponseOrThrowUncheckedException(responseFuture);
    }

    private RemoteMessageProto.Message.Request.Builder buildRequestMessageFromViewerRequest(RemoteMessageProto.Message.Request.ViewerRequest.Builder viewerRequestBuilder) {
        return RemoteMessageProto.Message.Request.newBuilder().setServiceType(RemoteMessageProto.Message.Request.ServiceType.VIEWER).setViewerRequest(viewerRequestBuilder);
    }

    private void checkCapability(List<RemoteMessageProto.Message.Response.ViewerResponse.CapabilityExchange.Capability> viewerCapabilityList, RemoteMessageProto.Message.Request.ViewerRequest.RequestType capabilityWeNeed) {
        for (RemoteMessageProto.Message.Response.ViewerResponse.CapabilityExchange.Capability c : viewerCapabilityList) {
            if (c.getCapability() != capabilityWeNeed) continue;
            return;
        }
        throw new RuntimeException("ViewerService does not support " + capabilityWeNeed.toString());
    }

    private int createLogger(RemoteMessageProto.Message.Request.ViewerRequest.AddLog.Builder addLogBuilder) {
        RemoteMessageProto.Message.Request.ViewerRequest.Builder viewerRequestBuilder = RemoteMessageProto.Message.Request.ViewerRequest.newBuilder();
        viewerRequestBuilder.setRequestType(RemoteMessageProto.Message.Request.ViewerRequest.RequestType.ADD_LOG);
        viewerRequestBuilder.setAddLog(addLogBuilder);
        RemoteMessageProto.Message.Request.Builder request = this.buildRequestMessageFromViewerRequest(viewerRequestBuilder);
        Future<RemoteMessageProto.Message.Response> responseFuture = this.transport.executeRequestAsync(request.build());
        return this.waitForResponseOrThrowUncheckedException(responseFuture).getViewerResponse().getAddLog().getLogHandle();
    }

    private RemoteMessageProto.Message.Request.ViewerRequest.LogData.Builder generateLogData(TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        String stackTraceAsString;
        RemoteMessageProto.Message.Request.ViewerRequest.LogData.Builder logBuilder = RemoteMessageProto.Message.Request.ViewerRequest.LogData.newBuilder().setSummary(msg);
        logBuilder.setLevel(type.getLabel());
        if (caught != null && (stackTraceAsString = AbstractTreeLogger.getStackTraceAsString(caught)) != null) {
            logBuilder = logBuilder.setDetails(stackTraceAsString);
        }
        if (helpInfo != null) {
            RemoteMessageProto.Message.Request.ViewerRequest.LogData.HelpInfo.Builder helpInfoBuilder = RemoteMessageProto.Message.Request.ViewerRequest.LogData.HelpInfo.newBuilder();
            if (helpInfo.getURL() != null) {
                helpInfoBuilder.setUrl(helpInfo.getURL().toExternalForm());
            }
            if (helpInfo.getAnchorText() != null) {
                helpInfoBuilder.setText(helpInfo.getAnchorText());
            }
            logBuilder.setHelpInfo(helpInfoBuilder);
        }
        if (type.needsAttention()) {
            logBuilder.setNeedsAttention(true);
        }
        return logBuilder;
    }

    private RemoteMessageProto.Message.Response waitForResponse(Future<RemoteMessageProto.Message.Response> future) throws MessageTransport.RequestException {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MessageTransport.RequestException) {
                throw (MessageTransport.RequestException)cause;
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private RemoteMessageProto.Message.Response waitForResponseOrThrowUncheckedException(Future<RemoteMessageProto.Message.Response> future) {
        try {
            return this.waitForResponse(future);
        }
        catch (MessageTransport.RequestException e) {
            throw new RuntimeException(e);
        }
    }
}

