/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.remoteui;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.ModuleHandle;
import com.google.gwt.dev.shell.remoteui.DevModeServiceRequestProcessor;
import com.google.gwt.dev.shell.remoteui.MessageTransport;
import com.google.gwt.dev.shell.remoteui.ViewerServiceClient;
import com.google.gwt.dev.shell.remoteui.ViewerServiceTreeLogger;
import com.google.gwt.dev.ui.DevModeUI;
import com.google.gwt.dev.ui.DoneCallback;
import com.google.gwt.dev.ui.DoneEvent;
import com.google.gwt.dev.ui.RestartServerCallback;
import com.google.gwt.dev.ui.RestartServerEvent;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RemoteUI
extends DevModeUI
implements MessageTransport.ErrorCallback {
    private final String clientId;
    private final DevModeServiceRequestProcessor devModeRequestProcessor;
    private final List<ModuleHandle> modules = new ArrayList<ModuleHandle>();
    private final Object modulesLock = new Object();
    private final Socket transportSocket;
    private final MessageTransport transport;
    private ViewerServiceClient viewerServiceClient = null;
    private final List<String> cachedStartupUrls = new ArrayList<String>();

    public RemoteUI(String host, int port, String clientId) {
        try {
            this.clientId = clientId;
            this.transportSocket = new Socket(host, port);
            this.transportSocket.setKeepAlive(true);
            this.transportSocket.setTcpNoDelay(true);
            this.devModeRequestProcessor = new DevModeServiceRequestProcessor(this);
            this.transport = new MessageTransport(this.transportSocket.getInputStream(), this.transportSocket.getOutputStream(), this.devModeRequestProcessor, this);
            this.transport.start();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleHandle getModuleLogger(String userAgent, String remoteSocket, String url, String tabKey, String moduleName, String sessionKey, String agentTag, byte[] agentIcon, TreeLogger.Type logLevel) {
        final int logHandle = this.viewerServiceClient.addModuleLog(remoteSocket, url, tabKey, moduleName, sessionKey, agentTag, agentIcon);
        final ViewerServiceTreeLogger moduleLogger = new ViewerServiceTreeLogger(this.viewerServiceClient);
        moduleLogger.initLogHandle(logHandle);
        moduleLogger.setMaxDetail(this.getLogLevel());
        ModuleHandle handle = new ModuleHandle(){

            @Override
            public TreeLogger getLogger() {
                return moduleLogger;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unload() {
                Object object = RemoteUI.this.modulesLock;
                synchronized (object) {
                    if (!RemoteUI.this.modules.contains(this)) {
                        return;
                    }
                }
                try {
                    RemoteUI.this.viewerServiceClient.disconnectLog(logHandle);
                }
                finally {
                    object = RemoteUI.this.modulesLock;
                    synchronized (object) {
                        RemoteUI.this.modules.remove(this);
                    }
                }
            }
        };
        Object object = this.modulesLock;
        synchronized (object) {
            this.modules.add(handle);
        }
        if (moduleLogger.isLoggable(TreeLogger.SPAM)) {
            if (url != null) {
                moduleLogger.log(TreeLogger.SPAM, "Top URL: " + url);
            }
            moduleLogger.log(TreeLogger.SPAM, "User agent: " + userAgent);
            moduleLogger.log(TreeLogger.SPAM, "Remote socket: " + remoteSocket);
            if (tabKey != null) {
                moduleLogger.log(TreeLogger.SPAM, "Tab key: " + tabKey);
            }
            if (sessionKey != null) {
                moduleLogger.log(TreeLogger.SPAM, "Session key: " + sessionKey);
            }
        }
        return handle;
    }

    @Override
    public TreeLogger getWebServerLogger(String serverName, byte[] serverIcon) {
        return this.getConsoleLogger();
    }

    @Override
    public void moduleLoadComplete(boolean success) {
        this.viewerServiceClient = new ViewerServiceClient(this.transport, this.getTopLogger());
        this.viewerServiceClient.initialize(this.clientId, this.cachedStartupUrls);
        this.viewerServiceClient.checkCapabilities();
    }

    @Override
    public void onResponseException(Exception e) {
        this.getTopLogger().log(TreeLogger.INFO, "An exception occured while attempting to send a response message.", e);
    }

    @Override
    public void onTermination(Exception e) {
        this.getConsoleLogger().log(TreeLogger.INFO, "Remote UI connection terminated due to exception: " + e);
        this.getConsoleLogger().log(TreeLogger.INFO, "Shutting down development mode server.");
        try {
            this.transportSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((DoneCallback)this.getCallback(DoneEvent.getType())).onDone();
    }

    public boolean restartWebServer() {
        TreeLogger webServerLogger = this.getConsoleLogger();
        assert (webServerLogger != null);
        RestartServerCallback callback = (RestartServerCallback)this.getCallback(RestartServerEvent.getType());
        if (callback != null) {
            callback.onRestartServer(webServerLogger);
            return true;
        }
        return false;
    }

    @Override
    public void setStartupUrls(Map<String, URL> urls) {
        for (URL url : urls.values()) {
            this.cachedStartupUrls.add(url.toExternalForm());
        }
        super.setStartupUrls(urls);
    }
}

