/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.remoteui;

import com.google.gwt.dev.shell.remoteui.RemoteMessageProto;
import com.google.gwt.dev.shell.remoteui.RequestProcessor;
import com.google.gwt.dev.util.Callback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MessageTransport {
    private static final Callable<RemoteMessageProto.Message.Response> DUMMY_CALLABLE = new Callable<RemoteMessageProto.Message.Response>(){

        @Override
        public RemoteMessageProto.Message.Response call() throws Exception {
            return null;
        }
    };
    private final InputStream inputStream;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final AtomicInteger nextMessageId = new AtomicInteger();
    private final OutputStream outputStream;
    private final PendingRequestMap pendingRequestMap = new PendingRequestMap();
    private final RequestProcessor requestProcessor;
    private final LinkedBlockingQueue<PendingSend> sendQueue = new LinkedBlockingQueue();
    private final ErrorCallback errorCallback;

    public MessageTransport(InputStream inputStream, OutputStream outputStream, RequestProcessor requestProcessor, ErrorCallback errorCallback) {
        this.requestProcessor = requestProcessor;
        this.errorCallback = errorCallback;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public Future<RemoteMessageProto.Message.Response> executeRequestAsync(RemoteMessageProto.Message.Request requestMessage) {
        RemoteMessageProto.Message.Builder messageBuilder = RemoteMessageProto.Message.newBuilder();
        int messageId = this.nextMessageId.getAndIncrement();
        messageBuilder.setMessageId(messageId);
        messageBuilder.setMessageType(RemoteMessageProto.Message.MessageType.REQUEST);
        messageBuilder.setRequest(requestMessage);
        RemoteMessageProto.Message message = messageBuilder.build();
        class FutureTaskExtension
        extends FutureTask<RemoteMessageProto.Message.Response> {
            FutureTaskExtension() {
                super(DUMMY_CALLABLE);
            }

            @Override
            public void set(RemoteMessageProto.Message.Response v) {
                super.set(v);
            }

            @Override
            public void setException(Throwable t) {
                super.setException(t);
            }
        }
        final FutureTaskExtension future = new FutureTaskExtension();
        PendingRequest pendingRequest = new PendingRequest(message, new Callback<RemoteMessageProto.Message.Response>(){
            {
            }

            @Override
            public void onDone(RemoteMessageProto.Message.Response result) {
                future.set(result);
            }

            @Override
            public void onError(Throwable t) {
                future.setException(t);
            }
        });
        this.sendQueue.add(pendingRequest);
        return future;
    }

    public void executeRequestAsync(RemoteMessageProto.Message.Request requestMessage, Callback<RemoteMessageProto.Message.Response> callback) {
        RemoteMessageProto.Message.Builder messageBuilder = RemoteMessageProto.Message.newBuilder();
        int messageId = this.nextMessageId.getAndIncrement();
        messageBuilder.setMessageId(messageId);
        messageBuilder.setMessageType(RemoteMessageProto.Message.MessageType.REQUEST);
        messageBuilder.setRequest(requestMessage);
        RemoteMessageProto.Message message = messageBuilder.build();
        PendingRequest pendingRequest = new PendingRequest(message, callback);
        this.sendQueue.add(pendingRequest);
    }

    public void start() {
        if (this.isStarted.getAndSet(true)) {
            return;
        }
        Thread messageProcessingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        RemoteMessageProto.Message message;
                        if ((message = RemoteMessageProto.Message.parseDelimitedFrom(MessageTransport.this.inputStream)) == null) {
                            throw new IOException("Attempt to read past EOF");
                        }
                        MessageTransport.this.processMessage(message);
                    }
                }
                catch (IOException e) {
                    MessageTransport.this.terminateDueToException(e);
                }
                catch (InterruptedException e) {
                    MessageTransport.this.terminateDueToException(e);
                }
            }
        });
        messageProcessingThread.start();
        Thread sendThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block4: while (true) {
                    try {
                        while (true) {
                            PendingSend pendingSend = (PendingSend)MessageTransport.this.sendQueue.take();
                            try {
                                pendingSend.send(MessageTransport.this.outputStream);
                                continue block4;
                            }
                            catch (IOException e) {
                                pendingSend.failed(e);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        });
        sendThread.setDaemon(true);
        sendThread.start();
    }

    private void processClientRequest(int messageId, RemoteMessageProto.Message.Request request) throws InterruptedException {
        RemoteMessageProto.Message.Builder messageBuilder = RemoteMessageProto.Message.newBuilder();
        messageBuilder.setMessageId(messageId);
        RemoteMessageProto.Message.Response response = null;
        try {
            messageBuilder.setMessageType(RemoteMessageProto.Message.MessageType.RESPONSE);
            response = this.requestProcessor.execute(request);
            messageBuilder.setResponse(response);
        }
        catch (Exception e) {
            messageBuilder.setMessageType(RemoteMessageProto.Message.MessageType.FAILURE);
            RemoteMessageProto.Message.Failure.Builder failureMessage = RemoteMessageProto.Message.Failure.newBuilder();
            failureMessage.setMessage(e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getClass().getName());
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            failureMessage.setStackTrace(sw.getBuffer().toString());
            messageBuilder.setFailure(failureMessage);
        }
        PendingResponse pendingResponse = new PendingResponse(messageBuilder.build());
        this.sendQueue.put(pendingResponse);
    }

    private void processFailure(int messageId, RemoteMessageProto.Message.Failure failure) {
        PendingRequest pendingServerRequest = this.pendingRequestMap.remove(messageId);
        if (pendingServerRequest != null) {
            pendingServerRequest.failed(new RequestException(failure));
        }
    }

    private void processMessage(RemoteMessageProto.Message message) throws InterruptedException {
        RemoteMessageProto.Message.MessageType messageType = message.getMessageType();
        if (messageType == null) {
            this.processUnknownMessageType(message.getMessageId(), "unknown");
            return;
        }
        switch (messageType) {
            case RESPONSE: {
                this.processServerResponse(message.getMessageId(), message.getResponse());
                break;
            }
            case REQUEST: {
                this.processClientRequest(message.getMessageId(), message.getRequest());
                break;
            }
            case FAILURE: {
                this.processFailure(message.getMessageId(), message.getFailure());
                break;
            }
            default: {
                this.processUnknownMessageType(message.getMessageId(), messageType.name());
            }
        }
    }

    private void processServerResponse(int messageId, RemoteMessageProto.Message.Response response) {
        PendingRequest pendingServerRequest = this.pendingRequestMap.remove(messageId);
        if (pendingServerRequest != null) {
            pendingServerRequest.setResponse(response);
        }
    }

    private void processUnknownMessageType(int messageId, String messageTypeName) throws InterruptedException {
        RemoteMessageProto.Message.Builder messageBuilder = RemoteMessageProto.Message.newBuilder();
        messageBuilder.setMessageId(messageId);
        messageBuilder.setMessageType(RemoteMessageProto.Message.MessageType.FAILURE);
        RemoteMessageProto.Message.Failure.Builder failureMessage = RemoteMessageProto.Message.Failure.newBuilder();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Unknown message type '");
        stringBuffer.append(messageTypeName);
        stringBuffer.append("'. Known message types are: ");
        for (RemoteMessageProto.Message.MessageType type : RemoteMessageProto.Message.MessageType.values()) {
            stringBuffer.append(type.name());
            stringBuffer.append(" ");
        }
        failureMessage.setMessage(stringBuffer.toString());
        messageBuilder.setFailure(failureMessage);
        PendingResponse pendingResponse = new PendingResponse(messageBuilder.build());
        this.sendQueue.put(pendingResponse);
    }

    private void terminateDueToException(Exception e) {
        this.pendingRequestMap.blockAdds(e);
        if (this.errorCallback != null) {
            this.errorCallback.onTermination(e);
        }
    }

    abstract class PendingSend {
        PendingSend() {
        }

        abstract void failed(Exception var1);

        abstract void send(OutputStream var1) throws IOException;
    }

    class PendingResponse
    extends PendingSend {
        RemoteMessageProto.Message message;

        public PendingResponse(RemoteMessageProto.Message message) {
            this.message = message;
        }

        @Override
        public void failed(Exception e) {
            if (MessageTransport.this.errorCallback != null) {
                MessageTransport.this.errorCallback.onResponseException(e);
            }
        }

        @Override
        public void send(OutputStream outputStream) throws IOException {
            this.message.writeDelimitedTo(outputStream);
        }
    }

    static class PendingRequestMap {
        private final Lock mapLock = new ReentrantLock();
        private boolean noMoreAdds;
        private final Map<Integer, PendingRequest> requestIdToPendingServerRequest = new HashMap<Integer, PendingRequest>();

        PendingRequestMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void blockAdds(Exception e) {
            this.mapLock.lock();
            try {
                this.noMoreAdds = true;
                for (PendingRequest pendingRequest : this.requestIdToPendingServerRequest.values()) {
                    pendingRequest.failed(e);
                }
            }
            finally {
                this.mapLock.unlock();
            }
        }

        public PendingRequest remove(int requestId) {
            this.mapLock.lock();
            try {
                PendingRequest pendingRequest = this.requestIdToPendingServerRequest.remove(requestId);
                return pendingRequest;
            }
            finally {
                this.mapLock.unlock();
            }
        }

        void put(int requestId, PendingRequest pendingServerRequest) {
            this.mapLock.lock();
            try {
                if (this.noMoreAdds) {
                    pendingServerRequest.failed(new IllegalStateException("InputStream is closed"));
                } else {
                    this.requestIdToPendingServerRequest.put(requestId, pendingServerRequest);
                }
            }
            finally {
                this.mapLock.unlock();
            }
        }
    }

    class PendingRequest
    extends PendingSend {
        private final Callback<RemoteMessageProto.Message.Response> callback;
        private final RemoteMessageProto.Message message;

        PendingRequest(RemoteMessageProto.Message message, Callback<RemoteMessageProto.Message.Response> callback) {
            this.message = message;
            this.callback = callback;
        }

        @Override
        void failed(Exception e) {
            assert (e != null);
            MessageTransport.this.pendingRequestMap.remove(this.message.getMessageId());
            this.callback.onError(e);
        }

        @Override
        void send(OutputStream outputStream) throws IOException {
            int messageId = this.message.getMessageId();
            MessageTransport.this.pendingRequestMap.put(messageId, this);
            this.message.writeDelimitedTo(outputStream);
        }

        void setResponse(RemoteMessageProto.Message.Response responseMessage) {
            assert (responseMessage != null);
            this.callback.onDone(responseMessage);
        }
    }

    public class RequestException
    extends Exception {
        private final RemoteMessageProto.Message.Failure failureMessage;

        public RequestException(RemoteMessageProto.Message.Failure failureMessage) {
            super(failureMessage.getMessage());
            this.failureMessage = failureMessage;
        }

        public RemoteMessageProto.Message.Failure getFailureMessage() {
            return this.failureMessage;
        }
    }

    public static interface ErrorCallback {
        public void onResponseException(Exception var1);

        public void onTermination(Exception var1);
    }
}

