/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.remoteui;

import com.google.gwt.dev.shell.remoteui.RemoteMessageProto;
import com.google.gwt.dev.shell.remoteui.RemoteUI;
import com.google.gwt.dev.shell.remoteui.RequestProcessor;

public class DevModeServiceRequestProcessor
implements RequestProcessor {
    private final RemoteUI remoteUI;

    public DevModeServiceRequestProcessor(RemoteUI remoteUI) {
        this.remoteUI = remoteUI;
    }

    @Override
    public RemoteMessageProto.Message.Response execute(RemoteMessageProto.Message.Request request) throws Exception {
        if (request.getServiceType() != RemoteMessageProto.Message.Request.ServiceType.DEV_MODE) {
            throw new IllegalArgumentException("Unknown Service Type: This request processor cannot handle requests of type " + request.getServiceType().name());
        }
        RemoteMessageProto.Message.Request.DevModeRequest.RequestType requestType = request.getDevModeRequest().getRequestType();
        if (requestType != null) {
            switch (requestType) {
                case CAPABILITY_EXCHANGE: {
                    return this.processCapabilityExchange();
                }
                case RESTART_WEB_SERVER: {
                    return this.processRestartServer();
                }
            }
        }
        throw new IllegalArgumentException("Unknown DevModeService Request: The DevModeService cannot handle requests of type " + requestType == null ? "(unknown)" : requestType.name());
    }

    private RemoteMessageProto.Message.Response processCapabilityExchange() {
        RemoteMessageProto.Message.Response.DevModeResponse.CapabilityExchange.Builder capabilityExchangeBuilder = RemoteMessageProto.Message.Response.DevModeResponse.CapabilityExchange.newBuilder();
        RemoteMessageProto.Message.Response.DevModeResponse.CapabilityExchange.Capability.Builder c1Builder = RemoteMessageProto.Message.Response.DevModeResponse.CapabilityExchange.Capability.newBuilder();
        c1Builder.setCapability(RemoteMessageProto.Message.Request.DevModeRequest.RequestType.CAPABILITY_EXCHANGE);
        capabilityExchangeBuilder.addCapabilities(c1Builder);
        RemoteMessageProto.Message.Response.DevModeResponse.CapabilityExchange.Capability.Builder c2Builder = RemoteMessageProto.Message.Response.DevModeResponse.CapabilityExchange.Capability.newBuilder();
        c2Builder.setCapability(RemoteMessageProto.Message.Request.DevModeRequest.RequestType.RESTART_WEB_SERVER);
        capabilityExchangeBuilder.addCapabilities(c2Builder);
        RemoteMessageProto.Message.Response.DevModeResponse.Builder devModeResponseBuilder = RemoteMessageProto.Message.Response.DevModeResponse.newBuilder();
        devModeResponseBuilder.setResponseType(RemoteMessageProto.Message.Response.DevModeResponse.ResponseType.CAPABILITY_EXCHANGE);
        devModeResponseBuilder.setCapabilityExchange(capabilityExchangeBuilder);
        RemoteMessageProto.Message.Response.Builder responseBuilder = RemoteMessageProto.Message.Response.newBuilder();
        responseBuilder.setDevModeResponse(devModeResponseBuilder);
        return responseBuilder.build();
    }

    private RemoteMessageProto.Message.Response processRestartServer() {
        if (!this.remoteUI.restartWebServer()) {
            throw new IllegalStateException("Unable to restart the web server. It is still in the process of starting up. Wait a few seconds and try again.");
        }
        RemoteMessageProto.Message.Response.DevModeResponse.Builder devModeResponseBuilder = RemoteMessageProto.Message.Response.DevModeResponse.newBuilder();
        devModeResponseBuilder.setResponseType(RemoteMessageProto.Message.Response.DevModeResponse.ResponseType.RESTART_WEB_SERVER);
        RemoteMessageProto.Message.Response.Builder responseBuilder = RemoteMessageProto.Message.Response.newBuilder();
        responseBuilder.setDevModeResponse(devModeResponseBuilder);
        return responseBuilder.build();
    }
}

