/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.log;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.shell.Icons;
import com.google.gwt.dev.shell.log.SwingLoggerPanel;
import com.google.gwt.dev.util.log.AbstractTreeLogger;
import java.awt.Color;
import java.awt.EventQueue;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;

public final class SwingTreeLogger
extends AbstractTreeLogger {
    final DefaultMutableTreeNode treeNode;
    private SwingLoggerPanel panel;

    public SwingTreeLogger(SwingLoggerPanel panel) {
        this(panel, (DefaultMutableTreeNode)panel.treeModel.getRoot());
    }

    private SwingTreeLogger(SwingLoggerPanel panel, DefaultMutableTreeNode treeNode) {
        this.panel = panel;
        this.treeNode = treeNode;
    }

    @Override
    protected AbstractTreeLogger doBranch() {
        SwingTreeLogger newLogger = new SwingTreeLogger(this.panel, new DefaultMutableTreeNode(null));
        return newLogger;
    }

    @Override
    protected void doCommitBranch(AbstractTreeLogger childBeingCommitted, TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        SwingTreeLogger commitChild = (SwingTreeLogger)childBeingCommitted;
        assert (commitChild.treeNode.getUserObject() == null);
        this.addUpdate(new LogEvent(commitChild, true, commitChild.getBranchedIndex(), type, msg, caught, helpInfo));
    }

    @Override
    protected void doLog(int index, TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        this.addUpdate(new LogEvent(this, false, index, type, msg, caught, helpInfo));
    }

    private void addUpdate(final LogEvent logEvent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogEvent parentEvent;
                DefaultMutableTreeNode node;
                int idx;
                DefaultMutableTreeNode parentNode;
                SwingTreeLogger logger = logEvent.childLogger;
                if (logEvent.isBranchCommit) {
                    SwingTreeLogger parentLogger = (SwingTreeLogger)logger.getParentLogger();
                    logger.treeNode.setUserObject(logEvent);
                    parentNode = parentLogger.treeNode;
                    idx = logger.getBranchedIndex();
                    node = logger.treeNode;
                } else {
                    parentNode = logger.treeNode;
                    idx = logEvent.index;
                    node = new DefaultMutableTreeNode(logEvent);
                }
                int insertIndex = this.findInsertionPoint(parentNode, idx);
                ((SwingTreeLogger)SwingTreeLogger.this).panel.treeModel.insertNodeInto(node, parentNode, insertIndex);
                if (parentNode == ((SwingTreeLogger)SwingTreeLogger.this).panel.treeModel.getRoot() && parentNode.getChildCount() == 1) {
                    ((SwingTreeLogger)SwingTreeLogger.this).panel.treeModel.reload();
                }
                TreeLogger.Type priority = logEvent.getInheritedPriority();
                while (parentNode != ((SwingTreeLogger)SwingTreeLogger.this).panel.treeModel.getRoot() && (parentEvent = (LogEvent)parentNode.getUserObject()).updateInheritedPriority(priority)) {
                    parentNode = (DefaultMutableTreeNode)parentNode.getParent();
                }
            }

            private int findInsertionPoint(DefaultMutableTreeNode parentNode, int index) {
                int high = parentNode.getChildCount() - 1;
                if (high < 0) {
                    return 0;
                }
                int low = 0;
                while (low <= high) {
                    int mid = low + (high - low >> 1);
                    DefaultMutableTreeNode midChild = (DefaultMutableTreeNode)parentNode.getChildAt(mid);
                    Object userObject = midChild.getUserObject();
                    int compIdx = -1;
                    if (userObject instanceof LogEvent) {
                        LogEvent event = (LogEvent)userObject;
                        compIdx = event.index;
                    }
                    if (compIdx < index) {
                        low = mid + 1;
                        continue;
                    }
                    if (compIdx > index) {
                        high = mid - 1;
                        continue;
                    }
                    return mid;
                }
                return low;
            }
        });
    }

    public static class LogEvent {
        private static final Color DEBUG_COLOR = Color.decode("0x007777");
        private static final Date firstLog = new Date();
        private static final Map<TreeLogger.Type, Color> logColors = new HashMap<TreeLogger.Type, Color>();
        private static final Map<TreeLogger.Type, Icon> logIcons = new HashMap<TreeLogger.Type, Icon>();
        private static NumberFormat minHr = NumberFormat.getIntegerInstance();
        private static NumberFormat seconds = NumberFormat.getNumberInstance();
        private static final Color SPAM_COLOR = Color.decode("0x005500");
        private static final Color WARN_COLOR = Color.decode("0x888800");
        public final SwingTreeLogger childLogger;
        public final String exceptionDetail;
        public final String exceptionName;
        public final TreeLogger.HelpInfo helpInfo;
        public final int index;
        public final boolean isBranchCommit;
        public final String message;
        public final Date timestamp;
        public final TreeLogger.Type type;
        private TreeLogger.Type inheritedPriority;

        public LogEvent(SwingTreeLogger logger, boolean isBranchCommit, int index, TreeLogger.Type type, String message, Throwable caught, TreeLogger.HelpInfo helpInfo) {
            this.childLogger = logger;
            this.isBranchCommit = isBranchCommit;
            this.index = index;
            this.type = type;
            this.inheritedPriority = type;
            this.message = message;
            this.helpInfo = helpInfo;
            this.timestamp = new Date();
            this.exceptionDetail = AbstractTreeLogger.getStackTraceAsString(caught);
            this.exceptionName = SwingTreeLogger.getExceptionName(caught);
        }

        public String getFullText() {
            StringBuffer sb = new StringBuffer();
            this.formatTimestamp(this.timestamp.getTime() - firstLog.getTime(), sb);
            sb.append("  ");
            if (this.type != null) {
                sb.append("[");
                sb.append(this.type.getLabel());
                sb.append("] ");
            }
            sb.append(this.htmlEscape(this.message));
            sb.append("\n");
            if (this.exceptionDetail != null) {
                sb.append("<pre>" + this.htmlEscape(this.exceptionDetail) + "</pre>");
            }
            if (this.helpInfo != null) {
                URL url = this.helpInfo.getURL();
                String anchorText = this.helpInfo.getAnchorText();
                if (anchorText == null && url != null) {
                    anchorText = url.toExternalForm();
                }
                String prefix = this.helpInfo.getPrefix();
                if (url != null) {
                    sb.append("<p>" + prefix + "<a href=\"");
                    sb.append(url.toString());
                    sb.append("\">");
                    sb.append(anchorText);
                    sb.append("</a>");
                    sb.append("\n");
                }
            }
            return sb.toString();
        }

        public TreeLogger.Type getInheritedPriority() {
            return this.inheritedPriority;
        }

        public void setDisplayProperties(JLabel treeLabel) {
            Icon image = logIcons.get((Object)this.type);
            Color color = logColors.get((Object)this.inheritedPriority);
            if (color == null) {
                color = Color.BLACK;
            }
            treeLabel.setForeground(color);
            treeLabel.setIcon(image);
            StringBuffer sb = new StringBuffer();
            this.formatTimestamp(this.timestamp.getTime() - firstLog.getTime(), sb);
            sb.append("  ");
            if (this.type != null) {
                sb.append("[");
                sb.append(this.type.getLabel());
                sb.append("] ");
            }
            sb.append(this.message);
            if (this.exceptionName != null) {
                sb.append(" -- exception: " + this.exceptionName);
            }
            treeLabel.setText(sb.toString());
        }

        public String toString() {
            String s = "";
            s = s + "[logger " + this.childLogger.toString();
            s = s + ", " + (this.isBranchCommit ? "BRANCH" : "LOG");
            s = s + ", index " + this.index;
            s = s + ", type " + this.type.toString();
            s = s + ", msg '" + this.message + "'";
            s = s + "]";
            return s;
        }

        public boolean updateInheritedPriority(TreeLogger.Type childPriority) {
            if (this.inheritedPriority.isLowerPriorityThan(childPriority)) {
                this.inheritedPriority = childPriority;
                return true;
            }
            return false;
        }

        private void formatTimestamp(long ts, StringBuffer sb) {
            sb.append(minHr.format(ts / 3600000L));
            sb.append(':');
            sb.append(minHr.format(ts / 60000L % 60L));
            sb.append(':');
            sb.append(seconds.format((double)(ts % 60000L) / 1000.0));
        }

        private String htmlEscape(String str) {
            return str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<br>");
        }

        static {
            seconds.setMinimumFractionDigits(3);
            seconds.setMaximumFractionDigits(3);
            seconds.setMinimumIntegerDigits(2);
            minHr.setMinimumIntegerDigits(2);
            logColors.put(TreeLogger.ERROR, Color.RED);
            logIcons.put(TreeLogger.ERROR, Icons.getLogItemError());
            logColors.put(TreeLogger.WARN, WARN_COLOR);
            logIcons.put(TreeLogger.WARN, Icons.getLogItemWarning());
            logColors.put(TreeLogger.INFO, Color.BLACK);
            logIcons.put(TreeLogger.INFO, Icons.getLogItemInfo());
            logColors.put(TreeLogger.TRACE, Color.DARK_GRAY);
            logIcons.put(TreeLogger.TRACE, Icons.getLogItemTrace());
            logColors.put(TreeLogger.DEBUG, DEBUG_COLOR);
            logIcons.put(TreeLogger.DEBUG, Icons.getLogItemDebug());
            logColors.put(TreeLogger.SPAM, SPAM_COLOR);
            logIcons.put(TreeLogger.SPAM, Icons.getLogItemSpam());
        }
    }
}

