/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.log;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.BootStrapPlatform;
import com.google.gwt.dev.shell.CloseButton;
import com.google.gwt.dev.shell.WrapLayout;
import com.google.gwt.dev.shell.log.SwingTreeLogger;
import com.google.gwt.dev.util.BrowserLauncher;
import com.google.gwt.dev.util.log.CompositeTreeLogger;
import com.google.gwt.dev.util.log.PrintWriterTreeLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SwingLoggerPanel
extends JPanel
implements TreeSelectionListener,
HyperlinkListener {
    private static int ctrlKeyDown;
    private static final Color DISCONNECTED_COLOR;
    TreeLogger.Type levelFilter;
    String regexFilter = "";
    private final JTree tree;
    DefaultTreeModel treeModel;
    private CloseHandler closeHandler;
    private CloseButton closeLogger;
    private final JEditorPane details;
    private boolean disconnected = false;
    private FindBox findBox;
    private JComboBox levelComboBox;
    private final TreeLogger logger;
    private JTextField regexField;
    private DefaultMutableTreeNode root;
    private JPanel topPanel;
    private JScrollPane treeView;
    private JCheckBox autoScroll;

    public SwingLoggerPanel(TreeLogger.Type maxLevel, File logFile) {
        super(new BorderLayout());
        this.levelFilter = maxLevel;
        this.topPanel = new JPanel(new BorderLayout());
        JPanel logButtons = new JPanel(new WrapLayout());
        JButton expandButton = new JButton("Expand All");
        expandButton.setMnemonic(69);
        expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingLoggerPanel.this.expandAll();
            }
        });
        logButtons.add(expandButton);
        JButton collapseButton = new JButton("Collapse All");
        collapseButton.setMnemonic(79);
        collapseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingLoggerPanel.this.collapseAll();
            }
        });
        logButtons.add(collapseButton);
        this.autoScroll = new JCheckBox("Auto-scroll", true);
        this.autoScroll.setMnemonic(85);
        logButtons.add(this.autoScroll);
        this.topPanel.add((Component)logButtons, "Center");
        this.closeLogger = new CloseButton("Close this log window");
        this.closeLogger.setCallback(new CloseButton.Callback(){

            @Override
            public void onCloseRequest() {
                if (SwingLoggerPanel.this.disconnected && SwingLoggerPanel.this.closeHandler != null) {
                    SwingLoggerPanel.this.closeHandler.onCloseRequest(SwingLoggerPanel.this);
                }
            }
        });
        this.closeLogger.setEnabled(false);
        this.closeLogger.setVisible(false);
        this.topPanel.add((Component)this.closeLogger, "East");
        this.add((Component)this.topPanel, "North");
        this.root = new DefaultMutableTreeNode();
        this.treeModel = new DefaultTreeModel(this.root);
        this.treeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                for (Object treeNode : e.getChildren()) {
                    SwingLoggerPanel.this.onTreeNodeAdded((DefaultMutableTreeNode)treeNode);
                }
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }
        });
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setEditable(false);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new TreeRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.treeView = new JScrollPane(this.tree);
        this.details = new JEditorPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }
        };
        this.details.setEditable(false);
        this.details.setContentType("text/html");
        this.details.setForeground(Color.BLACK);
        this.details.addHyperlinkListener(this);
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.details.getDocument()).getStyleSheet().addRule(bodyRule);
        JScrollPane msgView = new JScrollPane(this.details);
        JSplitPane splitter = new JSplitPane(0);
        splitter.setTopComponent(this.treeView);
        splitter.setBottomComponent(msgView);
        Dimension minSize = new Dimension(100, 50);
        msgView.setMinimumSize(minSize);
        this.treeView.setMinimumSize(minSize);
        splitter.setDividerLocation(0.8);
        this.add(splitter);
        SwingTreeLogger uiLogger = new SwingTreeLogger(this);
        uiLogger.setMaxDetail(maxLevel);
        TreeLogger bestLogger = uiLogger;
        if (logFile != null) {
            try {
                PrintWriterTreeLogger fileLogger = new PrintWriterTreeLogger(logFile);
                fileLogger.setMaxDetail(maxLevel);
                bestLogger = new CompositeTreeLogger(bestLogger, fileLogger);
            }
            catch (IOException ex) {
                bestLogger.log(TreeLogger.ERROR, "Can't log to file " + logFile.getAbsolutePath(), ex);
            }
        }
        this.logger = bestLogger;
        KeyStroke key = this.getCommandKeyStroke(70, false);
        this.getInputMap(2).put(key, "find");
        this.getActionMap().put("find", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingLoggerPanel.this.showFindBox();
            }
        });
        key = this.getCommandKeyStroke(67, false);
        this.tree.getInputMap().put(key, "copy");
        this.tree.getActionMap().put("copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingLoggerPanel.this.treeCopy();
            }
        });
        this.findBox = new FindBox();
        key = this.getCommandKeyStroke(71, false);
        this.tree.getInputMap(2).put(key, "findnext");
        this.tree.getActionMap().put("findnext", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingLoggerPanel.this.findBox.nextMatch();
            }
        });
        key = this.getCommandKeyStroke(71, true);
        this.tree.getInputMap(2).put(key, "findprev");
        this.tree.getActionMap().put("findprev", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingLoggerPanel.this.findBox.prevMatch();
            }
        });
    }

    public void collapseAll() {
        Enumeration<TreeNode> children = this.root.postorderEnumeration();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            if (node == this.root) continue;
            this.tree.collapsePath(new TreePath(node.getPath()));
        }
        this.tree.invalidate();
    }

    public void disconnected() {
        this.disconnected = true;
        this.tree.setBackground(DISCONNECTED_COLOR);
        this.tree.repaint();
    }

    public void expandAll() {
        Enumeration<TreeNode> children = this.root.postorderEnumeration();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            if (node == this.root) continue;
            this.tree.expandPath(new TreePath(node.getPath()));
        }
        this.tree.invalidate();
    }

    public TreeLogger getLogger() {
        return this.logger;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        HyperlinkEvent.EventType eventType = event.getEventType();
        if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = event.getURL();
            try {
                BrowserLauncher.browse(url.toExternalForm());
                return;
            }
            catch (Exception exception) {
                try {
                    this.details.setPage(url);
                }
                catch (IOException e) {
                    this.logger.log(TreeLogger.ERROR, "Unable to follow link to " + url, e);
                }
            }
        }
    }

    @Override
    public void removeAll() {
        this.tree.removeAll();
        this.details.setText("");
    }

    public void setCloseHandler(CloseHandler handler) {
        this.closeHandler = handler;
        this.closeLogger.setEnabled(true);
        this.closeLogger.setVisible(true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (e.isAddedPath()) {
            TreePath path = e.getPath();
            Object treeNode = path.getLastPathComponent();
            if (treeNode == null) {
                this.details.setText("");
                return;
            }
            Object userObject = ((DefaultMutableTreeNode)treeNode).getUserObject();
            String text = userObject.toString();
            if (userObject instanceof SwingTreeLogger.LogEvent) {
                SwingTreeLogger.LogEvent event = (SwingTreeLogger.LogEvent)userObject;
                text = event.getFullText();
            }
            this.details.setText(text);
        }
    }

    protected void alert(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Alert: Not Implemented", 1);
    }

    protected boolean confirmClose() {
        int response = JOptionPane.showConfirmDialog(null, "Close the logger for the currently displayed module", "Close this Logger", 2, 2);
        return response != 0;
    }

    protected ArrayList<DefaultMutableTreeNode> doFind(String search) {
        Enumeration<TreeNode> children = this.root.preorderEnumeration();
        ArrayList<DefaultMutableTreeNode> matches = new ArrayList<DefaultMutableTreeNode>();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            if (node == this.root || !this.nodeMatches(node, search)) continue;
            matches.add(node);
            TreeNode[] nodePath = node.getPath();
            if (nodePath.length <= 1) continue;
            Object[] parentPath = new TreeNode[nodePath.length - 1];
            System.arraycopy(nodePath, 0, parentPath, 0, parentPath.length);
            this.tree.expandPath(new TreePath(parentPath));
        }
        this.tree.invalidate();
        return matches;
    }

    protected void hideFindBox() {
        this.findBox.hideBox();
    }

    protected void setLevelFilter(TreeLogger.Type selectedLevel) {
        this.levelFilter = selectedLevel;
        this.alert("Filtering not implemented yet");
    }

    protected void setRegexFilter(String regex) {
        this.regexFilter = regex;
        this.alert("Regex filtering not implemented yet");
    }

    protected void showFindBox() {
        this.findBox.showBox();
    }

    protected void treeCopy() {
        Clipboard clipboard;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            clipboard = this.tree.getToolkit().getSystemClipboard();
        }
        catch (SecurityException e) {
            return;
        }
        catch (HeadlessException e) {
            return;
        }
        if (clipboard == null) {
            return;
        }
        StringBuilder text = new StringBuilder();
        this.treeLogTraverse(text, node, 0);
        StringSelection selection = new StringSelection(text.toString());
        clipboard.setContents(selection, selection);
    }

    private KeyStroke getCommandKeyStroke(int key, boolean shift) {
        int mask = ctrlKeyDown;
        if (shift) {
            mask |= 0x40;
        }
        return KeyStroke.getKeyStroke(key, mask);
    }

    private String htmlUnescape(String str) {
        return str.replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&").replace("<br>", "\n");
    }

    private boolean nodeMatches(DefaultMutableTreeNode node, String search) {
        SwingTreeLogger.LogEvent event;
        String text;
        Object userObject = node.getUserObject();
        return userObject instanceof SwingTreeLogger.LogEvent && (text = this.htmlUnescape((event = (SwingTreeLogger.LogEvent)userObject).getFullText())).contains(search);
    }

    private void showFindResult(DefaultMutableTreeNode node, String search) {
        TreePath path = new TreePath(node.getPath());
        this.tree.scrollPathToVisible(path);
        this.tree.setSelectionPath(path);
    }

    private void treeLogTraverse(StringBuilder buf, TreeNode node, int indent) {
        for (int i = 0; i < indent; ++i) {
            buf.append(' ');
        }
        if (node instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode mutableNode = (DefaultMutableTreeNode)node;
            Object userObject = mutableNode.getUserObject();
            if (userObject instanceof SwingTreeLogger.LogEvent) {
                SwingTreeLogger.LogEvent event = (SwingTreeLogger.LogEvent)userObject;
                buf.append(this.htmlUnescape(event.getFullText()));
                if (event.isBranchCommit) {
                    SwingTreeLogger childLogger = event.childLogger;
                    DefaultMutableTreeNode parent = childLogger.treeNode;
                    for (int i = 0; i < parent.getChildCount(); ++i) {
                        this.treeLogTraverse(buf, parent.getChildAt(i), indent + 2);
                    }
                }
            } else {
                buf.append(userObject.toString());
                buf.append('\n');
            }
        } else {
            buf.append(node.toString());
            buf.append('\n');
        }
    }

    private void onTreeNodeAdded(DefaultMutableTreeNode treeNode) {
        TreePath path = new TreePath(treeNode.getPath());
        if (this.autoScroll.isSelected()) {
            this.tree.scrollPathToVisible(path);
        } else {
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof SwingTreeLogger.LogEvent && ((SwingTreeLogger.LogEvent)userObject).type.needsAttention()) {
                this.tree.makeVisible(path);
            }
        }
    }

    static {
        DISCONNECTED_COLOR = Color.decode("0xFFDDDD");
        ctrlKeyDown = BootStrapPlatform.isMac() ? 512 : 128;
    }

    private static class TreeRenderer
    extends DefaultTreeCellRenderer {
        private TreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean componentHasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, componentHasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (userObject instanceof SwingTreeLogger.LogEvent) {
                SwingTreeLogger.LogEvent event = (SwingTreeLogger.LogEvent)userObject;
                event.setDisplayProperties(this);
            }
            return this;
        }
    }

    private class FindBox
    extends JPanel {
        private Popup findPopup;
        private String lastSearch;
        private ArrayList<DefaultMutableTreeNode> matches;
        private int matchNumber;
        private JTextField searchField;
        private JLabel searchStatus;

        public FindBox() {
            super(new BorderLayout());
            JPanel top = new JPanel(new FlowLayout());
            this.searchField = new JTextField(20);
            top.add(this.searchField);
            JButton nextButton = new JButton("+");
            top.add(nextButton);
            nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindBox.this.nextMatch();
                }
            });
            JButton prevButton = new JButton("-");
            top.add(prevButton);
            prevButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindBox.this.prevMatch();
                }
            });
            CloseButton closeButton = new CloseButton("Close this search box");
            closeButton.setCallback(new CloseButton.Callback(){

                @Override
                public void onCloseRequest() {
                    SwingLoggerPanel.this.hideFindBox();
                }
            });
            top.add(closeButton);
            KeyStroke key = KeyStroke.getKeyStroke(27, 0);
            this.getInputMap(2).put(key, "find-cancel");
            key = KeyStroke.getKeyStroke(10, 0);
            this.getInputMap(2).put(key, "find-search");
            this.getActionMap().put("find-search", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindBox.this.lastSearch = FindBox.this.searchField.getText();
                    FindBox.this.matches = SwingLoggerPanel.this.doFind(FindBox.this.lastSearch);
                    FindBox.this.matchNumber = 0;
                    FindBox.this.updateSearchResult();
                }
            });
            AbstractAction closeFindBox = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingLoggerPanel.this.hideFindBox();
                }
            };
            this.getActionMap().put("find-cancel", closeFindBox);
            this.add((Component)top, "North");
            this.searchStatus = new JLabel("Type search text and press Enter");
            this.searchStatus.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 0));
            this.add((Component)this.searchStatus, "South");
        }

        public void hideBox() {
            if (this.findPopup != null) {
                this.findPopup.hide();
                this.findPopup = null;
            }
        }

        public void nextMatch() {
            if (this.matches != null && this.matches.size() > 0) {
                this.matchNumber = (this.matchNumber + 1) % this.matches.size();
                this.updateSearchResult();
            }
        }

        public void prevMatch() {
            int n;
            if (this.matches != null && (n = this.matches.size()) > 0) {
                this.matchNumber = (this.matchNumber + n - 1) % n;
                this.updateSearchResult();
            }
        }

        public void showBox() {
            int width;
            Point loggerOrigin = SwingLoggerPanel.this.details.getLocationOnScreen();
            Dimension dim = SwingLoggerPanel.this.details.getSize();
            if (this.findPopup != null) {
                this.findPopup.hide();
            }
            boolean needsRelocate = (width = SwingLoggerPanel.this.findBox.getWidth()) <= 0;
            int x = loggerOrigin.x + dim.width - width;
            int y = loggerOrigin.y + dim.height - SwingLoggerPanel.this.findBox.getHeight();
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.findPopup = popupFactory.getPopup(SwingLoggerPanel.this, SwingLoggerPanel.this.findBox, x, y);
            this.findPopup.show();
            if (needsRelocate) {
                x = loggerOrigin.x + dim.width - SwingLoggerPanel.this.findBox.getWidth();
                y = loggerOrigin.y + dim.height - SwingLoggerPanel.this.findBox.getHeight();
                this.findPopup.hide();
                this.findPopup = popupFactory.getPopup(SwingLoggerPanel.this, SwingLoggerPanel.this.findBox, x, y);
                this.findPopup.show();
            }
            this.searchField.requestFocusInWindow();
        }

        private void updateSearchResult() {
            int n = this.matches.size();
            if (n == 0) {
                this.searchStatus.setText("No matches");
            } else {
                this.searchStatus.setText(String.valueOf(this.matchNumber + 1) + " of " + n + " matches");
                SwingLoggerPanel.this.showFindResult(this.matches.get(this.matchNumber), this.lastSearch);
            }
        }
    }

    public static interface CloseHandler {
        public void onCloseRequest(SwingLoggerPanel var1);
    }
}

