/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.jetty;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.shell.jetty.ClientAuthType;
import com.google.gwt.dev.shell.jetty.JettyLauncher;
import com.google.gwt.dev.util.Util;
import java.io.File;
import java.net.URL;
import java.util.Optional;

public class SslConfiguration {
    private final ClientAuthType clientAuth;
    private final String keyStore;
    private final String keyStorePassword;
    private final boolean useSsl;

    public static Optional<SslConfiguration> parseArgs(String[] args, TreeLogger logger) {
        boolean useSsl = false;
        String keyStore = null;
        String keyStorePassword = null;
        ClientAuthType clientAuth = ClientAuthType.NONE;
        for (String arg : args) {
            String tag;
            int equals = arg.indexOf(61);
            String value = null;
            if (equals < 0) {
                tag = arg;
            } else {
                tag = arg.substring(0, equals);
                value = arg.substring(equals + 1);
            }
            if ("ssl".equals(tag)) {
                useSsl = true;
                URL keyStoreUrl = JettyLauncher.class.getResource("localhost.keystore");
                if (keyStoreUrl == null) {
                    logger.log(TreeLogger.ERROR, "Default GWT keystore not found");
                    return Optional.empty();
                }
                keyStore = keyStoreUrl.toExternalForm();
                keyStorePassword = "localhost";
                continue;
            }
            if ("keystore".equals(tag)) {
                useSsl = true;
                keyStore = value;
                continue;
            }
            if ("password".equals(tag)) {
                useSsl = true;
                keyStorePassword = value;
                continue;
            }
            if ("pwfile".equals(tag)) {
                useSsl = true;
                keyStorePassword = Util.readFileAsString(new File(value));
                if (keyStorePassword == null) {
                    logger.log(TreeLogger.ERROR, "Unable to read keystore password from '" + value + "'");
                    return Optional.empty();
                }
                keyStorePassword = keyStorePassword.trim();
                continue;
            }
            if ("clientAuth".equals(tag)) {
                useSsl = true;
                try {
                    clientAuth = ClientAuthType.valueOf(value);
                }
                catch (IllegalArgumentException e) {
                    logger.log(TreeLogger.WARN, "Ignoring invalid clientAuth of '" + value + "'");
                }
                continue;
            }
            logger.log(TreeLogger.ERROR, "Unexpected argument to " + JettyLauncher.class.getSimpleName() + ": " + arg);
            return Optional.empty();
        }
        if (useSsl) {
            if (keyStore == null) {
                logger.log(TreeLogger.ERROR, "A keystore is required to use SSL");
                return Optional.empty();
            }
            if (keyStorePassword == null) {
                logger.log(TreeLogger.ERROR, "A keystore password is required to use SSL");
                return Optional.empty();
            }
        }
        return Optional.of(new SslConfiguration(clientAuth, keyStore, keyStorePassword, useSsl));
    }

    public SslConfiguration(ClientAuthType clientAuth, String keyStore, String keyStorePassword, boolean useSsl) {
        this.clientAuth = clientAuth;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.useSsl = useSsl;
    }

    public ClientAuthType getClientAuth() {
        return this.clientAuth;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }
}

