/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.jetty;

import com.google.gwt.core.ext.TreeLogger;
import org.eclipse.jetty.util.log.Logger;

public class JettyTreeLogger
implements Logger {
    private final TreeLogger logger;

    public JettyTreeLogger(TreeLogger logger) {
        if (logger == null) {
            throw new NullPointerException();
        }
        this.logger = logger;
    }

    @Override
    public void debug(String msg, long arg) {
        this.logger.log(TreeLogger.SPAM, this.format(msg, arg));
    }

    @Override
    public void debug(String msg, Object ... args) {
        if (this.logger.isLoggable(TreeLogger.SPAM)) {
            this.logger.log(TreeLogger.SPAM, this.format(msg, args));
        }
    }

    @Override
    public void debug(String msg, Throwable th) {
        this.logger.log(TreeLogger.SPAM, msg, th);
    }

    @Override
    public void debug(Throwable th) {
        this.logger.log(TreeLogger.SPAM, "", th);
    }

    @Override
    public Logger getLogger(String name) {
        return this;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void info(String msg, Object ... args) {
        if (this.logger.isLoggable(TreeLogger.TRACE)) {
            this.logger.log(TreeLogger.TRACE, this.format(msg, args));
        }
    }

    @Override
    public void info(String msg, Throwable th) {
        this.logger.log(TreeLogger.TRACE, msg, th);
    }

    @Override
    public void info(Throwable th) {
        this.logger.log(TreeLogger.TRACE, "", th);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(TreeLogger.SPAM);
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
    }

    @Override
    public void warn(String msg, Object ... args) {
        if (this.logger.isLoggable(TreeLogger.WARN)) {
            this.logger.log(TreeLogger.WARN, this.format(msg, args));
        }
    }

    @Override
    public void warn(String msg, Throwable th) {
        this.logger.log(TreeLogger.WARN, msg, th);
    }

    @Override
    public void warn(Throwable th) {
        this.logger.log(TreeLogger.WARN, "", th);
    }

    @Override
    public void ignore(Throwable th) {
        this.logger.log(TreeLogger.SPAM, "IGNORE", th);
    }

    private String format(String msg, Object ... args) {
        if (msg == null) {
            msg = "";
            for (int i = 0; i < args.length; ++i) {
                msg = msg + "{} ";
            }
        }
        String braces = "{}";
        int start = 0;
        StringBuilder builder = new StringBuilder();
        for (Object arg : args) {
            int bracesIndex = msg.indexOf(braces, start);
            if (bracesIndex < 0) {
                builder.append(msg.substring(start));
                builder.append(" ");
                builder.append(arg);
                start = msg.length();
                continue;
            }
            builder.append(msg.substring(start, bracesIndex));
            builder.append(String.valueOf(arg));
            start = bracesIndex + braces.length();
        }
        builder.append(msg.substring(start));
        return builder.toString();
    }
}

