/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.jetty;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.shell.jetty.SslConfiguration;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyLauncherUtils {
    private JettyLauncherUtils() {
    }

    public static void setupConnector(ServerConnector connector, String bindAddress, int port) {
        if (bindAddress != null) {
            connector.setHost(bindAddress);
        }
        connector.setPort(port);
        connector.setReuseAddress(true);
    }

    public static ServerConnector getConnector(Server server, SslConfiguration sslConfig, TreeLogger logger) {
        HttpConfiguration config = JettyLauncherUtils.defaultConfig();
        if (sslConfig.isUseSsl()) {
            TreeLogger sslLogger = logger.branch(TreeLogger.INFO, "Listening for SSL connections");
            if (sslLogger.isLoggable(TreeLogger.TRACE)) {
                sslLogger.log(TreeLogger.TRACE, "Using keystore " + sslConfig.getKeyStore());
            }
            SslContextFactory ssl = new SslContextFactory();
            if (sslConfig.getClientAuth() != null) {
                switch (sslConfig.getClientAuth()) {
                    case NONE: {
                        ssl.setWantClientAuth(false);
                        ssl.setNeedClientAuth(false);
                        break;
                    }
                    case WANT: {
                        sslLogger.log(TreeLogger.TRACE, "Requesting client certificates");
                        ssl.setWantClientAuth(true);
                        ssl.setNeedClientAuth(false);
                        break;
                    }
                    case REQUIRE: {
                        sslLogger.log(TreeLogger.TRACE, "Requiring client certificates");
                        ssl.setWantClientAuth(true);
                        ssl.setNeedClientAuth(true);
                    }
                }
            }
            ssl.setKeyStorePath(sslConfig.getKeyStore());
            ssl.setTrustStorePath(sslConfig.getKeyStore());
            ssl.setKeyStorePassword(sslConfig.getKeyStorePassword());
            ssl.setTrustStorePassword(sslConfig.getKeyStorePassword());
            config.addCustomizer(new SecureRequestCustomizer());
            return new ServerConnector(server, null, null, null, 0, 2, new SslConnectionFactory(ssl, "http/1.1"), new HttpConnectionFactory(config));
        }
        return new ServerConnector(server, new HttpConnectionFactory(config));
    }

    private static HttpConfiguration defaultConfig() {
        HttpConfiguration config = new HttpConfiguration();
        config.setRequestHeaderSize(16386);
        config.setSendServerVersion(false);
        config.setSendDateHeader(true);
        return config;
    }
}

