/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell.jetty;

import com.google.gwt.core.ext.ServletContainer;
import com.google.gwt.core.ext.ServletContainerLauncher;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.shell.jetty.ClientAuthType;
import com.google.gwt.dev.shell.jetty.JDBCUnloader;
import com.google.gwt.dev.shell.jetty.JettyLauncherUtils;
import com.google.gwt.dev.shell.jetty.SslConfiguration;
import com.google.gwt.dev.util.InstalledHelpInfo;
import com.google.gwt.dev.util.Util;
import com.google.gwt.thirdparty.guava.common.collect.Iterators;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.preventers.AppContextLeakPreventer;
import org.eclipse.jetty.util.preventers.DOMLeakPreventer;
import org.eclipse.jetty.util.preventers.GCThreadLeakPreventer;
import org.eclipse.jetty.util.preventers.SecurityProviderLeakPreventer;
import org.eclipse.jetty.webapp.ClasspathPattern;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

@Deprecated
public class JettyLauncher
extends ServletContainerLauncher {
    private static final AtomicBoolean hasLoggedDeprecationWarning = new AtomicBoolean(false);
    private static final String PROPERTY_NOWARN_WEBAPP_CLASSPATH = "gwt.nowarn.webapp.classpath";
    private TreeLogger.Type baseLogLevel = TreeLogger.INFO;
    private String bindAddress = null;
    private SslConfiguration sslConfig = new SslConfiguration(ClientAuthType.NONE, null, null, false);
    private final Object privateInstanceLock = new Object();

    public static void suppressDeprecationWarningForTests() {
        hasLoggedDeprecationWarning.set(true);
    }

    private static void maybeLogDeprecationWarning(TreeLogger log) {
        if (hasLoggedDeprecationWarning.compareAndSet(false, true)) {
            log.log(TreeLogger.Type.WARN, "DevMode will default to -noserver in a future release, and JettyLauncher may be removed or changed. Please consider running your own application server and either passing -noserver to DevMode or migrating to CodeServer. Alternatively, consider implementing your own ServletContainerLauncher to continue running your application server from DevMode.");
        }
    }

    private static void setupConnector(ServerConnector connector, String bindAddress, int port) {
        JettyLauncherUtils.setupConnector(connector, bindAddress, port);
    }

    @Override
    public String getName() {
        return "Jetty";
    }

    @Override
    public boolean isSecure() {
        return this.sslConfig.isUseSsl();
    }

    @Override
    public boolean processArguments(TreeLogger logger, String arguments) {
        if (arguments != null && arguments.length() > 0) {
            Optional<SslConfiguration> parsed = SslConfiguration.parseArgs(arguments.split(","), logger);
            if (parsed.isPresent()) {
                this.sslConfig = parsed.get();
            } else {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBaseRequestLogLevel(TreeLogger.Type baseLogLevel) {
        Object object = this.privateInstanceLock;
        synchronized (object) {
            this.baseLogLevel = baseLogLevel;
        }
    }

    @Override
    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    @Override
    public ServletContainer start(TreeLogger logger, int port, File appRootDir) throws Exception {
        TreeLogger branch = logger.branch(TreeLogger.TRACE, "Starting Jetty on port " + port, null);
        this.checkStartParams(branch, port, appRootDir);
        Log.setLog(new JettyTreeLogger(branch));
        this.jreLeakPrevention(logger);
        System.setProperty("org.eclipse.jetty.xml.XmlParser.Validating", "false");
        Server server = new Server();
        ServerConnector connector = this.getConnector(server, logger);
        JettyLauncher.setupConnector(connector, this.bindAddress, port);
        server.addConnector(connector);
        this.addPreventers(server);
        Configuration.ClassList cl = Configuration.ClassList.setServerDefault(server);
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.eclipse.jetty.plus.webapp.PlusConfiguration");
            cl.addAfter("org.eclipse.jetty.webapp.FragmentConfiguration", "org.eclipse.jetty.plus.webapp.EnvConfiguration", "org.eclipse.jetty.plus.webapp.PlusConfiguration");
        }
        catch (ClassNotFoundException cnfe) {
            logger.log(TreeLogger.Type.DEBUG, "jetty-plus isn't on the classpath, JNDI won't work. This might also affect annotations scanning and JSP.");
        }
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.eclipse.jetty.annotations.AnnotationConfiguration");
            cl.addBefore("org.eclipse.jetty.webapp.JettyWebXmlConfiguration", "org.eclipse.jetty.annotations.AnnotationConfiguration");
        }
        catch (ClassNotFoundException cnfe) {
            logger.log(TreeLogger.Type.DEBUG, "jetty-annotations isn't on the classpath, annotation scanning won't work. This might also affect annotations scanning.");
        }
        WebAppContext wac = this.createWebAppContext(logger, appRootDir);
        wac.setSecurityHandler(new ConstraintSecurityHandler());
        RequestLogHandler logHandler = new RequestLogHandler();
        logHandler.setRequestLog(new JettyRequestLogger(logger, this.getBaseLogLevel()));
        logHandler.setHandler(wac);
        server.setHandler(logHandler);
        server.start();
        server.setStopAtShutdown(true);
        Log.setLog(new JettyTreeLogger(logger));
        int connectorPort = connector.getLocalPort();
        if (connector.getLocalPort() < 0) {
            branch.log(TreeLogger.ERROR, String.format("Failed to connect to open channel with port %d (return value %d)", port, connectorPort));
        }
        return this.createServletContainer(logger, appRootDir, server, wac, connectorPort);
    }

    protected JettyServletContainer createServletContainer(TreeLogger logger, File appRootDir, Server server, WebAppContext wac, int localPort) {
        return new JettyServletContainer(logger, server, wac, localPort, appRootDir);
    }

    protected WebAppContext createWebAppContext(TreeLogger logger, File appRootDir) {
        WebAppContextWithReload context = new WebAppContextWithReload(logger, appRootDir.getAbsolutePath(), "/");
        context.setConfigurationClasses(new String[]{"org.eclipse.jetty.webapp.WebInfConfiguration", "org.eclipse.jetty.webapp.WebXmlConfiguration", "org.eclipse.jetty.webapp.MetaInfConfiguration", "org.eclipse.jetty.webapp.FragmentConfiguration", "org.eclipse.jetty.plus.webapp.EnvConfiguration", "org.eclipse.jetty.plus.webapp.PlusConfiguration", "org.eclipse.jetty.annotations.AnnotationConfiguration", "org.eclipse.jetty.webapp.JettyWebXmlConfiguration"});
        return context;
    }

    protected ServerConnector getConnector(Server server, TreeLogger logger) {
        return JettyLauncherUtils.getConnector(server, this.sslConfig, logger);
    }

    private void addPreventers(Server server) {
        server.addBean(new AppContextLeakPreventer());
        server.addBean(new GCThreadLeakPreventer());
        server.addBean(new SecurityProviderLeakPreventer());
        server.addBean(new DOMLeakPreventer());
    }

    private void checkStartParams(TreeLogger logger, int port, File appRootDir) {
        if (logger == null) {
            throw new NullPointerException("logger cannot be null");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port must be either 0 (for auto) or less than 65536");
        }
        if (appRootDir == null) {
            throw new NullPointerException("app root direcotry cannot be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeLogger.Type getBaseLogLevel() {
        Object object = this.privateInstanceLock;
        synchronized (object) {
            return this.baseLogLevel;
        }
    }

    private void jreLeakPrevention(TreeLogger logger) {
        try {
            Class<?> policyClass = Class.forName("javax.security.auth.Policy");
            Method method = policyClass.getMethod("getPolicy", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException policyClass) {
        }
        catch (SecurityException policyClass) {
        }
        catch (NoSuchMethodException e) {
            logger.log(TreeLogger.WARN, "jreLeakPrevention.authPolicyFail", e);
        }
        catch (IllegalArgumentException e) {
            logger.log(TreeLogger.WARN, "jreLeakPrevention.authPolicyFail", e);
        }
        catch (IllegalAccessException e) {
            logger.log(TreeLogger.WARN, "jreLeakPrevention.authPolicyFail", e);
        }
        catch (InvocationTargetException e) {
            logger.log(TreeLogger.WARN, "jreLeakPrevention.authPolicyFail", e);
        }
        try {
            URL url = new URL("jar:file://dummy.jar!/");
            URLConnection uConn = url.openConnection();
            uConn.setDefaultUseCaches(false);
        }
        catch (MalformedURLException e) {
            logger.log(TreeLogger.ERROR, "jreLeakPrevention.jarUrlConnCacheFail", e);
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "jreLeakPrevention.jarUrlConnCacheFail", e);
        }
    }

    protected static final class WebAppContextWithReload
    extends WebAppContext {
        private final ClassLoader bootStrapOnlyClassLoader = new ClassLoader(null){};
        private final TreeLogger logger;
        private final ClassLoader systemClassLoader = Thread.currentThread().getContextClassLoader();

        private WebAppContextWithReload(TreeLogger logger, String webApp, String contextPath) {
            super(null, contextPath, null, null, null, new ErrorPageErrorHandler(), 1);
            this.setWar(webApp);
            this.logger = logger;
            this.getInitParams().put("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
            this.setParentLoaderPriority(true);
        }

        @Override
        protected void doStart() throws Exception {
            this.setClassLoader(new WebAppClassLoaderExtension());
            super.doStart();
            boolean hasNonJettyFiltersOrServlets = Stream.concat(this.getServletContext().getServletRegistrations().values().stream(), this.getServletContext().getFilterRegistrations().values().stream()).anyMatch(r -> !r.getClassName().startsWith("org.eclipse.jetty"));
            if (hasNonJettyFiltersOrServlets) {
                JettyLauncher.maybeLogDeprecationWarning(this.logger);
            }
        }

        @Override
        protected void doStop() throws Exception {
            super.doStop();
            Class<?> jdbcUnloader = this.getClassLoader().loadClass("com.google.gwt.dev.shell.jetty.JDBCUnloader");
            Method unload = jdbcUnloader.getMethod("unload", new Class[0]);
            unload.invoke(null, new Object[0]);
            this.setClassLoader(null);
        }

        private class WebAppClassLoaderExtension
        extends WebAppClassLoader {
            private static final String META_INF_SERVICES = "META-INF/services/";
            private final ClasspathPattern systemClassesFromWebappFirst;
            private final ClasspathPattern allowedFromSystemClassLoader;

            public WebAppClassLoaderExtension() throws IOException {
                super(WebAppContextWithReload.this.bootStrapOnlyClassLoader, WebAppContextWithReload.this);
                this.systemClassesFromWebappFirst = new ClasspathPattern(new String[]{"-javax.servlet.", "-javax.el.", "-javax.websocket.", "javax."});
                this.allowedFromSystemClassLoader = new ClasspathPattern(new String[]{"org.eclipse.jetty.", "javax.websocket.", "org.apache.jasper.", "org.apache.juli.logging.", "org.apache.tomcat.", "org.apache.el.", "org.apache.xerces.", "javax.xml."});
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                List fromParent = WebAppContextWithReload.this.isServerClass(name) ? Collections.emptyList() : Lists.newArrayList(Iterators.forEnumeration(WebAppContextWithReload.this.systemClassLoader.getResources(name)));
                Iterator fromWebapp = WebAppContextWithReload.this.isSystemClass(name) && !fromParent.isEmpty() ? Collections.emptyIterator() : Iterators.forEnumeration(this.findResources(name));
                return Iterators.asEnumeration(Iterators.concat(fromWebapp, fromParent.iterator()));
            }

            @Override
            public URL findResource(String name) {
                URL found;
                String checkName = name;
                if (checkName.startsWith(META_INF_SERVICES)) {
                    checkName = checkName.substring(META_INF_SERVICES.length());
                }
                if (WebAppContextWithReload.this.isSystemClass(checkName = checkName.replace('/', '.')) && !this.systemClassesFromWebappFirst.match(checkName) && (found = WebAppContextWithReload.this.systemClassLoader.getResource(name)) != null) {
                    return found;
                }
                found = super.findResource(name);
                if (found != null) {
                    return found;
                }
                found = WebAppContextWithReload.this.systemClassLoader.getResource(name);
                if (found == null || WebAppContextWithReload.this.isServerClass(checkName)) {
                    return null;
                }
                if (this.allowedFromSystemClassLoader.match(checkName) || "jndi.properties".equals(name)) {
                    return found;
                }
                String warnMessage = "Server resource '" + name + "' could not be found in the web app, but was found on the system classpath";
                if (!this.addContainingClassPathEntry(warnMessage, found, name)) {
                    return null;
                }
                return super.findResource(name);
            }

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (WebAppContextWithReload.this.isSystemClass(name) && !this.systemClassesFromWebappFirst.match(name)) {
                    try {
                        Class<?> loaded = WebAppContextWithReload.this.systemClassLoader.loadClass(name);
                        if (resolve) {
                            this.resolveClass(loaded);
                        }
                        return loaded;
                    }
                    catch (ClassNotFoundException loaded) {
                        // empty catch block
                    }
                }
                try {
                    return super.loadClass(name, resolve);
                }
                catch (ClassNotFoundException e) {
                    if (WebAppContextWithReload.this.isServerClass(name)) {
                        throw e;
                    }
                    String resourceName = name.replace('.', '/') + ".class";
                    URL found = WebAppContextWithReload.this.systemClassLoader.getResource(resourceName);
                    if (found == null) {
                        throw new ClassNotFoundException(name);
                    }
                    if (JDBCUnloader.class.getName().equals(name)) {
                        byte[] jdbcUnloader = Util.readURLAsBytes(found);
                        return this.defineClass(name, jdbcUnloader, 0, jdbcUnloader.length);
                    }
                    if (this.allowedFromSystemClassLoader.match(name)) {
                        Class<?> loaded = WebAppContextWithReload.this.systemClassLoader.loadClass(name);
                        if (resolve) {
                            this.resolveClass(loaded);
                        }
                        return loaded;
                    }
                    String warnMessage = "Server class '" + name + "' could not be found in the web app, but was found on the system classpath";
                    if (!this.addContainingClassPathEntry(warnMessage, found, resourceName)) {
                        throw new ClassNotFoundException(name);
                    }
                    return super.loadClass(name, resolve);
                }
            }

            private boolean addContainingClassPathEntry(String warnMessage, URL resource, String resourceName) {
                String classPathURL;
                TreeLogger.Type logLevel = System.getProperty(JettyLauncher.PROPERTY_NOWARN_WEBAPP_CLASSPATH) == null ? TreeLogger.WARN : TreeLogger.DEBUG;
                TreeLogger branch = WebAppContextWithReload.this.logger.branch(logLevel, warnMessage);
                String foundStr = resource.toExternalForm();
                if (resource.getProtocol().equals("file")) {
                    assert (foundStr.endsWith(resourceName));
                    classPathURL = foundStr.substring(0, foundStr.length() - resourceName.length());
                } else if (resource.getProtocol().equals("jar")) {
                    assert (foundStr.startsWith("jar:"));
                    assert (foundStr.endsWith("!/" + resourceName));
                    classPathURL = foundStr.substring(4, foundStr.length() - (2 + resourceName.length()));
                } else {
                    branch.log(TreeLogger.ERROR, "Found resouce but unrecognized URL format: '" + foundStr + '\'');
                    return false;
                }
                branch = branch.branch(logLevel, "Adding classpath entry '" + classPathURL + "' to the web app classpath for this session", null, new InstalledHelpInfo("webAppClassPath.html"));
                try {
                    this.addClassPath(classPathURL);
                    return true;
                }
                catch (IOException e) {
                    branch.log(TreeLogger.ERROR, "Failed add container URL: '" + classPathURL + '\'', e);
                    return false;
                }
            }
        }
    }

    protected static class JettyServletContainer
    extends ServletContainer {
        private final int actualPort;
        private final File appRootDir;
        private final TreeLogger logger;
        private final Server server;
        private final WebAppContext wac;

        public JettyServletContainer(TreeLogger logger, Server server, WebAppContext wac, int actualPort, File appRootDir) {
            this.logger = logger;
            this.server = server;
            this.wac = wac;
            this.actualPort = actualPort;
            this.appRootDir = appRootDir;
        }

        @Override
        public int getPort() {
            return this.actualPort;
        }

        @Override
        public void refresh() throws UnableToCompleteException {
            String msg = "Reloading web app to reflect changes in " + this.appRootDir.getAbsolutePath();
            TreeLogger branch = this.logger.branch(TreeLogger.INFO, msg);
            Log.setLog(new JettyTreeLogger(branch));
            try {
                this.server.stop();
                this.server.start();
                branch.log(TreeLogger.INFO, "Reload completed successfully");
            }
            catch (Exception e) {
                branch.log(TreeLogger.ERROR, "Unable to restart embedded Jetty server", e);
                throw new UnableToCompleteException();
            }
            finally {
                Log.setLog(new JettyTreeLogger(this.logger));
            }
        }

        @Override
        public void stop() throws UnableToCompleteException {
            TreeLogger branch = this.logger.branch(TreeLogger.INFO, "Stopping Jetty server");
            Log.setLog(new JettyTreeLogger(branch));
            try {
                this.server.stop();
                this.server.setStopAtShutdown(false);
                branch.log(TreeLogger.TRACE, "Stopped successfully");
            }
            catch (Exception e) {
                branch.log(TreeLogger.ERROR, "Unable to stop embedded Jetty server", e);
                throw new UnableToCompleteException();
            }
            finally {
                Log.setLog(new JettyTreeLogger(this.logger));
            }
        }
    }

    @Deprecated
    public static class JettyTreeLogger
    extends com.google.gwt.dev.shell.jetty.JettyTreeLogger {
        public JettyTreeLogger(TreeLogger logger) {
            super(logger);
        }
    }

    public static class JettyRequestLogger
    extends AbstractLifeCycle
    implements RequestLog {
        private final TreeLogger logger;
        private final TreeLogger.Type normalLogLevel;

        public JettyRequestLogger(TreeLogger logger, TreeLogger.Type normalLogLevel) {
            this.logger = logger;
            assert (normalLogLevel != null);
            this.normalLogLevel = normalLogLevel;
        }

        @Override
        public void log(Request request, Response response) {
            TreeLogger branch;
            TreeLogger.Type logHeaders;
            TreeLogger.Type logStatus;
            int status = response.getStatus();
            if (status < 0) {
                status = 404;
            }
            if (status != 404) {
                JettyLauncher.maybeLogDeprecationWarning(this.logger);
            }
            if (status >= 500) {
                logStatus = TreeLogger.ERROR;
                logHeaders = TreeLogger.INFO;
            } else if (status == 404) {
                if ("/favicon.ico".equals(request.getRequestURI()) && request.getQueryString() == null) {
                    logStatus = TreeLogger.TRACE;
                    logHeaders = TreeLogger.DEBUG;
                } else {
                    logStatus = TreeLogger.WARN;
                    logHeaders = TreeLogger.INFO;
                }
            } else if (status >= 400) {
                logStatus = TreeLogger.WARN;
                logHeaders = TreeLogger.INFO;
            } else {
                logStatus = this.normalLogLevel;
                logHeaders = TreeLogger.DEBUG;
            }
            String userString = request.getRemoteUser();
            userString = userString == null ? "" : userString + "@";
            String bytesString = "";
            if (response.getContentCount() > 0L) {
                bytesString = " " + response.getContentCount() + " bytes";
            }
            if (this.logger.isLoggable(logStatus) && (branch = this.logger.branch(logStatus, String.valueOf(status) + " - " + request.getMethod() + ' ' + request.getRequestURI() + " (" + userString + request.getRemoteHost() + ')' + bytesString)).isLoggable(logHeaders)) {
                this.logHeaders(branch.branch(logHeaders, "Request headers"), logHeaders, request.getHttpFields());
                this.logHeaders(branch.branch(logHeaders, "Response headers"), logHeaders, response.getHttpFields());
            }
        }

        private void logHeaders(TreeLogger logger, TreeLogger.Type logLevel, HttpFields fields) {
            for (int i = 0; i < fields.size(); ++i) {
                HttpField field = fields.getField(i);
                logger.log(logLevel, field.getName() + ": " + field.getValue());
            }
        }
    }
}

