/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.impl.StandardLinkerContext;
import com.google.gwt.dev.DevMode;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.shell.CodeServerListener;
import com.google.gwt.dev.util.arg.OptionMethodNameDisplayMode;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Stopwatch;
import com.google.gwt.thirdparty.guava.common.collect.ListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class SuperDevListener
implements CodeServerListener {
    private final TreeLogger logger;
    private final int codeServerPort;
    private List<String> codeServerArgs;

    public SuperDevListener(TreeLogger treeLogger, DevMode.HostedModeOptions options) {
        this.logger = treeLogger;
        this.codeServerPort = SuperDevListener.chooseCodeServerPort(treeLogger, options);
        SuperDevListener.ensureModuleBaseDir(options);
        this.codeServerArgs = SuperDevListener.makeCodeServerArgs(options, this.codeServerPort);
    }

    @Override
    public int getSocketPort() {
        return this.codeServerPort;
    }

    @VisibleForTesting
    List<String> getCodeServerArgs() {
        return this.codeServerArgs;
    }

    @Override
    public URL makeStartupUrl(String url) throws UnableToCompleteException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            this.logger.log(TreeLogger.ERROR, "Invalid URL " + url, e);
            throw new UnableToCompleteException();
        }
    }

    @Override
    public void writeCompilerOutput(StandardLinkerContext linkerStack, ArtifactSet artifacts, ModuleDef module, boolean isRelink) throws UnableToCompleteException {
    }

    @Override
    public void setIgnoreRemoteDeath(boolean b) {
    }

    @Override
    public void start() {
        try {
            Stopwatch watch = Stopwatch.createStarted();
            this.logger.log(TreeLogger.Type.INFO, "Running CodeServer with parameters: " + this.codeServerArgs);
            this.runCodeServer(this.codeServerArgs.toArray(new String[0]));
            this.logger.log(TreeLogger.Type.INFO, "Code server started in " + watch + " ms");
        }
        catch (Exception e) {
            this.logger.log(TreeLogger.Type.INFO, "Unable to start Code server");
            throw new RuntimeException(e);
        }
    }

    private void runCodeServer(String[] mainArgs) throws Exception {
        Method mainMethod;
        try {
            Class<?> clazz = Class.forName("com.google.gwt.dev.codeserver.CodeServer");
            mainMethod = clazz.getMethod("main", String[].class);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(TreeLogger.ERROR, "Unable to find main() method for Super Dev Mode code server. Hint: verify that gwt-codeserver.jar is in your classpath.");
            throw e;
        }
        mainMethod.invoke(null, new Object[]{mainArgs});
    }

    private static int chooseCodeServerPort(TreeLogger logger, DevMode.HostedModeOptions options) {
        int port = options.getCodeServerPort();
        if (port == 0) {
            try {
                ServerSocket serverSocket = new ServerSocket(0);
                port = serverSocket.getLocalPort();
                serverSocket.close();
                return port;
            }
            catch (IOException e) {
                logger.log(TreeLogger.ERROR, "Unable to get an unnused port.");
                throw new RuntimeException(e);
            }
        }
        if (port < 0 || port == 9997) {
            return 9876;
        }
        return port;
    }

    private static void ensureModuleBaseDir(DevMode.HostedModeOptions options) {
        File dir = options.getModuleBaseDir();
        if (!dir.isDirectory()) {
            dir.mkdirs();
            if (!dir.isDirectory()) {
                throw new RuntimeException("unable to create module base directory: " + dir.getAbsolutePath());
            }
        }
    }

    private static List<String> makeCodeServerArgs(DevMode.HostedModeOptions options, int port) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-noprecompile");
        args.add("-port");
        args.add(String.valueOf(port));
        args.add("-sourceLevel");
        args.add(String.valueOf((Object)options.getSourceLevel()));
        if (options.getBindAddress() != null) {
            args.add("-bindAddress");
            args.add(options.getBindAddress());
        }
        if (options.getWorkDir() != null) {
            args.add("-workDir");
            args.add(String.valueOf(options.getWorkDir()));
        }
        args.add("-launcherDir");
        args.add(options.getModuleBaseDir().getAbsolutePath());
        if (options.getLogLevel() != null) {
            args.add("-logLevel");
            args.add(String.valueOf((Object)options.getLogLevel()));
        }
        if (options.shouldGenerateJsInteropExports()) {
            args.add("-generateJsInteropExports");
        }
        for (String regex : options.getJsInteropExportFilter().getValues()) {
            if (regex.startsWith("-")) {
                args.add("-excludeJsInteropExports");
                args.add(regex.substring(1));
                continue;
            }
            args.add("-includeJsInteropExports");
            args.add(regex.startsWith("+") ? regex.substring(1) : regex);
        }
        if (!options.isIncrementalCompileEnabled()) {
            args.add("-noincremental");
        }
        if (options.getMethodNameDisplayMode() != OptionMethodNameDisplayMode.Mode.NONE) {
            args.add("-XmethodNameDisplayMode");
            args.add(options.getMethodNameDisplayMode().name());
        }
        args.add("-style");
        args.add(options.getOutput().name());
        if (options.isStrict()) {
            args.add("-strict");
        }
        if (options.getProperties().size() > 0) {
            args.addAll(SuperDevListener.makeSetPropertyArgs(options.getProperties()));
        }
        for (String mod : options.getModuleNames()) {
            args.add(mod);
        }
        return args;
    }

    private static List<String> makeSetPropertyArgs(ListMultimap<String, String> properties) {
        ArrayList<String> propertyArgs = Lists.newArrayList();
        for (String propertyName : properties.keySet()) {
            propertyArgs.add("-setProperty");
            StringBuilder nameValues = new StringBuilder(propertyName + "=");
            for (String propertyValue : properties.get((Object)propertyName)) {
                nameValues.append(propertyValue + ",");
            }
            propertyArgs.add(nameValues.substring(0, nameValues.length() - 1));
        }
        return propertyArgs;
    }
}

