/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.core.ext.CachedGeneratorResult;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.RebindMode;
import com.google.gwt.core.ext.RebindResult;
import com.google.gwt.core.ext.RebindRuleResolver;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.dev.RebindCache;
import com.google.gwt.dev.cfg.Rule;
import com.google.gwt.dev.javac.CachedGeneratorResultImpl;
import com.google.gwt.dev.javac.StandardGeneratorContext;
import com.google.gwt.dev.jdt.RebindOracle;
import com.google.gwt.dev.shell.ArtifactAcceptor;
import com.google.gwt.dev.shell.Messages;
import com.google.gwt.dev.util.log.speedtracer.DevModeEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.util.Deque;
import java.util.Map;

public class StandardRebindOracle
implements RebindOracle {
    private final Map<String, String> typeNameBindingMap = Maps.newHashMap();
    private final StandardGeneratorContext genCtx;
    private final PropertyOracle propOracle;
    private RebindCache rebindCache = null;
    private final Deque<Rule> rules;

    public StandardRebindOracle(PropertyOracle propOracle, Deque<Rule> rules, StandardGeneratorContext genCtx) {
        this.propOracle = propOracle;
        this.rules = rules;
        this.genCtx = genCtx;
    }

    @Override
    public String rebind(TreeLogger logger, String typeName) throws UnableToCompleteException {
        return this.rebind(logger, typeName, null);
    }

    public String rebind(TreeLogger logger, String typeName, ArtifactAcceptor artifactAcceptor) throws UnableToCompleteException {
        String resultTypeName = this.typeNameBindingMap.get(typeName);
        if (resultTypeName == null) {
            logger = Messages.TRACE_TOPLEVEL_REBIND.branch(logger, typeName, null);
            Rebinder rebinder = new Rebinder();
            resultTypeName = rebinder.rebind(logger, typeName, artifactAcceptor);
            this.typeNameBindingMap.put(typeName, resultTypeName);
            Messages.TRACE_TOPLEVEL_REBIND_RESULT.log(logger, resultTypeName, null);
        }
        return resultTypeName;
    }

    public void setRebindCache(RebindCache cache) {
        this.rebindCache = cache;
    }

    private CachedGeneratorResult rebindCacheGet(Rule rule, String typeName) {
        if (this.rebindCache != null) {
            return this.rebindCache.get(rule, typeName);
        }
        return null;
    }

    private void rebindCachePut(Rule rule, String typeName, CachedGeneratorResult result) {
        if (this.rebindCache != null) {
            this.rebindCache.put(rule, typeName, result);
        }
    }

    private final class Rebinder
    implements RebindRuleResolver {
        private Rebinder() {
        }

        @Override
        public boolean checkRebindRuleResolvable(String typeName) {
            try {
                if (this.getRebindRule(TreeLogger.NULL, typeName) != null) {
                    return true;
                }
            }
            catch (UnableToCompleteException unableToCompleteException) {
                // empty catch block
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String rebind(TreeLogger logger, String typeName, ArtifactAcceptor artifactAcceptor) throws UnableToCompleteException {
            SpeedTracerLogger.Event rebindEvent = SpeedTracerLogger.start(DevModeEventType.REBIND, "Type Name", typeName);
            try {
                ArtifactSet newlyGeneratedArtifacts;
                StandardRebindOracle.this.genCtx.setPropertyOracle(StandardRebindOracle.this.propOracle);
                StandardRebindOracle.this.genCtx.setRebindRuleResolver(this);
                Rule rule = this.getRebindRule(logger, typeName);
                if (rule == null) {
                    String string = typeName;
                    return string;
                }
                CachedGeneratorResult cachedResult = StandardRebindOracle.this.rebindCacheGet(rule, typeName);
                if (cachedResult != null) {
                    StandardRebindOracle.this.genCtx.setCachedGeneratorResult(cachedResult);
                }
                RebindResult result = rule.realize(logger, StandardRebindOracle.this.genCtx, typeName);
                String resultTypeName = this.processCacheableResult(logger, rule, typeName, cachedResult, result);
                if (artifactAcceptor != null && !(newlyGeneratedArtifacts = StandardRebindOracle.this.genCtx.finish(logger)).isEmpty()) {
                    artifactAcceptor.accept(logger, newlyGeneratedArtifacts);
                }
                assert (resultTypeName != null);
                String string = resultTypeName;
                return string;
            }
            finally {
                rebindEvent.end(new String[0]);
            }
        }

        private Rule getRebindRule(TreeLogger logger, String typeName) throws UnableToCompleteException {
            if (StandardRebindOracle.this.rules.isEmpty()) {
                logger.log(TreeLogger.DEBUG, "No rules are defined, so no substitution can occur", null);
                return null;
            }
            Rule minCostRuleSoFar = null;
            for (Rule rule : StandardRebindOracle.this.rules) {
                TreeLogger branch;
                if (rule.isApplicable(branch = Messages.TRACE_CHECKING_RULE.branch(logger, rule, null), StandardRebindOracle.this.genCtx, typeName)) {
                    Messages.TRACE_RULE_MATCHED.log(logger, null);
                    return rule;
                }
                Messages.TRACE_RULE_DID_NOT_MATCH.log(logger, null);
                if (minCostRuleSoFar == null) {
                    minCostRuleSoFar = rule;
                }
                assert (rule.getFallbackEvaluationCost() != 0);
                if (rule.getFallbackEvaluationCost() > minCostRuleSoFar.getFallbackEvaluationCost()) continue;
                if (logger.isLoggable(TreeLogger.DEBUG)) {
                    logger.log(TreeLogger.DEBUG, "Found better fallback match for " + rule);
                }
                minCostRuleSoFar = rule;
            }
            assert (minCostRuleSoFar != null);
            if (minCostRuleSoFar.getFallbackEvaluationCost() < Integer.MAX_VALUE) {
                if (logger.isLoggable(TreeLogger.INFO)) {
                    logger.log(TreeLogger.INFO, "Could not find an exact match rule. Using 'closest' rule " + minCostRuleSoFar + " based on fall back values. You may need to implement a specific binding in case the fall back behavior does not replace the missing binding");
                }
                if (logger.isLoggable(TreeLogger.DEBUG)) {
                    logger.log(TreeLogger.DEBUG, "No exact match was found, using closest match rule " + minCostRuleSoFar);
                }
                return minCostRuleSoFar;
            }
            return null;
        }

        private String processCacheableResult(TreeLogger logger, Rule rule, String typeName, CachedGeneratorResult cachedResult, RebindResult newResult) {
            String resultTypeName = newResult.getResultTypeName();
            if (!StandardRebindOracle.this.genCtx.isGeneratorResultCachingEnabled()) {
                return resultTypeName;
            }
            RebindMode mode = newResult.getRebindMode();
            switch (mode) {
                case USE_EXISTING: {
                    break;
                }
                case USE_ALL_NEW_WITH_NO_CACHING: {
                    break;
                }
                case USE_ALL_NEW: {
                    cachedResult = new CachedGeneratorResultImpl(newResult.getResultTypeName(), StandardRebindOracle.this.genCtx.getArtifacts(), StandardRebindOracle.this.genCtx.getGeneratedUnitMap(), System.currentTimeMillis(), newResult.getClientDataMap());
                    StandardRebindOracle.this.rebindCachePut(rule, typeName, cachedResult);
                    break;
                }
                case USE_ALL_CACHED: {
                    assert (cachedResult != null);
                    StandardRebindOracle.this.genCtx.commitArtifactsFromCache(logger);
                    StandardRebindOracle.this.genCtx.addGeneratedUnitsFromCache();
                    resultTypeName = cachedResult.getResultTypeName();
                    break;
                }
                case USE_PARTIAL_CACHED: {
                    StandardRebindOracle.this.genCtx.addGeneratedUnitsMarkedForReuseFromCache();
                    cachedResult = new CachedGeneratorResultImpl(newResult.getResultTypeName(), StandardRebindOracle.this.genCtx.getArtifacts(), StandardRebindOracle.this.genCtx.getGeneratedUnitMap(), System.currentTimeMillis(), newResult.getClientDataMap());
                    StandardRebindOracle.this.rebindCachePut(rule, typeName, cachedResult);
                }
            }
            StandardRebindOracle.this.genCtx.setCachedGeneratorResult(null);
            return resultTypeName;
        }
    }
}

