/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.PrecompileTaskOptionsImpl;
import com.google.gwt.dev.RebindCache;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.Rule;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.StandardGeneratorContext;
import com.google.gwt.dev.shell.ArtifactAcceptor;
import com.google.gwt.dev.shell.CompilingClassLoader;
import com.google.gwt.dev.shell.ModuleSpace;
import com.google.gwt.dev.shell.ModuleSpaceHost;
import com.google.gwt.dev.shell.ModuleSpacePropertyOracle;
import com.google.gwt.dev.shell.StandardRebindOracle;
import com.google.gwt.dev.util.log.speedtracer.DevModeEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import java.io.File;
import java.util.Deque;

public class ShellModuleSpaceHost
implements ModuleSpaceHost {
    private static final Object rebindLock = new Object[0];
    protected final CompilationState compilationState;
    protected final File genDir;
    private final ArtifactAcceptor artifactAcceptor;
    private CompilingClassLoader classLoader;
    private final TreeLogger logger;
    private final ModuleDef module;
    private StandardRebindOracle rebindOracle;
    private ModuleSpace space;
    private RebindCache rebindCache;

    public ShellModuleSpaceHost(TreeLogger logger, CompilationState compilationState, ModuleDef module, File genDir, ArtifactAcceptor artifactAcceptor, RebindCache rebindCache) {
        this.logger = logger;
        this.compilationState = compilationState;
        this.module = module;
        this.genDir = genDir;
        this.artifactAcceptor = artifactAcceptor;
        this.rebindCache = rebindCache;
    }

    @Override
    public CompilingClassLoader getClassLoader() {
        this.checkForModuleSpace();
        return this.classLoader;
    }

    @Override
    public String[] getEntryPointTypeNames() {
        this.checkForModuleSpace();
        return this.module.getEntryPointTypeNames();
    }

    @Override
    public TreeLogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onModuleReady(ModuleSpace readySpace) throws UnableToCompleteException {
        this.space = readySpace;
        SpeedTracerLogger.Event moduleSpaceHostReadyEvent = SpeedTracerLogger.start(DevModeEventType.MODULE_SPACE_HOST_READY, new String[0]);
        try {
            ModuleSpacePropertyOracle propOracle = new ModuleSpacePropertyOracle(this.module.getProperties(), this.module.getActiveLinkerNames(), readySpace);
            Deque<Rule> rules = this.module.getRules();
            PrecompileTaskOptionsImpl options = new PrecompileTaskOptionsImpl();
            options.setGenDir(this.genDir);
            CompilerContext compilerContext = new CompilerContext.Builder().module(this.module).options(options).build();
            StandardGeneratorContext genCtx = new StandardGeneratorContext(compilerContext, this.compilationState, new ArtifactSet(), false);
            genCtx.setGeneratorResultCachingEnabled(this.rebindCache != null);
            this.rebindOracle = new StandardRebindOracle(propOracle, rules, genCtx);
            this.rebindOracle.setRebindCache(this.rebindCache);
            this.classLoader = new CompilingClassLoader(this.logger, this.compilationState, readySpace);
        }
        finally {
            moduleSpaceHostReadyEvent.end(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rebind(TreeLogger logger, String sourceTypeName) throws UnableToCompleteException {
        Object object = rebindLock;
        synchronized (object) {
            this.checkForModuleSpace();
            return this.rebindOracle.rebind(logger, sourceTypeName, new ArtifactAcceptor(){

                @Override
                public void accept(TreeLogger logger, ArtifactSet newlyGeneratedArtifacts) throws UnableToCompleteException {
                    ShellModuleSpaceHost.this.artifactAcceptor.accept(logger, newlyGeneratedArtifacts);
                }
            });
        }
    }

    private void checkForModuleSpace() {
        if (this.space == null) {
            throw new IllegalStateException("Module initialization error");
        }
    }
}

