/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.shell.WrapLayout;
import com.google.gwt.dev.shell.log.SwingLoggerPanel;
import com.google.gwt.dev.util.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShellMainWindow
extends JPanel {
    private SwingLoggerPanel logWindow;
    private JComboBox urlCombo;
    private JButton defaultBrowserButton;
    private JButton copyToClipboardButton;
    private JLabel loadingMessage;
    private JPanel launchPanel = new JPanel(new WrapLayout());

    public ShellMainWindow(TreeLogger.Type maxLevel, File logFile) {
        super(new BorderLayout());
        this.launchPanel.setBorder(BorderFactory.createTitledBorder("Launch GWT Module"));
        this.launchPanel.add(new JLabel("Startup URL:"));
        JPanel startupPanel = new JPanel();
        this.urlCombo = new JComboBox();
        this.urlCombo.addItem("Computing...");
        startupPanel.add(this.urlCombo);
        this.launchPanel.add(startupPanel);
        this.loadingMessage = new JLabel("Loading...");
        this.launchPanel.add(this.loadingMessage);
        this.defaultBrowserButton = new JButton("Launch Default Browser");
        this.defaultBrowserButton.setMnemonic(76);
        this.defaultBrowserButton.setEnabled(false);
        this.defaultBrowserButton.setVisible(false);
        this.defaultBrowserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShellMainWindow.this.launch(new DefaultBrowserLauncher());
            }
        });
        this.launchPanel.add(this.defaultBrowserButton);
        this.copyToClipboardButton = new JButton("Copy to Clipboard");
        this.copyToClipboardButton.setMnemonic(67);
        this.copyToClipboardButton.setEnabled(false);
        this.copyToClipboardButton.setVisible(false);
        this.copyToClipboardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShellMainWindow.this.launch(new CopyToClipboardLauncher());
            }
        });
        this.launchPanel.add(this.copyToClipboardButton);
        this.add((Component)this.launchPanel, "North");
        this.logWindow = new SwingLoggerPanel(maxLevel, logFile);
        this.add(this.logWindow);
    }

    public TreeLogger getLogger() {
        return this.logWindow.getLogger();
    }

    public void moduleLoadComplete(boolean successfulLoad) {
        if (!successfulLoad) {
            this.loadingMessage.setText("Module Load Failure");
            this.loadingMessage.setForeground(Color.RED);
            return;
        }
        if (this.urlCombo.getItemCount() == 0) {
            this.loadingMessage.setText("No URLs to Launch");
            this.loadingMessage.setForeground(Color.RED);
            this.urlCombo.addItem("No startup URLs");
            this.urlCombo.setEnabled(false);
            return;
        }
        this.loadingMessage.setVisible(false);
        this.defaultBrowserButton.setVisible(true);
        this.defaultBrowserButton.setEnabled(true);
        this.copyToClipboardButton.setVisible(true);
        this.copyToClipboardButton.setEnabled(true);
        this.launchPanel.revalidate();
        this.launchPanel.repaint();
    }

    public void setStartupUrls(Map<String, URL> urls) {
        this.urlCombo.removeAllItems();
        ArrayList<String> keys = new ArrayList<String>(urls.keySet());
        Collections.sort(keys);
        for (String url : keys) {
            this.urlCombo.addItem(new UrlComboEntry(url, urls.get(url)));
        }
        this.urlCombo.revalidate();
    }

    protected void launch(LaunchMethod launcher) {
        UrlComboEntry selectedUrl = (UrlComboEntry)this.urlCombo.getSelectedItem();
        if (launcher == null || selectedUrl == null) {
            return;
        }
        URL url = selectedUrl.getUrl();
        launcher.launchUrl(url);
    }

    private static class UrlComboEntry {
        private final String urlFragment;
        private final URL url;

        public UrlComboEntry(String urlFragment, URL url) {
            this.urlFragment = urlFragment;
            this.url = url;
        }

        public URL getUrl() {
            return this.url;
        }

        public String toString() {
            return this.urlFragment;
        }
    }

    private static abstract class LaunchMethod {
        private final String displayName;

        public LaunchMethod(String displayName) {
            this.displayName = displayName;
        }

        public abstract void launchUrl(URL var1);

        public String toString() {
            return this.displayName;
        }
    }

    private class DefaultBrowserLauncher
    extends LaunchMethod {
        public DefaultBrowserLauncher() {
            super("Default browser");
        }

        @Override
        public void launchUrl(URL url) {
            Exception caught = null;
            try {
                BrowserLauncher.browse(url.toExternalForm());
                return;
            }
            catch (IOException e) {
                caught = e;
            }
            catch (URISyntaxException e) {
                caught = e;
            }
            TreeLogger branch = ShellMainWindow.this.getLogger().branch(TreeLogger.ERROR, "Unable to launch default browser", caught);
            if (branch.isLoggable(TreeLogger.INFO)) {
                branch.log(TreeLogger.INFO, url.toExternalForm());
            }
        }
    }

    private class CopyToClipboardLauncher
    extends LaunchMethod {
        public CopyToClipboardLauncher() {
            super("Copy URL to clipboard");
        }

        @Override
        public void launchUrl(URL url) {
            if (ShellMainWindow.this.getLogger().isLoggable(TreeLogger.INFO)) {
                ShellMainWindow.this.getLogger().log(TreeLogger.INFO, "Paste " + url.toExternalForm() + " into a browser");
            }
            RuntimeException caught = null;
            try {
                Clipboard clipboard = ShellMainWindow.this.logWindow.getToolkit().getSystemClipboard();
                StringSelection selection = new StringSelection(url.toExternalForm());
                clipboard.setContents(selection, selection);
                return;
            }
            catch (SecurityException e) {
                caught = e;
            }
            catch (HeadlessException e) {
                caught = e;
            }
            ShellMainWindow.this.getLogger().log(TreeLogger.ERROR, "Unable to copy URL to clipboard", caught);
        }
    }
}

