/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;

public class ServerObjectsTable {
    private int nextFree = -1;
    private int nextId = 0;
    private final Map<Integer, Object> objects = new TreeMap<Integer, Object>();
    private final Map<Object, Integer> refMap = new IdentityHashMap<Object, Integer>();

    public int add(Object obj) {
        int id = this.find(obj);
        if (id >= 0) {
            return id;
        }
        if (this.nextFree >= 0) {
            id = this.nextFree;
            this.nextFree = ((Tombstone)this.objects.get(id)).nextFree;
        } else {
            id = this.nextId++;
        }
        this.objects.put(id, obj);
        this.refMap.put(obj, id);
        return id;
    }

    public int find(Object obj) {
        Integer objId = this.refMap.get(obj);
        return objId != null ? objId : -1;
    }

    public void free(int id) {
        Object object = this.objects.get(id);
        assert (object != null) : "Trying to free never-used id " + id;
        assert (!(object instanceof Tombstone)) : "Duplicate free " + id;
        this.refMap.remove(object);
        this.objects.put(id, new Tombstone(this.nextFree));
        this.nextFree = id;
    }

    public Object get(int id) {
        Object toReturn = this.objects.get(id);
        assert (!(toReturn instanceof Tombstone)) : id + " is not an active id";
        return toReturn;
    }

    private static class Tombstone {
        private final int nextFree;

        public Tombstone(int nextFree) {
            this.nextFree = nextFree;
        }
    }
}

