/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.dev.shell.BrowserChannel;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class RemoteObjectTable<T extends BrowserChannel.RemoteObjectRef> {
    private final Map<Reference<T>, Integer> idFromRemoteObject;
    private final ReferenceQueue<T> refQueue = new ReferenceQueue();
    private final Map<Integer, Reference<T>> remoteObjectFromId = new HashMap<Integer, Reference<T>>();

    public RemoteObjectTable() {
        this.idFromRemoteObject = new IdentityHashMap<Reference<T>, Integer>();
    }

    public synchronized Set<Integer> getRefIdsForCleanup() {
        Object i;
        Reference<T> ref;
        Map<Integer, Reference<T>> objectMap = this.remoteObjectFromId;
        Map<Reference<T>, Integer> refIdMap = this.idFromRemoteObject;
        HashSet<Integer> toReturn = new HashSet<Integer>();
        while ((ref = this.refQueue.poll()) != null) {
            i = refIdMap.remove(ref);
            assert (i != null);
            toReturn.add((Integer)i);
        }
        i = toReturn.iterator();
        while (i.hasNext()) {
            Integer refId = (Integer)i.next();
            if (!objectMap.containsKey(refId)) continue;
            if (objectMap.get(refId).get() != null) {
                i.remove();
                continue;
            }
            objectMap.remove(refId);
        }
        return toReturn;
    }

    public synchronized T getRemoteObjectRef(int refId) {
        Reference<T> ref;
        BrowserChannel.RemoteObjectRef toReturn;
        if (this.remoteObjectFromId.containsKey(refId) && (toReturn = (BrowserChannel.RemoteObjectRef)(ref = this.remoteObjectFromId.get(refId)).get()) != null) {
            return (T)toReturn;
        }
        return null;
    }

    public synchronized void putRemoteObjectRef(int refId, T remoteObjectRef) {
        WeakReference<T> ref = new WeakReference<T>(remoteObjectRef, this.refQueue);
        this.remoteObjectFromId.put(refId, ref);
        this.idFromRemoteObject.put(ref, refId);
    }
}

