/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.ModuleHandle;
import com.google.gwt.dev.shell.BrowserChannel;
import com.google.gwt.dev.shell.BrowserChannelServer;
import com.google.gwt.dev.shell.BrowserWidgetHost;
import com.google.gwt.dev.shell.CompilingClassLoader;
import com.google.gwt.dev.shell.DispatchClassInfo;
import com.google.gwt.dev.shell.JsValue;
import com.google.gwt.dev.shell.JsValueGlue;
import com.google.gwt.dev.shell.JsValueOOPHM;
import com.google.gwt.dev.shell.ModuleSpace;
import com.google.gwt.dev.shell.ModuleSpaceHost;
import com.google.gwt.dev.shell.ModuleSpaceOOPHM;
import com.google.gwt.dev.shell.ServerObjectsTable;
import com.google.gwt.dev.util.log.speedtracer.DevModeEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OophmSessionHandler
extends BrowserChannelServer.SessionHandlerServer {
    private BrowserWidgetHost host;
    private Map<BrowserChannelServer, ModuleSpace> moduleMap = Collections.synchronizedMap(new HashMap());
    private Map<BrowserChannelServer, ModuleHandle> moduleHandleMap = Collections.synchronizedMap(new HashMap());
    private final TreeLogger topLogger;

    public OophmSessionHandler(TreeLogger topLogger, BrowserWidgetHost host) {
        this.host = host;
        this.topLogger = topLogger;
    }

    @Override
    public void freeValue(BrowserChannelServer channel, int[] ids) {
        ServerObjectsTable localObjects = channel.getJavaObjectsExposedInBrowser();
        for (int id : ids) {
            localObjects.free(id);
        }
    }

    @Override
    public BrowserChannel.SessionHandler.ExceptionOrReturnValue getProperty(BrowserChannelServer channel, int refId, int dispId) {
        ModuleSpace moduleSpace = this.moduleMap.get(channel);
        ModuleHandle moduleHandle = this.moduleHandleMap.get(channel);
        assert (moduleSpace != null && moduleHandle != null);
        TreeLogger logger = moduleHandle.getLogger();
        ServerObjectsTable localObjects = channel.getJavaObjectsExposedInBrowser();
        try {
            JsValueOOPHM obj = new JsValueOOPHM();
            CompilingClassLoader ccl = moduleSpace.getIsolatedClassLoader();
            obj.setWrappedJavaObject(ccl, localObjects.get(refId));
            JsValue.DispatchObject dispObj = obj.getJavaObjectWrapper();
            TreeLogger branch = logger.branch(TreeLogger.SPAM, "Client special invoke of getProperty(" + dispId + " [" + ccl.getClassInfoByDispId(dispId).getMember(dispId) + "]) on " + obj.toString(), null);
            JsValueOOPHM jsval = (JsValueOOPHM)dispObj.getField(dispId);
            BrowserChannel.Value retVal = channel.convertFromJsValue(localObjects, jsval);
            if (logger.isLoggable(TreeLogger.SPAM)) {
                branch.log(TreeLogger.SPAM, "result is " + retVal, null);
            }
            return new BrowserChannel.SessionHandler.ExceptionOrReturnValue(false, retVal);
        }
        catch (Throwable t) {
            JsValueOOPHM jsval = new JsValueOOPHM();
            JsValueGlue.set(jsval, moduleSpace.getIsolatedClassLoader(), t.getClass(), t);
            BrowserChannel.Value retVal = channel.convertFromJsValue(localObjects, jsval);
            return new BrowserChannel.SessionHandler.ExceptionOrReturnValue(true, retVal);
        }
    }

    @Override
    public BrowserChannel.SessionHandler.ExceptionOrReturnValue invoke(BrowserChannelServer channel, BrowserChannel.Value thisVal, int methodDispatchId, BrowserChannel.Value[] args) {
        boolean exception;
        Member member;
        DispatchClassInfo clsInfo;
        SpeedTracerLogger.Event jsToJavaCallEvent = SpeedTracerLogger.start(channel.getDevModeSession(), DevModeEventType.JS_TO_JAVA_CALL, new String[0]);
        ServerObjectsTable localObjects = channel.getJavaObjectsExposedInBrowser();
        ModuleSpace moduleSpace = this.moduleMap.get(channel);
        ModuleHandle moduleHandle = this.moduleHandleMap.get(channel);
        assert (moduleSpace != null && moduleHandle != null);
        TreeLogger logger = moduleHandle.getLogger();
        CompilingClassLoader cl = moduleSpace.getIsolatedClassLoader();
        if (methodDispatchId == 0) {
            methodDispatchId = cl.getDispId("java.lang.Object::toString()");
        }
        JsValueOOPHM jsThis = new JsValueOOPHM();
        channel.convertToJsValue(cl, localObjects, thisVal, jsThis);
        if (SpeedTracerLogger.jsniCallLoggingEnabled() && (clsInfo = cl.getClassInfoByDispId(methodDispatchId)) != null && (member = clsInfo.getMember(methodDispatchId)) != null) {
            jsToJavaCallEvent.addData("name", member.toString());
        }
        TreeLogger branch = TreeLogger.NULL;
        if (logger.isLoggable(TreeLogger.SPAM)) {
            Member member2;
            StringBuffer logMsg = new StringBuffer();
            logMsg.append("Client invoke of ");
            logMsg.append(methodDispatchId);
            DispatchClassInfo classInfo = cl.getClassInfoByDispId(methodDispatchId);
            if (classInfo != null && (member2 = classInfo.getMember(methodDispatchId)) != null) {
                logMsg.append(" (");
                logMsg.append(member2.getName());
                logMsg.append(")");
            }
            logMsg.append(" on ");
            logMsg.append(jsThis.toString());
            branch = logger.branch(TreeLogger.SPAM, logMsg.toString(), null);
        }
        JsValue[] jsArgs = new JsValueOOPHM[args.length];
        for (int i = 0; i < args.length; ++i) {
            jsArgs[i] = new JsValueOOPHM();
            channel.convertToJsValue(cl, localObjects, args[i], jsArgs[i]);
            if (!logger.isLoggable(TreeLogger.SPAM)) continue;
            branch.log(TreeLogger.SPAM, " arg " + i + " = " + jsArgs[i].toString(), null);
        }
        JsValueOOPHM jsRetVal = new JsValueOOPHM();
        JsValue.DispatchObject dispObj = jsThis.isWrappedJavaObject() ? jsThis.getJavaObjectWrapper() : (JsValue.DispatchObject)moduleSpace.getStaticDispatcher();
        JsValueOOPHM jsMethod = (JsValueOOPHM)dispObj.getField(methodDispatchId);
        JsValue.DispatchMethod dispMethod = jsMethod.getWrappedJavaFunction();
        try {
            exception = dispMethod.invoke(jsThis, jsArgs, jsRetVal);
        }
        catch (Throwable t) {
            exception = true;
            JsValueGlue.set(jsRetVal, moduleSpace.getIsolatedClassLoader(), t.getClass(), t);
        }
        BrowserChannel.Value retVal = channel.convertFromJsValue(localObjects, jsRetVal);
        jsToJavaCallEvent.end(new String[0]);
        return new BrowserChannel.SessionHandler.ExceptionOrReturnValue(exception, retVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TreeLogger loadModule(BrowserChannelServer channel, String moduleName, String userAgent, String url, String tabKey, String sessionKey, byte[] userAgentIcon) {
        SpeedTracerLogger.Event moduleInit = SpeedTracerLogger.start(channel.getDevModeSession(), DevModeEventType.MODULE_INIT, "Module Name", moduleName);
        ModuleHandle moduleHandle = this.host.createModuleLogger(moduleName, userAgent, url, tabKey, sessionKey, channel, userAgentIcon);
        TreeLogger logger = moduleHandle.getLogger();
        this.moduleHandleMap.put(channel, moduleHandle);
        ModuleSpaceOOPHM moduleSpace = null;
        try {
            ModuleSpaceHost msh = this.host.createModuleSpaceHost(moduleHandle, moduleName);
            moduleSpace = new ModuleSpaceOOPHM(msh, moduleName, channel);
            this.moduleMap.put(channel, moduleSpace);
            moduleSpace.onLoad(logger);
            if (logger.isLoggable(TreeLogger.INFO)) {
                moduleHandle.getLogger().log(TreeLogger.INFO, "Module " + moduleName + " has been loaded");
            }
        }
        catch (Throwable e) {
            moduleHandle.getLogger().log(TreeLogger.ERROR, "Failed to load module '" + moduleName + "' from user agent '" + userAgent + "' at " + channel.getRemoteEndpoint(), e);
            if (moduleSpace != null) {
                moduleSpace.dispose();
            }
            moduleHandle.unload();
            this.moduleMap.remove(channel);
            this.moduleHandleMap.remove(channel);
            TreeLogger treeLogger = null;
            return treeLogger;
        }
        finally {
            moduleInit.end(new String[0]);
        }
        return moduleHandle.getLogger();
    }

    @Override
    public BrowserChannel.SessionHandler.ExceptionOrReturnValue setProperty(BrowserChannelServer channel, int refId, int dispId, BrowserChannel.Value newValue) {
        ModuleSpace moduleSpace = this.moduleMap.get(channel);
        ModuleHandle moduleHandle = this.moduleHandleMap.get(channel);
        assert (moduleSpace != null && moduleHandle != null);
        TreeLogger logger = moduleHandle.getLogger();
        ServerObjectsTable localObjects = channel.getJavaObjectsExposedInBrowser();
        try {
            JsValueOOPHM obj = new JsValueOOPHM();
            obj.setWrappedJavaObject(moduleSpace.getIsolatedClassLoader(), localObjects.get(refId));
            JsValue.DispatchObject dispObj = obj.getJavaObjectWrapper();
            if (logger.isLoggable(TreeLogger.SPAM)) {
                logger.log(TreeLogger.SPAM, "Client special invoke of setProperty(id=" + dispId + ", newValue=" + newValue + ") on " + obj.toString(), null);
            }
            JsValueOOPHM jsval = new JsValueOOPHM();
            channel.convertToJsValue(moduleSpace.getIsolatedClassLoader(), localObjects, newValue, jsval);
            dispObj.setField(dispId, (JsValue)jsval);
            return new BrowserChannel.SessionHandler.ExceptionOrReturnValue(false, newValue);
        }
        catch (Throwable t) {
            JsValueOOPHM jsval = new JsValueOOPHM();
            JsValueGlue.set(jsval, moduleSpace.getIsolatedClassLoader(), t.getClass(), t);
            BrowserChannel.Value retVal = channel.convertFromJsValue(localObjects, jsval);
            return new BrowserChannel.SessionHandler.ExceptionOrReturnValue(true, retVal);
        }
    }

    @Override
    public void unloadModule(BrowserChannelServer channel, String moduleName) {
        ModuleHandle moduleHandle = this.moduleHandleMap.get(channel);
        ModuleSpace moduleSpace = this.moduleMap.get(channel);
        if (moduleSpace == null || moduleHandle == null) {
            this.topLogger.log(TreeLogger.ERROR, "Unload request without a module loaded", null);
            return;
        }
        moduleHandle.getLogger().log(TreeLogger.INFO, "Unloading module " + moduleSpace.getModuleName() + " (" + moduleName + ")", null);
        moduleSpace.dispose();
        moduleHandle.unload();
        this.moduleMap.remove(channel);
        this.moduleHandleMap.remove(channel);
    }
}

