/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.DefaultConfigurationProperty;
import com.google.gwt.core.ext.DefaultSelectionProperty;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.Condition;
import com.google.gwt.dev.cfg.ConfigurationProperty;
import com.google.gwt.dev.cfg.DeferredBindingQuery;
import com.google.gwt.dev.cfg.Properties;
import com.google.gwt.dev.cfg.Property;
import com.google.gwt.dev.shell.ModuleSpace;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ModuleSpacePropertyOracle
implements PropertyOracle {
    private final Set<String> activeLinkerNames;
    private final Map<String, String> prevAnswers = new HashMap<String, String>();
    private final Properties properties;
    private final ModuleSpace space;

    public ModuleSpacePropertyOracle(Properties properties, Set<String> activeLinkerNames, ModuleSpace space) {
        this.space = space;
        this.activeLinkerNames = activeLinkerNames;
        this.properties = properties;
    }

    @Override
    public com.google.gwt.core.ext.ConfigurationProperty getConfigurationProperty(String propertyName) throws BadPropertyValueException {
        Property prop = this.getProperty(propertyName);
        if (prop instanceof ConfigurationProperty) {
            ConfigurationProperty cprop = (ConfigurationProperty)prop;
            String name = cprop.getName();
            List<String> values = cprop.getValues();
            return new DefaultConfigurationProperty(name, values);
        }
        throw new BadPropertyValueException(propertyName);
    }

    @Override
    public SelectionProperty getSelectionProperty(TreeLogger logger, String propertyName) throws BadPropertyValueException {
        Property prop = this.getProperty(propertyName);
        if (prop instanceof BindingProperty) {
            String value;
            BindingProperty cprop = (BindingProperty)prop;
            String name = cprop.getName();
            if (this.prevAnswers.containsKey(propertyName)) {
                value = this.prevAnswers.get(propertyName);
            } else {
                value = this.computePropertyValue(logger, propertyName, cprop);
                this.prevAnswers.put(propertyName, value);
            }
            String fallback = cprop.getFallback();
            TreeSet<String> possibleValues = new TreeSet<String>();
            for (String v : cprop.getDefinedValues()) {
                possibleValues.add(v);
            }
            return new DefaultSelectionProperty(value, fallback, name, possibleValues, cprop.getFallbackValuesMap());
        }
        throw new BadPropertyValueException(propertyName);
    }

    private Condition computeActiveCondition(TreeLogger logger, BindingProperty prop) throws BadPropertyValueException {
        Condition winner = null;
        for (Condition cond : prop.getConditionalValues().keySet()) {
            try {
                if (!cond.isTrue(logger, new DeferredBindingQuery(this, this.activeLinkerNames))) continue;
                winner = cond;
            }
            catch (UnableToCompleteException e) {
                BadPropertyValueException t = new BadPropertyValueException(prop.getName());
                t.initCause(e);
                throw t;
            }
        }
        assert (winner != null) : "No active Condition for " + prop.getName();
        return winner;
    }

    private String computePropertyValue(TreeLogger logger, String propertyName, BindingProperty prop) throws BadPropertyValueException {
        String value = prop.getConstrainedValue();
        if (value != null) {
            return value;
        }
        Condition winner = this.computeActiveCondition(logger, prop);
        String[] values = prop.getGeneratedValues(winner);
        if (values.length == 1) {
            return values[0];
        }
        try {
            value = (String)this.space.invokeNativeObject("__gwt_getProperty", null, new Class[]{String.class}, new Object[]{prop.getName()});
        }
        catch (Throwable e) {
            String msg = "Error while executing the JavaScript provider for property '" + propertyName + "'";
            logger.log(TreeLogger.ERROR, msg, e);
            throw new BadPropertyValueException(propertyName, "<failed to compute>");
        }
        if (Arrays.asList(values).contains(value)) {
            return value;
        }
        throw new BadPropertyValueException(propertyName, value);
    }

    private Property getProperty(String propertyName) throws BadPropertyValueException {
        if (propertyName == null) {
            throw new NullPointerException("propertyName");
        }
        Property prop = this.properties.find(propertyName);
        if (prop == null) {
            throw new BadPropertyValueException(propertyName);
        }
        return prop;
    }
}

