/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.javac.JsniMethod;
import com.google.gwt.dev.shell.BrowserChannelServer;
import com.google.gwt.dev.shell.CompilingClassLoader;
import com.google.gwt.dev.shell.DispatchIdOracle;
import com.google.gwt.dev.shell.JsValue;
import com.google.gwt.dev.shell.JsValueGlue;
import com.google.gwt.dev.shell.JsValueOOPHM;
import com.google.gwt.dev.shell.Jsni;
import com.google.gwt.dev.shell.ModuleSpace;
import com.google.gwt.dev.shell.ModuleSpaceHost;
import com.google.gwt.dev.util.log.speedtracer.DevModeEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import java.util.List;

public class ModuleSpaceOOPHM
extends ModuleSpace {
    private BrowserChannelServer channel;

    public ModuleSpaceOOPHM(ModuleSpaceHost msh, String moduleName, BrowserChannelServer channel) {
        super(msh.getLogger(), msh, moduleName);
        this.channel = channel;
        msh.getLogger().log(TreeLogger.DEBUG, "Created ModuleSpaceOOPHM for " + moduleName, null);
    }

    @Override
    public void createNativeMethods(TreeLogger logger, List<JsniMethod> jsniMethods, DispatchIdOracle dispatchIdOracle) {
        if (jsniMethods.isEmpty()) {
            return;
        }
        StringBuilder jsni = new StringBuilder();
        for (JsniMethod jsniMethod : jsniMethods) {
            String body;
            if (jsniMethod.isScriptOnly() || (body = Jsni.getJavaScriptForHostedMode(dispatchIdOracle, jsniMethod)) == null) continue;
            jsni.append("// " + jsniMethod.location() + ":" + jsniMethod.line() + "\n");
            jsni.append("this[\"" + jsniMethod.name() + "\"] = function(");
            String[] paramNames = jsniMethod.paramNames();
            for (int i = 0; i < paramNames.length; ++i) {
                if (i > 0) {
                    jsni.append(", ");
                }
                jsni.append(paramNames[i]);
            }
            jsni.append(") ");
            jsni.append(body);
            jsni.append(";\n\n");
        }
        this.channel.loadJsni(jsni.toString());
    }

    @Override
    protected void createStaticDispatcher(TreeLogger logger) {
        this.channel.loadJsni("function __defineStatic(__arg0) { window.__static = __arg0; }");
    }

    @Override
    protected JsValue doInvoke(String name, Object jthis, Class<?>[] types, Object[] args) throws Throwable {
        TreeLogger branch = this.host.getLogger().branch(TreeLogger.SPAM, "Invoke native method " + name, null);
        SpeedTracerLogger.Event javaToJsCallEvent = SpeedTracerLogger.start(DevModeEventType.JAVA_TO_JS_CALL, new String[0]);
        if (SpeedTracerLogger.jsniCallLoggingEnabled()) {
            javaToJsCallEvent.addData("name", name);
        }
        CompilingClassLoader isolatedClassLoader = this.getIsolatedClassLoader();
        JsValueOOPHM jsthis = new JsValueOOPHM();
        Class jthisType = jthis == null ? Object.class : jthis.getClass();
        JsValueGlue.set(jsthis, isolatedClassLoader, jthisType, jthis);
        if (branch.isLoggable(TreeLogger.SPAM)) {
            branch.log(TreeLogger.SPAM, "  this=" + jsthis);
        }
        int argc = args.length;
        JsValueOOPHM[] argv = new JsValueOOPHM[argc];
        for (int i = 0; i < argc; ++i) {
            argv[i] = new JsValueOOPHM();
            JsValueGlue.set(argv[i], isolatedClassLoader, types[i], args[i]);
            if (!branch.isLoggable(TreeLogger.SPAM)) continue;
            branch.log(TreeLogger.SPAM, "  arg[" + i + "]=" + argv[i]);
        }
        JsValueOOPHM returnVal = new JsValueOOPHM();
        try {
            this.channel.invokeJavascript(isolatedClassLoader, jsthis, name, argv, returnVal);
            if (branch.isLoggable(TreeLogger.SPAM)) {
                branch.log(TreeLogger.SPAM, "  returned " + returnVal);
            }
            JsValueOOPHM jsValueOOPHM = returnVal;
            return jsValueOOPHM;
        }
        catch (Throwable t) {
            branch.log(TreeLogger.SPAM, "exception thrown", t);
            throw t;
        }
        finally {
            javaToJsCallEvent.end(new String[0]);
        }
    }

    @Override
    protected JsValue.DispatchObject getStaticDispatcher() {
        return new JsValueOOPHM.DispatchObjectOOPHM(this.getIsolatedClassLoader());
    }
}

