/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.shell.CompilingClassLoader;
import com.google.gwt.dev.shell.HostedModeException;
import com.google.gwt.dev.shell.JavaScriptHost;
import com.google.gwt.dev.shell.JsValue;
import com.google.gwt.dev.shell.JsValueGlue;
import com.google.gwt.dev.shell.ModuleSpaceHost;
import com.google.gwt.dev.shell.ShellJavaScriptHost;
import com.google.gwt.dev.util.Name;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.log.speedtracer.DevModeEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;

public abstract class ModuleSpace
implements ShellJavaScriptHost {
    private static ThreadLocal<Throwable> sCaughtJavaExceptionObject = new ThreadLocal();
    private static ThreadLocal<Throwable> sThrownJavaExceptionObject = new ThreadLocal();
    private static ThreadLocal<TreeLogger> threadLocalLogger = new ThreadLocal();
    protected final ModuleSpaceHost host;
    private final TreeLogger logger;
    private final String moduleName;

    public static void setThrownJavaException(Throwable t) {
        sThrownJavaExceptionObject.set(t);
    }

    protected static RuntimeException createJavaScriptException(ClassLoader cl, Object exception) {
        return ModuleSpace.createJavaScriptException(cl, exception, "");
    }

    protected static RuntimeException createJavaScriptException(ClassLoader cl, Object exception, String message) {
        Exception caught;
        try {
            Class<?> javaScriptExceptionClass = Class.forName("com.google.gwt.core.client.JavaScriptException", true, cl);
            Constructor<?> ctor = javaScriptExceptionClass.getDeclaredConstructor(Object.class, String.class);
            return (RuntimeException)ctor.newInstance(exception, message);
        }
        catch (InstantiationException e) {
            caught = e;
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        catch (SecurityException e) {
            caught = e;
        }
        catch (ClassNotFoundException e) {
            caught = e;
        }
        catch (NoSuchMethodException e) {
            caught = e;
        }
        catch (IllegalArgumentException e) {
            caught = e;
        }
        catch (InvocationTargetException e) {
            caught = e;
        }
        throw new RuntimeException("Error creating JavaScriptException", caught);
    }

    protected static TreeLogger getLogger() {
        return threadLocalLogger.get();
    }

    static Object getThrownObject(ClassLoader cl, Object exception) {
        Exception caught;
        if (exception.getClass().getClassLoader() != cl) {
            return exception;
        }
        try {
            Class<?> javaScriptExceptionClass = Class.forName("com.google.gwt.core.client.JavaScriptException", true, cl);
            if (!javaScriptExceptionClass.isInstance(exception)) {
                return exception;
            }
            Method isThrownSet = javaScriptExceptionClass.getMethod("isThrownSet", new Class[0]);
            if (!((Boolean)isThrownSet.invoke(exception, new Object[0])).booleanValue()) {
                return exception;
            }
            Method getThrown = javaScriptExceptionClass.getMethod("getThrown", new Class[0]);
            return getThrown.invoke(exception, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            caught = e;
        }
        catch (ClassNotFoundException e) {
            caught = e;
        }
        catch (IllegalArgumentException e) {
            caught = e;
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        catch (InvocationTargetException e) {
            caught = e;
        }
        throw new RuntimeException("Error getting exception value", caught);
    }

    protected ModuleSpace(TreeLogger logger, ModuleSpaceHost host, String moduleName) {
        this.host = host;
        this.moduleName = moduleName;
        this.logger = logger;
        threadLocalLogger.set(host.getLogger());
    }

    public void dispose() {
        this.getIsolatedClassLoader().clear();
    }

    @Override
    public void exceptionCaught(Object exception) {
        Throwable caught;
        Throwable thrown = sThrownJavaExceptionObject.get();
        if (thrown != null && this.isExceptionSame(thrown, exception)) {
            caught = thrown;
            sThrownJavaExceptionObject.set(null);
        } else if (exception instanceof Throwable) {
            caught = (Throwable)exception;
        } else {
            caught = ModuleSpace.createJavaScriptException(this.getIsolatedClassLoader(), exception);
            caught.fillInStackTrace();
            StackTraceElement[] trace = caught.getStackTrace();
            assert (trace.length > 1);
            assert (trace[1].getClassName().equals(JavaScriptHost.class.getName()));
            assert (trace[1].getMethodName().equals("exceptionCaught"));
            StackTraceElement[] newTrace = new StackTraceElement[trace.length - 1];
            System.arraycopy(trace, 1, newTrace, 0, newTrace.length);
            caught.setStackTrace(newTrace);
        }
        sCaughtJavaExceptionObject.set(caught);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public boolean invokeNativeBoolean(String name, Object jthis, Class<?>[] types, Object[] args) throws Throwable {
        JsValue result = this.invokeNative(name, jthis, types, args);
        String msgPrefix = this.composeResultErrorMsgPrefix(name, "a boolean");
        Boolean value = JsValueGlue.get(result, this.getIsolatedClassLoader(), Boolean.TYPE, msgPrefix);
        if (value == null) {
            throw new HostedModeException(msgPrefix + ": return value null received, expected a boolean");
        }
        return value;
    }

    @Override
    public byte invokeNativeByte(String name, Object jthis, Class<?>[] types, Object[] args) throws Throwable {
        String msgPrefix;
        JsValue result = this.invokeNative(name, jthis, types, args);
        Byte value = JsValueGlue.get(result, null, Byte.TYPE, msgPrefix = this.composeResultErrorMsgPrefix(name, "a byte"));
        if (value == null) {
            throw new HostedModeException(msgPrefix + ": return value null received, expected a byte");
        }
        return value;
    }

    @Override
    public char invokeNativeChar(String name, Object jthis, Class<?>[] types, Object[] args) throws Throwable {
        String msgPrefix;
        JsValue result = this.invokeNative(name, jthis, types, args);
        Character value = JsValueGlue.get(result, null, Character.TYPE, msgPrefix = this.composeResultErrorMsgPrefix(name, "a char"));
        if (value == null) {
            throw new HostedModeException(msgPrefix + ": return value null received, expected a char");
        }
        return value.charValue();
    }

    @Override
    public double invokeNativeDouble(String name, Object jthis, Class<?>[] types, Object[] args) throws Throwable {
        String msgPrefix;
        JsValue result = this.invokeNative(name, jthis, types, args);
        Double value = JsValueGlue.get(result, null, Double.TYPE, msgPrefix = this.composeResultErrorMsgPrefix(name, "a double"));
        if (value == null) {
            throw new HostedModeException(msgPrefix + ": return value null received, expected a double");
        }
        return value;
    }

    @Override
    public float invokeNativeFloat(String name, Object jthis, Class<?>[] types, Object[] args) throws Throwable {
        String msgPrefix;
        JsValue result = this.invokeNative(name, jthis, types, args);
        Float value = JsValueGlue.get(result, null, Float.TYPE, msgPrefix = this.composeResultErrorMsgPrefix(name, "a float"));
        if (value == null) {
            throw new HostedModeException(msgPrefix + ": return value null received, expected a float");
        }
        return value.floatValue();
    }

    @Override
    public int invokeNativeInt(String name, Object jthis, Class<?>[] types, Object[] args) throws Throwable {
        String msgPrefix;
        JsValue result = this.invokeNative(name, jthis, types, args);
        Integer value = JsValueGlue.get(result, null, Integer.TYPE, msgPrefix = this.composeResultErrorMsgPrefix(name, "an int"));
        if (value == null) {
            throw new HostedModeException(msgPrefix + ": return value null received, expected an int");
        }
        return value;
    }

    @Override
    public long invokeNativeLong(String name, Object jthis, Class<?>[] types, Object[] args) throws Throwable {
        String msgPrefix;
        JsValue result = this.invokeNative(name, jthis, types, args);
        Long value = JsValueGlue.get(result, null, Long.TYPE, msgPrefix = this.composeResultErrorMsgPrefix(name, "a long"));
        if (value == null) {
            throw new HostedModeException(msgPrefix + ": return value null received, expected a long");
        }
        return value;
    }

    @Override
    public Object invokeNativeObject(String name, Object jthis, Class<?>[] types, Object[] args) throws Throwable {
        JsValue result = this.invokeNative(name, jthis, types, args);
        String msgPrefix = this.composeResultErrorMsgPrefix(name, "a Java object");
        return JsValueGlue.get(result, this.getIsolatedClassLoader(), Object.class, msgPrefix);
    }

    @Override
    public short invokeNativeShort(String name, Object jthis, Class<?>[] types, Object[] args) throws Throwable {
        String msgPrefix;
        JsValue result = this.invokeNative(name, jthis, types, args);
        Short value = JsValueGlue.get(result, null, Short.TYPE, msgPrefix = this.composeResultErrorMsgPrefix(name, "a short"));
        if (value == null) {
            throw new HostedModeException(msgPrefix + ": return value null received, expected a short");
        }
        return value;
    }

    @Override
    public void invokeNativeVoid(String name, Object jthis, Class<?>[] types, Object[] args) throws Throwable {
        JsValue result = this.invokeNative(name, jthis, types, args);
        if (!result.isUndefined()) {
            this.logger.log(TreeLogger.WARN, "JSNI method '" + name + "' returned a value of type " + result.getTypeString() + " but was declared void; it should not have returned a value at all", null);
        }
    }

    @Override
    public void log(String message, Throwable e) {
        TreeLogger t;
        TreeLogger.Type type = TreeLogger.INFO;
        if (e != null) {
            type = TreeLogger.ERROR;
        }
        if ((t = ModuleSpace.getLogger()) != null) {
            ModuleSpace.getLogger().log(type, message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onLoad(TreeLogger logger) throws UnableToCompleteException {
        block25: {
            SpeedTracerLogger.Event moduleSpaceLoadEvent = SpeedTracerLogger.start(DevModeEventType.MODULE_SPACE_LOAD, new String[0]);
            this.host.onModuleReady(this);
            try {
                this.createStaticDispatcher(logger);
                Object staticDispatch = this.getStaticDispatcher();
                this.invokeNativeVoid("__defineStatic", null, new Class[]{Object.class}, new Object[]{staticDispatch});
            }
            catch (Throwable e) {
                logger.log(TreeLogger.ERROR, "Unable to initialize static dispatcher", e);
                throw new UnableToCompleteException();
            }
            String entryPointTypeName = null;
            try {
                Class<?> implClass = this.loadClassFromSourceName("com.google.gwt.core.client.impl.Impl");
                Method registerEntry = implClass.getDeclaredMethod("registerEntry", new Class[0]);
                registerEntry.setAccessible(true);
                registerEntry.invoke(null, new Object[0]);
                Method enter = implClass.getDeclaredMethod("enter", new Class[0]);
                enter.setAccessible(true);
                enter.invoke(null, new Object[0]);
                String[] entryPoints = this.host.getEntryPointTypeNames();
                if (entryPoints.length > 0) {
                    try {
                        for (int i = 0; i < entryPoints.length; ++i) {
                            Object module;
                            entryPointTypeName = entryPoints[i];
                            Method onModuleLoad = null;
                            try {
                                Class<?> clazz = this.loadClassFromSourceName(entryPointTypeName);
                                try {
                                    onModuleLoad = clazz.getMethod("onModuleLoad", new Class[0]);
                                    if (!Modifier.isStatic(onModuleLoad.getModifiers())) {
                                        onModuleLoad = null;
                                    }
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    // empty catch block
                                }
                                module = null;
                                if (onModuleLoad == null) {
                                    module = this.rebindAndCreate(entryPointTypeName);
                                    onModuleLoad = module.getClass().getMethod("onModuleLoad", new Class[0]);
                                    entryPointTypeName = module.getClass().getName().replace('$', '.');
                                }
                            }
                            catch (Throwable e) {
                                this.displayErrorGlassPanel("EntryPoint initialization exception", entryPointTypeName, e);
                                throw e;
                            }
                            try {
                                onModuleLoad.setAccessible(true);
                                this.invokeNativeVoid("fireOnModuleLoadStart", null, new Class[]{String.class}, new Object[]{entryPointTypeName});
                                SpeedTracerLogger.Event onModuleLoadEvent = SpeedTracerLogger.start(DevModeEventType.ON_MODULE_LOAD, new String[0]);
                                try {
                                    onModuleLoad.invoke(module, new Object[0]);
                                    continue;
                                }
                                finally {
                                    onModuleLoadEvent.end(new String[0]);
                                }
                            }
                            catch (Throwable e) {
                                this.displayErrorGlassPanel("onModuleLoad() threw an exception", entryPointTypeName, e);
                                throw e;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Method exit = implClass.getDeclaredMethod("exit", Boolean.TYPE);
                        exit.setAccessible(true);
                        exit.invoke(null, true);
                        throw throwable;
                    }
                    Method exit = implClass.getDeclaredMethod("exit", Boolean.TYPE);
                    exit.setAccessible(true);
                    exit.invoke(null, true);
                    break block25;
                }
                logger.log(TreeLogger.WARN, "The module has no entry points defined, so onModuleLoad() will never be called", null);
            }
            catch (Throwable e) {
                Throwable caught = e;
                if (e instanceof InvocationTargetException) {
                    caught = ((InvocationTargetException)e).getTargetException();
                }
                if (caught instanceof ExceptionInInitializerError) {
                    caught = ((ExceptionInInitializerError)caught).getException();
                }
                String unableToLoadMessage = "Unable to load module entry point class " + entryPointTypeName;
                if (caught != null) {
                    unableToLoadMessage = unableToLoadMessage + " (see associated exception for details)";
                }
                logger.log(TreeLogger.ERROR, unableToLoadMessage, caught);
                throw new UnableToCompleteException();
            }
            finally {
                moduleSpaceLoadEvent.end(new String[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T rebindAndCreate(String requestedClassName) throws UnableToCompleteException {
        String msg;
        Throwable caught;
        block18: {
            assert (Name.isBinaryName(requestedClassName));
            caught = null;
            msg = null;
            String resultName = null;
            Class<?> resolvedClass = null;
            SpeedTracerLogger.Event moduleSpaceRebindAndCreate = SpeedTracerLogger.start(DevModeEventType.MODULE_SPACE_REBIND_AND_CREATE, new String[0]);
            try {
                String sourceName = Name.BinaryName.toSourceName(requestedClassName);
                resultName = this.rebind(sourceName);
                moduleSpaceRebindAndCreate.addData("Requested Class", requestedClassName, "Result Name", resultName);
                resolvedClass = this.loadClassFromSourceName(resultName);
                if (Modifier.isAbstract(resolvedClass.getModifiers())) {
                    msg = "Deferred binding result type '" + resultName + "' should not be abstract";
                    break block18;
                }
                Constructor<?> ctor = resolvedClass.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                Object obj = ctor.newInstance(new Object[0]);
                return (T)obj;
            }
            catch (ClassNotFoundException e) {
                msg = "Could not load deferred binding result type '" + resultName + "'";
                caught = e;
            }
            catch (InstantiationException e) {
                caught = e;
            }
            catch (IllegalAccessException e) {
                caught = e;
            }
            catch (ExceptionInInitializerError e) {
                caught = e.getException();
            }
            catch (NoSuchMethodException e) {
                msg = resolvedClass.getEnclosingClass() != null && !Modifier.isStatic(resolvedClass.getModifiers()) ? "Rebind result '" + resultName + " is a non-static inner class" : "Rebind result '" + resultName + "' has no default (zero argument) constructors.";
                caught = e;
            }
            catch (InvocationTargetException e) {
                caught = e.getTargetException();
            }
            finally {
                moduleSpaceRebindAndCreate.end(new String[0]);
            }
        }
        if (msg == null) {
            msg = "Failed to create an instance of '" + requestedClassName + "' via deferred binding ";
        }
        this.host.getLogger().log(TreeLogger.ERROR, msg, caught);
        throw new UnableToCompleteException();
    }

    protected abstract void createStaticDispatcher(TreeLogger var1);

    protected abstract JsValue doInvoke(String var1, Object var2, Class<?>[] var3, Object[] var4) throws Throwable;

    protected CompilingClassLoader getIsolatedClassLoader() {
        return this.host.getClassLoader();
    }

    protected abstract Object getStaticDispatcher();

    protected final JsValue invokeNative(String name, Object jthis, Class<?>[] types, Object[] args) throws Throwable {
        JsValue result = this.doInvoke(name, jthis, types, args);
        Throwable thrown = sCaughtJavaExceptionObject.get();
        if (thrown == null) {
            return result;
        }
        sCaughtJavaExceptionObject.set(null);
        this.scrubStackTrace(thrown);
        throw thrown;
    }

    protected boolean isExceptionSame(Throwable original, Object exception) {
        return exception == null;
    }

    protected String rebind(String sourceName) throws UnableToCompleteException {
        try {
            String result = this.host.rebind(this.logger, sourceName);
            if (result != null) {
                return result;
            }
            return sourceName;
        }
        catch (UnableToCompleteException e) {
            String msg = "Deferred binding failed for '" + sourceName + "'; expect subsequent failures";
            this.host.getLogger().log(TreeLogger.ERROR, msg);
            throw e;
        }
    }

    private String composeResultErrorMsgPrefix(String name, String typePhrase) {
        return "Something other than " + typePhrase + " was returned from JSNI method '" + name + "'";
    }

    private void displayErrorGlassPanel(String summary, String entryPointTypeName, Throwable e) throws Throwable {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String stackTrace = Util.escapeXml(writer.toString()).replaceFirst("(?ms)(Caused by:.+)", "<b>$1</b>");
        String details = "<p>Exception while loading module <b>" + Util.escapeXml(entryPointTypeName) + "</b>. See Development Mode for details.</p><div style='overflow:visible;white-space:pre;'>" + stackTrace + "</div>";
        this.invokeNativeVoid("__gwt_displayGlassMessage", null, new Class[]{String.class, String.class}, new Object[]{Util.escapeXml(summary), details});
    }

    private boolean isUserFrame(StackTraceElement element) {
        try {
            CompilingClassLoader cl = this.getIsolatedClassLoader();
            String className = element.getClassName();
            Class<?> clazz = Class.forName(className, false, cl);
            if (clazz.getClassLoader() == cl) {
                return true;
            }
            if (clazz.getClassLoader() != null || !className.startsWith("java.")) {
                return false;
            }
            return !className.startsWith("java.lang.reflect.");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private Class<?> loadClassFromSourceName(String sourceName) throws ClassNotFoundException {
        SpeedTracerLogger.Event moduleSpaceClassLoad = SpeedTracerLogger.start(DevModeEventType.MODULE_SPACE_CLASS_LOAD, "Source Name", sourceName);
        try {
            String toTry = sourceName;
            while (true) {
                try {
                    Class<?> clazz = Class.forName(toTry, true, this.getIsolatedClassLoader());
                    return clazz;
                }
                catch (ClassNotFoundException e) {
                    int i = toTry.lastIndexOf(46);
                    if (i == -1) {
                        throw e;
                    }
                    toTry = toTry.substring(0, i) + "$" + toTry.substring(i + 1);
                    continue;
                }
                break;
            }
        }
        finally {
            moduleSpaceClassLoad.end(new String[0]);
        }
    }

    private void scrubStackTrace(Throwable thrown) {
        ArrayList<StackTraceElement> trace = new ArrayList<StackTraceElement>(Arrays.asList(thrown.getStackTrace()));
        boolean seenUserFrame = false;
        ListIterator<StackTraceElement> it = trace.listIterator();
        while (it.hasNext()) {
            StackTraceElement next;
            StackTraceElement element = (StackTraceElement)it.next();
            if (!this.isUserFrame(element)) {
                if (!seenUserFrame) continue;
                it.remove();
                continue;
            }
            seenUserFrame = true;
            if (!element.getClassName().equals(JavaScriptHost.class.getName())) continue;
            if (element.getMethodName().equals("exceptionCaught")) {
                it.remove();
                continue;
            }
            if (!element.getMethodName().startsWith("invokeNative")) continue;
            it.remove();
            if (!it.hasNext() || (next = (StackTraceElement)it.next()).getLineNumber() != -1) continue;
            next = new StackTraceElement(next.getClassName(), next.getMethodName(), next.getFileName(), -2);
            it.set(next);
        }
        thrown.setStackTrace(trace.toArray(new StackTraceElement[trace.size()]));
    }
}

