/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.dev.shell.CompilingClassLoader;
import com.google.gwt.dev.shell.JsValue;
import com.google.gwt.dev.shell.JsValueGlue;
import com.google.gwt.dev.shell.MethodAdaptor;
import com.google.gwt.dev.shell.ModuleSpace;
import java.lang.reflect.InvocationTargetException;

class MethodDispatch
implements JsValue.DispatchMethod {
    private final CompilingClassLoader classLoader;
    private final MethodAdaptor method;

    public MethodDispatch(CompilingClassLoader classLoader, MethodAdaptor method) {
        this.classLoader = classLoader;
        this.method = method;
    }

    @Override
    public boolean invoke(JsValue jsthis, JsValue[] jsargs, JsValue returnValue) {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        int argc = paramTypes.length;
        Object[] args = new Object[argc];
        if (jsargs.length < argc) {
            throw new RuntimeException("Not enough arguments to " + this.method);
        }
        Object jthis = null;
        if (this.method.needsThis() && (jthis = JsValueGlue.get(jsthis, this.classLoader, this.method.getDeclaringClass(), "invoke this")) == null) {
            throw ModuleSpace.createJavaScriptException(this.classLoader, "Invoking an instance method on a null instance");
        }
        for (int i = 0; i < argc; ++i) {
            args[i] = JsValueGlue.get(jsargs[i], this.classLoader, paramTypes[i], "invoke arguments");
        }
        try {
            Object result;
            try {
                result = this.method.invoke(jthis, args);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            JsValueGlue.set(returnValue, this.classLoader, this.method.getReturnType(), result);
            return false;
        }
        catch (InstantiationException e) {
            this.wrapException(returnValue, e.getCause());
            return true;
        }
        catch (InvocationTargetException e) {
            this.wrapException(returnValue, e.getTargetException());
            return true;
        }
        catch (IllegalArgumentException e) {
            System.err.println("MethodDispatch.invoke, method=" + this.method.toString() + ": argument mismatch");
            for (int i = 0; i < argc; ++i) {
                System.err.println(" param " + i + " type is " + paramTypes[i].toString() + " value is type " + jsargs[i].getTypeString() + " = " + args[i].toString());
            }
            throw e;
        }
    }

    public String toString() {
        return this.method.toString();
    }

    private void wrapException(JsValue returnValue, Throwable t) {
        ModuleSpace.setThrownJavaException(t);
        Object thrown = ModuleSpace.getThrownObject(this.classLoader, t);
        Class type = thrown == null ? Object.class : thrown.getClass();
        JsValueGlue.set(returnValue, this.classLoader, type, thrown);
    }
}

