/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MethodAdaptor {
    private final Constructor<?> constructor;
    private final Class<?> declaringClass;
    private final int hashCode;
    private final Method method;
    private final String name;
    private final boolean needsThis;
    private final Class<?>[] paramTypes;
    private final Class<?> returnType;

    public MethodAdaptor(Constructor<?> c) {
        this.constructor = c;
        this.method = null;
        this.name = c.getName();
        this.needsThis = false;
        this.paramTypes = c.getParameterTypes();
        this.declaringClass = c.getDeclaringClass();
        this.returnType = this.declaringClass;
        this.hashCode = c.hashCode();
    }

    public MethodAdaptor(Method m) {
        this.constructor = null;
        this.declaringClass = m.getDeclaringClass();
        this.method = m;
        this.name = m.getName();
        this.needsThis = !Modifier.isStatic(m.getModifiers());
        this.paramTypes = m.getParameterTypes();
        this.returnType = m.getReturnType();
        this.hashCode = this.method.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodAdaptor)) {
            return false;
        }
        MethodAdaptor other = (MethodAdaptor)o;
        if (this.constructor != null) {
            return this.constructor.equals(other.constructor);
        }
        if (this.method != null) {
            return this.method.equals(other.method);
        }
        throw new RuntimeException("constructor and method are null");
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.name;
    }

    public Class<?>[] getParameterTypes() {
        return this.paramTypes;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public AccessibleObject getUnderlyingObject() {
        return this.method != null ? this.method : this.constructor;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Object invoke(Object obj, Object ... args) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        if (this.method != null) {
            return this.method.invoke(obj, args);
        }
        if (this.constructor != null) {
            return this.constructor.newInstance(args);
        }
        throw new RuntimeException("Nothing to invoke");
    }

    public boolean needsThis() {
        return this.needsThis;
    }

    public final String toString() {
        return this.method != null ? this.method.toString() : this.constructor.toString();
    }
}

