/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.dev.javac.JsniMethod;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.js.JsSourceGenerationVisitor;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNode;
import com.google.gwt.dev.js.ast.JsNullLiteral;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.shell.DispatchIdOracle;
import com.google.gwt.dev.shell.HostedModeException;
import com.google.gwt.dev.shell.SyntheticClassMember;
import com.google.gwt.dev.util.DefaultTextOutput;
import com.google.gwt.dev.util.TextOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;

public class Jsni {
    public static String getJavaScriptForHostedMode(DispatchIdOracle dispatchInfo, JsniMethod jsniMethod) {
        JsFunction func = jsniMethod.function();
        if (func == null) {
            return null;
        }
        return Jsni.generateJavaScriptForHostedMode(dispatchInfo, func.getBody());
    }

    private static String generateJavaScriptForHostedMode(DispatchIdOracle dispatchInfo, JsNode node) {
        DefaultTextOutput out = new DefaultTextOutput(false);
        JsSourceGenWithJsniIdentFixup vi = new JsSourceGenWithJsniIdentFixup((TextOutput)out, dispatchInfo);
        vi.accept(node);
        return out.toString();
    }

    private static class JsSourceGenWithJsniIdentFixup
    extends JsSourceGenerationVisitor {
        private final DispatchIdOracle dispatchInfo;
        private final TextOutput out;

        public JsSourceGenWithJsniIdentFixup(TextOutput out, DispatchIdOracle ccl) {
            super(out);
            this.dispatchInfo = ccl;
            this.out = out;
        }

        @Override
        public boolean visit(JsNameRef x, JsContext ctx) {
            String ident = x.getIdent();
            JsExpression q = x.getQualifier();
            if (ident.startsWith("@")) {
                int dispId = this.dispatchInfo.getDispId(ident);
                Member member = dispId < 0 ? null : this.dispatchInfo.getClassInfoByDispId(dispId).getMember(dispId);
                if (member == null) {
                    throw new HostedModeException("JSNI rewriter found reference to non-existent field in a field reference or java method tear-off: " + ident + " at " + x.getSourceInfo());
                }
                if (member instanceof Field || member instanceof SyntheticClassMember) {
                    if (q != null) {
                        this.accept(q);
                        this.out.print("[");
                        this.out.print(String.valueOf(dispId));
                        this.out.print("]");
                    } else {
                        this.out.print("__static[");
                        this.out.print(String.valueOf(dispId));
                        this.out.print("]");
                    }
                    return false;
                }
                int paramCount = 0;
                if (member instanceof Method) {
                    paramCount = ((Method)member).getParameterTypes().length;
                } else if (member instanceof Constructor) {
                    paramCount = ((Constructor)member).getParameterTypes().length;
                }
                SourceInfo info = x.getSourceInfo();
                JsInvocation rewritten = new JsInvocation(info, (JsExpression)new JsNameRef(info, "__gwt_makeTearOff"), new JsExpression[0]);
                List<JsExpression> arguments = rewritten.getArguments();
                if (q == null) {
                    q = JsNullLiteral.INSTANCE;
                }
                arguments.add(q);
                arguments.add(new JsNumberLiteral(info, dispId));
                arguments.add(new JsNumberLiteral(info, paramCount));
                this.accept(rewritten);
                return false;
            }
            return super.visit(x, ctx);
        }

        @Override
        public boolean visit(JsInvocation x, JsContext ctx) {
            JsNameRef ref;
            String ident;
            if (x.getQualifier() instanceof JsNameRef && (ident = (ref = (JsNameRef)x.getQualifier()).getIdent()).startsWith("@")) {
                int dispId = this.dispatchInfo.getDispId(ident);
                Member member = dispId < 0 ? null : this.dispatchInfo.getClassInfoByDispId(dispId).getMember(dispId);
                if (member == null) {
                    throw new HostedModeException("JSNI rewriter found reference to non-existent field in a method invocation: " + ref.getIdent() + " at " + ref.getSourceInfo());
                }
                if (member instanceof Method || member instanceof Constructor) {
                    int paramCount = 0;
                    if (member instanceof Method) {
                        paramCount = ((Method)member).getParameterTypes().length;
                    } else if (member instanceof Constructor) {
                        paramCount = ((Constructor)member).getParameterTypes().length;
                    }
                    SourceInfo info = x.getSourceInfo();
                    JsInvocation inner = new JsInvocation(info, (JsExpression)new JsNameRef(info, "__gwt_makeJavaInvoke"), new JsNumberLiteral(info, paramCount));
                    JsInvocation outer = new JsInvocation(info);
                    outer.setQualifier(inner);
                    JsExpression q = ref.getQualifier();
                    if (q == null) {
                        q = JsNullLiteral.INSTANCE;
                    }
                    List<JsExpression> arguments = outer.getArguments();
                    arguments.add(q);
                    arguments.add(new JsNumberLiteral(info, dispId));
                    arguments.addAll(x.getArguments());
                    this.accept(outer);
                    return false;
                }
            }
            return super.visit(x, ctx);
        }
    }
}

