/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.dev.shell.BrowserChannel;
import com.google.gwt.dev.shell.CompilingClassLoader;
import com.google.gwt.dev.shell.JavaDispatchImpl;
import com.google.gwt.dev.shell.JsValue;
import com.google.gwt.dev.shell.JsValueGlue;
import com.google.gwt.dev.shell.MethodAdaptor;
import com.google.gwt.dev.shell.MethodDispatch;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Map;

public class JsValueOOPHM
extends JsValue {
    private static final ThreadLocal<Map<Object, JsValue.DispatchObject>> dispatchObjectCache = new ThreadLocal();
    private static final UndefinedValue undefValue = new UndefinedValue();
    private Object value = undefValue;

    @Override
    public boolean getBoolean() {
        return (Boolean)this.value;
    }

    @Override
    public int getInt() {
        return (Integer)this.value;
    }

    @Override
    public JsValue.DispatchObject getJavaObjectWrapper() {
        return (JsValue.DispatchObject)this.value;
    }

    public BrowserChannel.JsObjectRef getJavascriptObject() {
        return (BrowserChannel.JsObjectRef)this.value;
    }

    @Override
    public int getJavaScriptObjectPointer() {
        assert (this.isJavaScriptObject());
        return ((BrowserChannel.JsObjectRef)this.value).getRefid();
    }

    @Override
    public double getNumber() {
        return ((Number)this.value).doubleValue();
    }

    @Override
    public String getString() {
        return (String)this.value;
    }

    @Override
    public String getTypeString() {
        if (this.isBoolean()) {
            return "boolean";
        }
        if (this.isInt()) {
            return "int";
        }
        if (this.isJavaScriptObject()) {
            BrowserChannel.JsObjectRef objRef = (BrowserChannel.JsObjectRef)this.value;
            return "JavaScript object(" + objRef.getRefid() + ")";
        }
        if (this.isNull()) {
            return "null";
        }
        if (this.isNumber()) {
            return "number";
        }
        if (this.isString()) {
            return "string";
        }
        if (this.isUndefined()) {
            return "undefined";
        }
        if (this.isWrappedJavaFunction()) {
            return "Java Method";
        }
        if (this.isWrappedJavaObject()) {
            return "Java Object " + this.value.getClass().getName();
        }
        return "unexpected value type";
    }

    @Override
    public JsValue.DispatchMethod getWrappedJavaFunction() {
        return (JsValue.DispatchMethod)this.value;
    }

    @Override
    public Object getWrappedJavaObject() {
        return ((JsValue.DispatchObject)this.value).getTarget();
    }

    @Override
    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    @Override
    public boolean isInt() {
        return this.value instanceof Integer;
    }

    @Override
    public boolean isJavaScriptObject() {
        return this.value instanceof BrowserChannel.JsObjectRef;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isNumber() {
        return this.value instanceof Number;
    }

    @Override
    public boolean isString() {
        return this.value instanceof String;
    }

    @Override
    public boolean isUndefined() {
        return this.value == undefValue;
    }

    @Override
    public boolean isWrappedJavaFunction() {
        return this.value instanceof JsValue.DispatchMethod;
    }

    @Override
    public boolean isWrappedJavaObject() {
        return this.value instanceof JsValue.DispatchObject;
    }

    @Override
    public void setBoolean(boolean val) {
        this.value = val;
    }

    @Override
    public void setByte(byte val) {
        this.value = (int)val;
    }

    @Override
    public void setChar(char val) {
        this.value = (int)val;
    }

    @Override
    public void setDouble(double val) {
        this.value = val;
    }

    @Override
    public void setInt(int val) {
        this.value = val;
    }

    public void setJavascriptObject(BrowserChannel.JsObjectRef jsObject) {
        this.value = jsObject;
    }

    @Override
    public void setNull() {
        this.value = null;
    }

    @Override
    public void setShort(short val) {
        this.value = (int)val;
    }

    @Override
    public void setString(String val) {
        this.value = val;
    }

    @Override
    public void setUndefined() {
        this.value = undefValue;
    }

    @Override
    public void setValue(JsValue other) {
        this.value = ((JsValueOOPHM)other).value;
    }

    public void setWrappedFunction(String methodName, JsValue.DispatchMethod dispatchMethod) {
        this.value = dispatchMethod;
    }

    @Override
    public <T> void setWrappedJavaObject(CompilingClassLoader cl, T val) {
        if (val == null) {
            this.setNull();
            return;
        }
        if (val instanceof JsValue.DispatchObject) {
            this.value = val;
        } else {
            JsValue.DispatchObject dispObj;
            Map<Object, JsValue.DispatchObject> cache = dispatchObjectCache.get();
            if (cache == null) {
                cache = new IdentityHashMap<Object, JsValue.DispatchObject>();
                dispatchObjectCache.set(cache);
            }
            if ((dispObj = cache.get(val)) == null) {
                dispObj = new DispatchObjectOOPHM(cl, val);
                cache.put(val, dispObj);
            }
            this.value = dispObj;
        }
    }

    private static class UndefinedValue {
        private UndefinedValue() {
        }
    }

    static class DispatchObjectOOPHM
    implements JsValue.DispatchObject {
        private final CompilingClassLoader classLoader;
        private final JavaDispatchImpl javaDispatch;

        public DispatchObjectOOPHM(CompilingClassLoader ccl) {
            this.javaDispatch = new JavaDispatchImpl(ccl);
            this.classLoader = ccl;
        }

        public DispatchObjectOOPHM(CompilingClassLoader ccl, Object val) {
            this.javaDispatch = new JavaDispatchImpl(ccl, val);
            this.classLoader = ccl;
        }

        @Override
        public JsValue getField(int dispId) {
            JsValueOOPHM jsValue = new JsValueOOPHM();
            if (this.javaDispatch.isField(dispId)) {
                Field field = this.javaDispatch.getField(dispId);
                JsValueGlue.set(jsValue, this.classLoader, field.getType(), this.javaDispatch.getFieldValue(dispId));
            } else {
                MethodAdaptor method = this.javaDispatch.getMethod(dispId);
                AccessibleObject obj = method.getUnderlyingObject();
                JsValue.DispatchMethod dispMethod = (JsValue.DispatchMethod)this.classLoader.getWrapperForObject(obj);
                if (dispMethod == null) {
                    dispMethod = new MethodDispatch(this.classLoader, method);
                    this.classLoader.putWrapperForObject(obj, dispMethod);
                }
                jsValue.setWrappedFunction(method.toString(), dispMethod);
            }
            return jsValue;
        }

        @Override
        public JsValue getField(String name) {
            int dispId = this.getFieldId(name);
            if (dispId < 0) {
                return new JsValueOOPHM();
            }
            return this.getField(dispId);
        }

        @Override
        public int getFieldId(String name) {
            return this.classLoader.getDispId(name);
        }

        @Override
        public Object getTarget() {
            return this.javaDispatch.getTarget();
        }

        @Override
        public void setField(int dispId, JsValue jsValue) {
            if (this.javaDispatch.isMethod(dispId)) {
                throw new RuntimeException("Cannot reassign method " + this.javaDispatch.getMethod(dispId).getName());
            }
            Field field = this.javaDispatch.getField(dispId);
            Object val = JsValueGlue.get(jsValue, this.classLoader, field.getType(), "setField");
            this.javaDispatch.setFieldValue(dispId, val);
        }

        @Override
        public void setField(String name, JsValue jsValue) {
            int dispId = this.getFieldId(name);
            if (dispId < 0) {
                throw new RuntimeException("No such field " + name);
            }
            this.setField(dispId, jsValue);
        }
    }
}

