/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.shell.CompilingClassLoader;
import com.google.gwt.dev.shell.HostedModeException;
import com.google.gwt.dev.shell.JavaLong;
import com.google.gwt.dev.shell.JsValue;
import com.google.gwt.dev.shell.ModuleSpace;
import com.google.gwt.dev.util.TypeInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public final class JsValueGlue {
    public static final String HOSTED_MODE_REFERENCE = "hostedModeReference";
    public static final String JSO_CLASS = "com.google.gwt.core.client.JavaScriptObject";
    public static final String JSO_IMPL_CLASS = "com.google.gwt.core.client.JavaScriptObject$";

    public static Object createJavaScriptObject(JsValue value, CompilingClassLoader classLoader) {
        Exception caught;
        try {
            Object jso = classLoader.getCachedJso(value.getJavaScriptObjectPointer());
            if (jso != null) {
                return jso;
            }
            Class<?> jsoType = Class.forName(JSO_IMPL_CLASS, true, classLoader);
            Constructor<?> ctor = jsoType.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            jso = ctor.newInstance(new Object[0]);
            Field referenceField = jsoType.getField(HOSTED_MODE_REFERENCE);
            referenceField.set(jso, value);
            classLoader.putCachedJso(value.getJavaScriptObjectPointer(), jso);
            return jso;
        }
        catch (InstantiationException e) {
            caught = e;
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        catch (SecurityException e) {
            caught = e;
        }
        catch (NoSuchMethodException e) {
            caught = e;
        }
        catch (IllegalArgumentException e) {
            caught = e;
        }
        catch (InvocationTargetException e) {
            caught = e;
        }
        catch (ClassNotFoundException e) {
            caught = e;
        }
        catch (NoSuchFieldException e) {
            caught = e;
        }
        throw new RuntimeException("Error creating JavaScript object", caught);
    }

    public static <T> T get(JsValue value, CompilingClassLoader cl, Class<T> type, String msgPrefix) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                if (!value.isBoolean()) {
                    throw new HostedModeException(msgPrefix + ": JS value of type " + value.getTypeString() + ", expected boolean");
                }
                return (T)Boolean.valueOf(value.getBoolean());
            }
            if (type == Byte.TYPE) {
                return (T)Byte.valueOf((byte)JsValueGlue.getIntRange(value, -128, 127, "byte", msgPrefix));
            }
            if (type == Character.TYPE) {
                return (T)Character.valueOf((char)JsValueGlue.getIntRange(value, 0, 65535, "char", msgPrefix));
            }
            if (type == Double.TYPE) {
                if (!value.isNumber()) {
                    throw new HostedModeException(msgPrefix + ": JS value of type " + value.getTypeString() + ", expected double");
                }
                return (T)Double.valueOf(value.getNumber());
            }
            if (type == Float.TYPE) {
                float floatVal;
                if (!value.isNumber()) {
                    throw new HostedModeException(msgPrefix + ": JS value of type " + value.getTypeString() + ", expected float");
                }
                double doubleVal = value.getNumber();
                if ((float)(doubleVal - (double)1.4E-45f) == 0.0f) {
                    doubleVal = 1.4E-45f;
                }
                if (Float.isInfinite(floatVal = (float)doubleVal) && !Double.isInfinite(doubleVal)) {
                    throw new HostedModeException(msgPrefix + ": JS value " + doubleVal + " out of range for a float");
                }
                return (T)Float.valueOf(floatVal);
            }
            if (type == Integer.TYPE) {
                return (T)Integer.valueOf(JsValueGlue.getIntRange(value, Integer.MIN_VALUE, Integer.MAX_VALUE, "int", msgPrefix));
            }
            if (type == Long.TYPE) {
                if (!value.isWrappedJavaObject()) {
                    throw new HostedModeException(msgPrefix + ": JS value of type " + value.getTypeString() + ", expected Java long");
                }
                JavaLong javaLong = (JavaLong)value.getWrappedJavaObject();
                return (T)Long.valueOf(javaLong.longValue());
            }
            if (type == Short.TYPE) {
                return (T)Short.valueOf((short)JsValueGlue.getIntRange(value, Short.MIN_VALUE, Short.MAX_VALUE, "short", msgPrefix));
            }
        }
        if (value.isNull() || value.isUndefined()) {
            return null;
        }
        if (value.isWrappedJavaObject()) {
            return type.cast(value.getWrappedJavaObject());
        }
        if (value.isString()) {
            return type.cast(value.getString());
        }
        if (value.isJavaScriptObject()) {
            return type.cast(JsValueGlue.createJavaScriptObject(value, cl));
        }
        throw new IllegalArgumentException(msgPrefix + ": JS value of type " + value.getTypeString() + ", expected " + TypeInfo.getSourceRepresentation(type));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void set(JsValue value, CompilingClassLoader cl, Class<?> type, Object obj) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                value.setBoolean((Boolean)obj);
                return;
            } else if (type == Byte.TYPE) {
                value.setInt(((Byte)obj).byteValue());
                return;
            } else if (type == Character.TYPE) {
                value.setInt(((Character)obj).charValue());
                return;
            } else if (type == Double.TYPE) {
                value.setDouble((Double)obj);
                return;
            } else if (type == Float.TYPE) {
                value.setDouble(((Float)obj).floatValue());
                return;
            } else if (type == Integer.TYPE) {
                value.setInt((Integer)obj);
                return;
            } else if (type == Long.TYPE) {
                long longVal = (Long)obj;
                value.setWrappedJavaObject(cl, new JavaLong(longVal));
                return;
            } else if (type == Short.TYPE) {
                value.setInt(((Short)obj).shortValue());
                return;
            } else {
                if (type != Void.TYPE) throw new HostedModeException("Cannot marshal primitive type " + type);
                value.setUndefined();
            }
            return;
        }
        if (obj == null) {
            value.setNull();
            return;
        }
        try {
            Class<?> jsoType = Class.forName(JSO_IMPL_CLASS, false, cl);
            if (jsoType == obj.getClass()) {
                JsValue jsObject = JsValueGlue.getUnderlyingObject(obj);
                value.setValue(jsObject);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!type.isInstance(obj)) {
            throw new HostedModeException("object is of type " + obj.getClass().getName() + ", expected " + type.getName());
        }
        if (obj instanceof String) {
            value.setString((String)obj);
            return;
        } else {
            value.setWrappedJavaObject(cl, obj);
        }
    }

    private static int getIntRange(JsValue value, int low, int high, String typeName, String msgPrefix) {
        int intVal;
        if (value.isInt()) {
            intVal = value.getInt();
            if (intVal < low || intVal > high) {
                throw new HostedModeException(msgPrefix + ": JS int value " + intVal + " out of range for a " + typeName);
            }
        } else if (value.isNumber()) {
            double doubleVal = value.getNumber();
            if (doubleVal < (double)low || doubleVal > (double)high) {
                throw new HostedModeException(msgPrefix + ": JS double value " + doubleVal + " out of range for a " + typeName);
            }
            intVal = (int)doubleVal;
            if ((double)intVal != doubleVal) {
                ModuleSpace.getLogger().log(TreeLogger.WARN, msgPrefix + ": Rounding double (" + doubleVal + ") to int for " + typeName, null);
            }
        } else {
            throw new HostedModeException(msgPrefix + ": JS value of type " + value.getTypeString() + ", expected " + typeName);
        }
        return intVal;
    }

    private static JsValue getUnderlyingObject(Object jso) {
        Exception caught;
        try {
            Field referenceField = jso.getClass().getField(HOSTED_MODE_REFERENCE);
            referenceField.setAccessible(true);
            return (JsValue)referenceField.get(jso);
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        catch (SecurityException e) {
            caught = e;
        }
        catch (NoSuchFieldException e) {
            caught = e;
        }
        throw new RuntimeException("Error reading hostedModeReference", caught);
    }

    private JsValueGlue() {
    }
}

