/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.dev.shell.CompilingClassLoader;

public abstract class JsValue {
    public abstract boolean getBoolean();

    public abstract int getInt();

    public abstract DispatchObject getJavaObjectWrapper();

    public abstract int getJavaScriptObjectPointer();

    public abstract double getNumber();

    public abstract String getString();

    public abstract String getTypeString();

    public abstract DispatchMethod getWrappedJavaFunction();

    public abstract Object getWrappedJavaObject();

    public abstract boolean isBoolean();

    public abstract boolean isInt();

    public abstract boolean isJavaScriptObject();

    public abstract boolean isNull();

    public abstract boolean isNumber();

    public abstract boolean isString();

    public abstract boolean isUndefined();

    public abstract boolean isWrappedJavaFunction();

    public abstract boolean isWrappedJavaObject();

    public abstract void setBoolean(boolean var1);

    public abstract void setByte(byte var1);

    public abstract void setChar(char var1);

    public abstract void setDouble(double var1);

    public abstract void setInt(int var1);

    public abstract void setNull();

    public abstract void setShort(short var1);

    public abstract void setString(String var1);

    public abstract void setUndefined();

    public abstract void setValue(JsValue var1);

    public abstract <T> void setWrappedJavaObject(CompilingClassLoader var1, T var2);

    public String toString() {
        if (this.isUndefined()) {
            return "void";
        }
        if (this.isNull()) {
            return "null";
        }
        if (this.isBoolean()) {
            return "bool: " + (this.getBoolean() ? "true" : "false");
        }
        if (this.isInt()) {
            return "int: " + Integer.toString(this.getInt());
        }
        if (this.isNumber()) {
            return "double: " + Double.toString(this.getNumber());
        }
        if (this.isWrappedJavaObject()) {
            Object wrappedObject = this.getWrappedJavaObject();
            if (wrappedObject == null) {
                return "Java static dispatch";
            }
            return "Java object: " + wrappedObject.getClass().getName() + '@' + System.identityHashCode(wrappedObject);
        }
        if (this.isJavaScriptObject()) {
            return this.getTypeString();
        }
        if (this.isString()) {
            return "string: '" + this.getString() + "'";
        }
        if (this.isWrappedJavaFunction()) {
            return "Java method: " + this.getWrappedJavaFunction().toString();
        }
        return this.getTypeString();
    }

    public static interface DispatchObject {
        public JsValue getField(int var1);

        public JsValue getField(String var1);

        public int getFieldId(String var1);

        public Object getTarget();

        public void setField(int var1, JsValue var2);

        public void setField(String var1, JsValue var2);
    }

    public static interface DispatchMethod {
        public boolean invoke(JsValue var1, JsValue[] var2, JsValue var3);
    }
}

