/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.dev.shell.CompilingClassLoader;
import com.google.gwt.dev.shell.DispatchClassInfo;
import com.google.gwt.dev.shell.JavaDispatch;
import com.google.gwt.dev.shell.MethodAdaptor;
import com.google.gwt.dev.shell.SyntheticClassMember;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public class JavaDispatchImpl
implements JavaDispatch {
    private final CompilingClassLoader classLoader;
    private final Object target;

    public JavaDispatchImpl(CompilingClassLoader ccl) {
        this.classLoader = ccl;
        this.target = null;
    }

    public JavaDispatchImpl(CompilingClassLoader ccl, Object target) {
        if (target == null) {
            throw new NullPointerException("target cannot be null");
        }
        this.classLoader = ccl;
        this.target = target;
    }

    @Override
    public Field getField(int dispId) {
        if (dispId < 0) {
            throw new RuntimeException("Field does not exist.");
        }
        Member member = this.getMember(dispId);
        if (member instanceof SyntheticClassMember) {
            try {
                Field f = SyntheticClassMember.class.getDeclaredField("clazz");
                assert (f != null);
                return f;
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            assert (false) : "Should never get here";
        }
        return (Field)member;
    }

    @Override
    public Object getFieldValue(int dispId) {
        if (dispId < 0) {
            throw new RuntimeException("Field does not exist.");
        }
        Member member = this.getMember(dispId);
        if (member instanceof SyntheticClassMember) {
            return member.getDeclaringClass();
        }
        Field field = (Field)member;
        try {
            return field.get(this.target);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public MethodAdaptor getMethod(int dispId) {
        if (dispId < 0) {
            throw new RuntimeException("Method does not exist.");
        }
        Member m = this.getMember(dispId);
        if (m instanceof Method) {
            return new MethodAdaptor((Method)m);
        }
        if (m instanceof Constructor) {
            return new MethodAdaptor((Constructor)m);
        }
        throw new RuntimeException();
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public boolean isField(int dispId) {
        if (dispId < 0) {
            return false;
        }
        Member member = this.getMember(dispId);
        return member instanceof Field || member instanceof SyntheticClassMember;
    }

    @Override
    public boolean isMethod(int dispId) {
        if (dispId < 0) {
            return false;
        }
        Member m = this.getMember(dispId);
        return m instanceof Method || m instanceof Constructor;
    }

    @Override
    public void setFieldValue(int dispId, Object value) {
        Field field = (Field)this.getMember(dispId);
        try {
            field.set(this.target, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected Member getMember(int dispId) {
        DispatchClassInfo clsInfo = this.classLoader.getClassInfoByDispId(dispId);
        return clsInfo.getMember(dispId);
    }
}

