/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.core.client.GWTBridge;
import com.google.gwt.dev.About;
import com.google.gwt.dev.shell.ShellJavaScriptHost;

public class GWTBridgeImpl
extends GWTBridge {
    protected static ThreadLocal<String> uniqueID = new ThreadLocal<String>(){
        private int counter = 0;

        @Override
        public String initialValue() {
            return "DevModeThread" + ++this.counter;
        }
    };
    private final ShellJavaScriptHost host;

    public GWTBridgeImpl(ShellJavaScriptHost host) {
        this.host = host;
    }

    @Override
    public <T> T create(Class<?> requestedClass) {
        String className = requestedClass.getName();
        try {
            return this.host.rebindAndCreate(className);
        }
        catch (Throwable e) {
            String msg = "Deferred binding failed for '" + className + "' (did you forget to inherit a required module?)";
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public String getThreadUniqueID() {
        return uniqueID.get();
    }

    @Override
    public String getVersion() {
        return About.getGwtVersionNum();
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void log(String message, Throwable e) {
        this.host.log(message, e);
    }
}

