/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.dev.util.Util;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

abstract class EmmaStrategy {
    public static final String EMMA_RT_CLASSNAME = "com.vladium.emma.rt.RT";

    EmmaStrategy() {
    }

    public static EmmaStrategy get(boolean emmaIsAvailable) {
        if (!emmaIsAvailable) {
            return new NoEmmaStrategy();
        }
        return new PreinstrumentedEmmaStrategy();
    }

    public abstract byte[] getEmmaClassBytes(byte[] var1, String var2, long var3);

    private static class PreinstrumentedEmmaStrategy
    extends EmmaStrategy {
        private PreinstrumentedEmmaStrategy() {
        }

        @Override
        public byte[] getEmmaClassBytes(byte[] classBytes, String slashedName, long unitLastModified) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(slashedName + ".class");
            if (url != null) {
                try {
                    byte[] result;
                    URLConnection conn = url.openConnection();
                    if (conn.getLastModified() >= unitLastModified && (result = Util.readURLConnectionAsBytes(conn)) != null) {
                        return result;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return classBytes;
        }
    }

    private static class NoEmmaStrategy
    extends EmmaStrategy {
        private NoEmmaStrategy() {
        }

        @Override
        public byte[] getEmmaClassBytes(byte[] classBytes, String slashedName, long unitLastModified) {
            return classBytes;
        }
    }
}

