/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.dev.shell.SyntheticClassMember;
import com.google.gwt.dev.util.StringInterner;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DispatchClassInfo {
    private Class<?> cls;
    private final int clsId;
    private ArrayList<Member> memberById;
    private HashMap<String, Integer> memberIdByName;

    public DispatchClassInfo(Class<?> cls, int classId) {
        this.cls = cls;
        this.clsId = classId;
    }

    public int getClassId() {
        return this.clsId;
    }

    public Member getMember(int id) {
        this.lazyInitTargetMembers();
        return this.memberById.get(id &= 0xFFFF);
    }

    public int getMemberId(String mangledMemberName) {
        this.lazyInitTargetMembers();
        Integer id = this.memberIdByName.get(mangledMemberName);
        if (id == null) {
            return -1;
        }
        return id;
    }

    private void addMember(LinkedHashMap<String, LinkedHashMap<String, Member>> members, Member member, String sig) {
        String fullSig = this.getJsniSignature(member);
        LinkedHashMap<String, Member> membersWithSig = members.get(sig);
        if (membersWithSig == null) {
            membersWithSig = new LinkedHashMap();
            members.put(sig, membersWithSig);
        }
        membersWithSig.put(fullSig, member);
    }

    private void addMemberIfUnique(String name, List<Member> membersForName) {
        if (membersForName.size() == 1) {
            this.memberById.add(membersForName.get(0));
            this.memberIdByName.put(StringInterner.get().intern(name), this.memberById.size() - 1);
        }
    }

    private List<Member> filterOutSyntheticMembers(Collection<Member> members) {
        ArrayList<Member> nonSynth = new ArrayList<Member>();
        for (Member member : members) {
            if (member.isSynthetic()) continue;
            nonSynth.add(member);
        }
        return nonSynth;
    }

    private LinkedHashMap<String, LinkedHashMap<String, Member>> findMostDerivedMembers(Class<?> targetClass, boolean addConstructors) {
        LinkedHashMap<String, LinkedHashMap<String, Member>> members = new LinkedHashMap<String, LinkedHashMap<String, Member>>();
        this.findMostDerivedMembers(members, targetClass, addConstructors);
        return members;
    }

    /*
     * WARNING - void declaration
     */
    private void findMostDerivedMembers(LinkedHashMap<String, LinkedHashMap<String, Member>> members, Class<?> targetClass, boolean addConstructors) {
        void var8_15;
        Field[] fields;
        Class<?> superclass = targetClass.getSuperclass();
        if (superclass != null) {
            this.findMostDerivedMembers(members, superclass, false);
        }
        for (Class<?> clazz : targetClass.getInterfaces()) {
            this.findMostDerivedMembers(members, clazz, false);
        }
        if (addConstructors) {
            for (GenericDeclaration genericDeclaration : targetClass.getDeclaredConstructors()) {
                ((Constructor)genericDeclaration).setAccessible(true);
                this.addMember(members, (Member)((Object)genericDeclaration), this.getJsniSignature((Member)((Object)genericDeclaration)));
            }
        }
        for (GenericDeclaration genericDeclaration : targetClass.getDeclaredMethods()) {
            ((Method)genericDeclaration).setAccessible(true);
            this.addMember(members, (Member)((Object)genericDeclaration), this.getJsniSignature((Member)((Object)genericDeclaration)));
        }
        Field[] fieldArray = fields = targetClass.getDeclaredFields();
        int n = fieldArray.length;
        boolean bl = false;
        while (var8_15 < n) {
            Field field = fieldArray[var8_15];
            field.setAccessible(true);
            this.addMember(members, field, field.getName());
            ++var8_15;
        }
        this.addMember(members, new SyntheticClassMember(targetClass), "class");
    }

    private String getJsniSignature(Member member) {
        Class<?>[] paramTypes;
        String name;
        if (member instanceof Field) {
            return member.getName();
        }
        if (member instanceof SyntheticClassMember) {
            return member.getName();
        }
        if (member instanceof Method) {
            name = member.getName();
            paramTypes = ((Method)member).getParameterTypes();
        } else if (member instanceof Constructor) {
            name = "new";
            paramTypes = ((Constructor)member).getParameterTypes();
        } else {
            throw new RuntimeException("Unexpected member type " + member.getClass().getName());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append("(");
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> type = paramTypes[i];
            String typeSig = this.getTypeSig(type);
            sb.append(typeSig);
        }
        sb.append(")");
        String mangledName = StringInterner.get().intern(sb.toString());
        return mangledName;
    }

    private String getTypeSig(Class<?> type) {
        if (type.isArray()) {
            return "[" + this.getTypeSig(type.getComponentType());
        }
        if (type.isPrimitive()) {
            if (type.equals(Integer.TYPE)) {
                return "I";
            }
            if (type.equals(Boolean.TYPE)) {
                return "Z";
            }
            if (type.equals(Character.TYPE)) {
                return "C";
            }
            if (type.equals(Long.TYPE)) {
                return "J";
            }
            if (type.equals(Short.TYPE)) {
                return "S";
            }
            if (type.equals(Float.TYPE)) {
                return "F";
            }
            if (type.equals(Double.TYPE)) {
                return "D";
            }
            if (type.equals(Byte.TYPE)) {
                return "B";
            }
            throw new RuntimeException("Unexpected primitive type: " + type.getName());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("L");
        sb.append(type.getName().replace('.', '/'));
        sb.append(";");
        return sb.toString();
    }

    private void lazyInitTargetMembers() {
        if (this.memberById == null) {
            this.memberById = new ArrayList();
            this.memberById.add(null);
            this.memberIdByName = new HashMap();
            LinkedHashMap<String, LinkedHashMap<String, Member>> members = this.findMostDerivedMembers(this.cls, true);
            for (Map.Entry<String, LinkedHashMap<String, Member>> entry : members.entrySet()) {
                String name = entry.getKey();
                ArrayList<Member> membersForName = new ArrayList<Member>(entry.getValue().values());
                this.addMemberIfUnique(name, membersForName);
                this.addMemberIfUnique(name, this.filterOutSyntheticMembers(membersForName));
            }
        }
    }
}

