/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.core.client.GWTBridge;
import com.google.gwt.core.client.GwtScriptOnly;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.javac.CompilationProblemReporter;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.javac.CompiledClass;
import com.google.gwt.dev.javac.JsniMethod;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.shell.DispatchClassInfo;
import com.google.gwt.dev.shell.DispatchIdOracle;
import com.google.gwt.dev.shell.EmmaStrategy;
import com.google.gwt.dev.shell.GWTBridgeImpl;
import com.google.gwt.dev.shell.JavaScriptHost;
import com.google.gwt.dev.shell.ShellJavaScriptHost;
import com.google.gwt.dev.shell.rewrite.HasAnnotation;
import com.google.gwt.dev.shell.rewrite.HostedModeClassRewriter;
import com.google.gwt.dev.util.JsniRef;
import com.google.gwt.dev.util.Name;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.dev.util.log.speedtracer.DevModeEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.MapMaker;
import com.google.gwt.thirdparty.guava.common.primitives.Primitives;
import com.google.gwt.util.tools.Utility;
import java.beans.Beans;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.objectweb.asm.commons.Method;

public final class CompilingClassLoader
extends ClassLoader
implements DispatchIdOracle {
    private static final ClassLoader bootstrapClassLoader = new ClassLoader(null){};
    private static final Map<String, Class<?>> BRIDGE_CLASS_NAMES = new HashMap();
    private static final Class<?>[] BRIDGE_CLASSES = new Class[]{ShellJavaScriptHost.class, GWTBridge.class, com.google.gwt.core.shared.GWTBridge.class};
    private static final boolean CLASS_DUMP = Boolean.getBoolean("gwt.dev.classDump");
    private static final String CLASS_DUMP_PATH = System.getProperty("gwt.dev.classDumpPath", "rewritten-classes");
    private static final String JACOCO_ENTRYPOINT = "org.jacoco.core.JaCoCo";
    private static boolean emmaAvailable = false;
    private static EmmaStrategy emmaStrategy;
    private static byte[] javaScriptHostBytes;
    private static final Map<String, Class<?>> primitiveTypes;
    private Set<CompilationUnit> alreadyInjected = new HashSet<CompilationUnit>();
    private final HostedModeClassRewriter classRewriter;
    private CompilationState compilationState;
    private final DispatchClassInfoOracle dispClassInfoOracle = new DispatchClassInfoOracle();
    private Class<?> gwtClass;
    private Class<?> javaScriptHostClass;
    private boolean isInjectingClass = false;
    private final ReentrantLock loadLock = new ReentrantLock();
    private final TreeLogger logger;
    private final Set<String> scriptOnlyClasses = new HashSet<String>();
    private ClassLoader scriptOnlyClassLoader;
    private ShellJavaScriptHost shellJavaScriptHost;
    private final Set<String> singleJsoImplTypes = new HashSet<String>();
    private Stack<CompilationUnit> toInject = new Stack();
    private final TypeOracle typeOracle;
    private final Map<Object, Object> weakJavaWrapperCache = new MapMaker().weakKeys().weakValues().makeMap();
    private final Map<Integer, Object> weakJsoCache = new MapMaker().weakValues().makeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void classDump(String name, byte[] bytes) {
        String className;
        String packageName;
        int pos = name.lastIndexOf(46);
        if (pos < 0) {
            packageName = "";
            className = name;
        } else {
            packageName = name.substring(0, pos);
            className = name.substring(pos + 1);
        }
        File dir = new File(CLASS_DUMP_PATH + File.separator + packageName.replace('.', File.separatorChar));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, className + ".class");
        FileOutputStream fileOutput = null;
        try {
            fileOutput = new FileOutputStream(file);
            fileOutput.write(bytes);
            fileOutput.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutput != null) {
                try {
                    fileOutput.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void ensureJavaScriptHostBytes(TreeLogger logger) throws UnableToCompleteException {
        if (javaScriptHostBytes != null) {
            return;
        }
        String className = JavaScriptHost.class.getName();
        try {
            String path = className.replace('.', '/') + ".class";
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL url = cl.getResource(path);
            if (url == null) {
                logger.log(TreeLogger.ERROR, "Could not find required bootstrap class '" + className + "' in the classpath", null);
                throw new UnableToCompleteException();
            }
            javaScriptHostBytes = CompilingClassLoader.getClassBytesFromStream(url.openStream());
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Error reading class bytes for " + className, e);
            throw new UnableToCompleteException();
        }
    }

    private static JClassType findImplementingTypeForMethod(JClassType type, JMethod method) {
        JType[] methodParamTypes = method.getErasedParameterTypes();
        while (type != null) {
            for (JMethod candidate : type.getMethods()) {
                if (!CompilingClassLoader.hasMatchingErasedSignature(method, methodParamTypes, candidate)) continue;
                return type;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getClassBytesFromStream(InputStream is) throws IOException {
        try {
            byte[] classBytes = new byte[is.available()];
            for (int read = 0; read < classBytes.length; read += is.read(classBytes, read, classBytes.length - read)) {
            }
            byte[] byArray = classBytes;
            return byArray;
        }
        finally {
            Utility.close(is);
        }
    }

    private static boolean hasMatchingErasedSignature(JMethod a, JType[] aParamTypes, JMethod b) {
        if (!a.getName().equals(b.getName())) {
            return false;
        }
        JType[] bParamTypes = b.getErasedParameterTypes();
        if (aParamTypes.length != bParamTypes.length) {
            return false;
        }
        for (int i = 0; i < aParamTypes.length; ++i) {
            if (aParamTypes[i] == bParamTypes[i]) continue;
            return false;
        }
        return true;
    }

    public CompilingClassLoader(TreeLogger logger, CompilationState compilationState, ShellJavaScriptHost javaScriptHost) throws UnableToCompleteException {
        super(null);
        this.logger = logger;
        this.compilationState = compilationState;
        this.shellJavaScriptHost = javaScriptHost;
        this.typeOracle = compilationState.getTypeOracle();
        this.setDefaultAssertionStatus(true);
        CompilingClassLoader.ensureJavaScriptHostBytes(logger);
        JClassType jsoType = this.typeOracle.findType("com.google.gwt.core.client.JavaScriptObject");
        if (jsoType != null) {
            HashSet<JClassType> jsoTypes = new HashSet<JClassType>();
            JClassType[] jsoSubtypes = jsoType.getSubtypes();
            Collections.addAll(jsoTypes, jsoSubtypes);
            jsoTypes.add(jsoType);
            HashSet<String> jsoTypeNames = new HashSet<String>();
            HashMap<String, List<String>> jsoSuperTypes = new HashMap<String, List<String>>();
            for (JClassType type : jsoTypes) {
                String binaryName = this.getBinaryName(type);
                if (binaryName.startsWith("java.")) continue;
                ArrayList<String> types = new ArrayList<String>();
                types.add(this.getBinaryName(type.getSuperclass()));
                for (JClassType impl : type.getImplementedInterfaces()) {
                    types.add(this.getBinaryName(impl));
                }
                jsoTypeNames.add(binaryName);
                jsoSuperTypes.put(binaryName, types);
            }
            MySingleJsoImplData singleJsoImplData = new MySingleJsoImplData();
            MyInstanceMethodOracle mapper = new MyInstanceMethodOracle(jsoTypes, this.typeOracle.getJavaLangObject(), singleJsoImplData);
            this.classRewriter = new HostedModeClassRewriter(jsoTypeNames, jsoSuperTypes, singleJsoImplData, mapper);
        } else {
            this.classRewriter = null;
        }
    }

    public Object getCachedJso(int uniqueId) {
        return this.weakJsoCache.get(uniqueId);
    }

    @Override
    public DispatchClassInfo getClassInfoByDispId(int dispId) {
        return this.dispClassInfoOracle.getClassInfoByDispId(dispId);
    }

    @Override
    public int getDispId(String jsniMemberRef) {
        return this.dispClassInfoOracle.getDispId(jsniMemberRef);
    }

    public Object getWrapperForObject(Object javaObject) {
        return this.weakJavaWrapperCache.get(javaObject);
    }

    public void putCachedJso(int uniqueId, Object jso) {
        this.weakJsoCache.put(uniqueId, jso);
    }

    public void putWrapperForObject(Object javaObject, Object wrapper) {
        this.weakJavaWrapperCache.put(javaObject, wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        if (className == null) {
            throw new ClassNotFoundException("null class name", new NullPointerException());
        }
        if (className.equals("com.google.gwt.core.ext.debug.JsoEval")) {
            return ClassLoader.getSystemClassLoader().loadClass(className);
        }
        this.loadLock.lock();
        try {
            CompilationUnit unit;
            boolean localInjection;
            if (this.scriptOnlyClasses.contains(className)) {
                throw new ClassNotFoundException();
            }
            if (BRIDGE_CLASS_NAMES.containsKey(className)) {
                Class<?> clazz = BRIDGE_CLASS_NAMES.get(className);
                return clazz;
            }
            byte[] classBytes = this.findClassBytes(className);
            if (classBytes == null) {
                throw new ClassNotFoundException(className);
            }
            if (HasAnnotation.hasAnnotation(classBytes, GwtScriptOnly.class)) {
                this.scriptOnlyClasses.add(className);
                this.maybeInitializeScriptOnlyClassLoader();
                this.loadLock.unlock();
                Class<?> clazz = Class.forName(className, false, this.scriptOnlyClassLoader);
                return clazz;
            }
            if (!this.isInjectingClass) {
                this.isInjectingClass = true;
                localInjection = true;
            } else {
                localInjection = false;
            }
            Class<?> newClass = this.defineClass(className, classBytes, 0, classBytes.length);
            if (className.equals(JavaScriptHost.class.getName())) {
                this.javaScriptHostClass = newClass;
                this.updateJavaScriptHost();
            }
            if (!this.classRewriter.isJsoIntf(className) && (unit = this.getUnitForClassName(this.canonicalizeClassName(className))) != null) {
                this.toInject.push(unit);
            }
            if (localInjection) {
                try {
                    while (this.toInject.size() > 0) {
                        unit = (CompilationUnit)this.toInject.remove(0);
                        if (this.alreadyInjected.contains(unit)) continue;
                        this.injectJsniMethods(unit);
                        this.alreadyInjected.add(unit);
                    }
                }
                finally {
                    this.isInjectingClass = false;
                }
            }
            if (className.equals("com.google.gwt.core.client.GWT")) {
                this.gwtClass = newClass;
                this.setGwtBridge(this.makeGwtBridge());
            }
            Class<?> clazz = newClass;
            return clazz;
        }
        finally {
            if (this.loadLock.isLocked()) {
                this.loadLock.unlock();
            }
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (Beans.isDesignTime()) {
            return super.loadClass(name, resolve);
        }
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        assert (this.getParent() == null);
        try {
            c = bootstrapClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            c = this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    void clear() {
        this.shellJavaScriptHost = null;
        this.scriptOnlyClasses.clear();
        this.scriptOnlyClassLoader = null;
        this.updateJavaScriptHost();
        this.weakJsoCache.clear();
        this.weakJavaWrapperCache.clear();
        this.dispClassInfoOracle.clear();
        this.setGwtBridge(null);
    }

    private String canonicalizeClassName(String className) {
        String lookupClassName = className.replace('.', '/');
        if (this.classRewriter != null && this.classRewriter.isJsoImpl(className)) {
            lookupClassName = lookupClassName.substring(0, lookupClassName.length() - 1);
        }
        return lookupClassName;
    }

    private byte[] findClassBytes(String className) {
        CompilationUnit unit;
        if (JavaScriptHost.class.getName().equals(className)) {
            return javaScriptHostBytes;
        }
        String lookupClassName = this.canonicalizeClassName(className);
        CompiledClass compiledClass = this.compilationState.getClassFileMap().get(lookupClassName);
        if (this.classRewriter != null && this.classRewriter.isJsoIntf(className)) {
            byte[] newBytes = this.classRewriter.writeJsoIntf(className, compiledClass != null ? compiledClass.getBytes() : null);
            if (CLASS_DUMP) {
                CompilingClassLoader.classDump(className, newBytes);
            }
            return newBytes;
        }
        CompilationUnit compilationUnit = unit = compiledClass == null ? this.getUnitForClassName(lookupClassName) : compiledClass.getUnit();
        if (emmaAvailable) {
            List<JsniMethod> jsniMethods;
            List<JsniMethod> list = jsniMethods = unit == null ? null : unit.getJsniMethods();
            if (!(unit == null || unit.isSuperSource() || unit.isGenerated() || !unit.hasAnonymousClasses() || jsniMethods == null || jsniMethods.size() <= 0 || unit.createdClassMapping() || unit.constructAnonymousClassMappings(this.logger))) {
                this.logger.log(TreeLogger.ERROR, "Our heuristic for mapping anonymous classes between compilers failed. Unsafe to continue because the wrong jsni code could end up running. className = " + className);
                return null;
            }
        }
        byte[] classBytes = null;
        if (compiledClass != null) {
            classBytes = compiledClass.getBytes();
            if (!compiledClass.getUnit().isSuperSource()) {
                classBytes = emmaStrategy.getEmmaClassBytes(classBytes, lookupClassName, compiledClass.getUnit().getLastModified());
            } else if (this.logger.isLoggable(TreeLogger.SPAM)) {
                this.logger.log(TreeLogger.SPAM, "no emma instrumentation for " + lookupClassName + " because it is from super-source");
            }
        } else if (emmaAvailable && this.typeHasCompilationUnit(lookupClassName) && CompilationUnit.isClassnameGenerated(className)) {
            if (this.logger.isLoggable(TreeLogger.DEBUG)) {
                this.logger.log(TreeLogger.DEBUG, "EmmaStrategy: loading " + lookupClassName + " from disk even though TypeOracle does not know about it");
            }
            classBytes = emmaStrategy.getEmmaClassBytes(null, lookupClassName, 0L);
        }
        if (classBytes != null && this.classRewriter != null) {
            Map<String, String> anonymousClassMap = Collections.emptyMap();
            if (unit != null) {
                anonymousClassMap = unit.getAnonymousClassMap();
            }
            byte[] newBytes = this.classRewriter.rewrite(this.typeOracle, className, classBytes, anonymousClassMap);
            if (CLASS_DUMP && !Arrays.equals(classBytes, newBytes)) {
                CompilingClassLoader.classDump(className, newBytes);
            }
            classBytes = newBytes;
        }
        if (unit != null && unit.isError()) {
            CompilationProblemReporter.reportErrors(this.logger, unit, false);
        }
        return classBytes;
    }

    private String getBinaryName(JClassType type) {
        String name = type.getPackage().getName() + '.';
        name = name + type.getName().replace('.', '$');
        return name;
    }

    private String getBinaryOrPrimitiveName(JType type) {
        JArrayType asArray = type.isArray();
        JClassType asClass = type.isClassOrInterface();
        JPrimitiveType asPrimitive = type.isPrimitive();
        if (asClass != null) {
            return this.getBinaryName(asClass);
        }
        if (asPrimitive != null) {
            return asPrimitive.getQualifiedSourceName();
        }
        if (asArray != null) {
            JType componentType = asArray.getComponentType();
            return this.getBinaryOrPrimitiveName(componentType) + "[]";
        }
        throw new InternalCompilerException("Cannot create binary name for " + type.getQualifiedSourceName());
    }

    private CompilationUnit getUnitForClassName(String className) {
        String mainTypeName = className;
        int index = mainTypeName.length();
        CompiledClass cc = null;
        while (cc == null && index != -1) {
            mainTypeName = mainTypeName.substring(0, index);
            cc = this.compilationState.getClassFileMap().get(mainTypeName);
            index = mainTypeName.lastIndexOf(36);
        }
        return cc == null ? null : cc.getUnit();
    }

    private void injectJsniMethods(CompilationUnit unit) {
        if (unit == null || unit.getJsniMethods() == null) {
            return;
        }
        SpeedTracerLogger.Event event = SpeedTracerLogger.start(DevModeEventType.LOAD_JSNI, "unit", unit.getTypeName());
        try {
            this.shellJavaScriptHost.createNativeMethods(this.logger, unit.getJsniMethods(), this);
        }
        finally {
            event.end(new String[0]);
        }
    }

    private void maybeInitializeScriptOnlyClassLoader() {
        if (this.scriptOnlyClassLoader == null) {
            this.scriptOnlyClassLoader = new MultiParentClassLoader(this, Thread.currentThread().getContextClassLoader());
        }
    }

    private boolean typeHasCompilationUnit(String className) {
        return this.getUnitForClassName(className) != null;
    }

    private void setGwtBridge(GWTBridgeImpl bridge) {
        Throwable caught;
        if (this.gwtClass == null) {
            return;
        }
        try {
            Class[] paramTypes = new Class[]{GWTBridge.class};
            java.lang.reflect.Method setBridgeMethod = this.gwtClass.getDeclaredMethod("setBridge", paramTypes);
            setBridgeMethod.setAccessible(true);
            setBridgeMethod.invoke(this.gwtClass, bridge);
            return;
        }
        catch (SecurityException e) {
            caught = e;
        }
        catch (NoSuchMethodException e) {
            caught = e;
        }
        catch (IllegalArgumentException e) {
            caught = e;
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        catch (InvocationTargetException e) {
            caught = e.getTargetException();
        }
        throw new RuntimeException("Error initializing GWT bridge", caught);
    }

    private GWTBridgeImpl makeGwtBridge() {
        if (this.shellJavaScriptHost == null) {
            return null;
        }
        return new GWTBridgeImpl(this.shellJavaScriptHost);
    }

    private void updateJavaScriptHost() {
        Throwable caught;
        if (this.javaScriptHostClass == null) {
            return;
        }
        try {
            Class[] paramTypes = new Class[]{ShellJavaScriptHost.class};
            java.lang.reflect.Method setHostMethod = this.javaScriptHostClass.getMethod("setHost", paramTypes);
            setHostMethod.invoke(this.javaScriptHostClass, this.shellJavaScriptHost);
            return;
        }
        catch (SecurityException e) {
            caught = e;
        }
        catch (NoSuchMethodException e) {
            caught = e;
        }
        catch (IllegalArgumentException e) {
            caught = e;
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        catch (InvocationTargetException e) {
            caught = e.getTargetException();
        }
        throw new RuntimeException("Error initializing JavaScriptHost", caught);
    }

    static {
        Class<?>[] builder = ImmutableMap.builder();
        for (Class<?> klass : Primitives.allPrimitiveTypes()) {
            builder.put(klass.getSimpleName(), klass);
        }
        primitiveTypes = builder.build();
        for (Class<?> c : BRIDGE_CLASSES) {
            BRIDGE_CLASS_NAMES.put(c.getName(), c);
        }
        try {
            Class<?> emmaBridge = Class.forName("com.vladium.emma.rt.RT", false, Thread.currentThread().getContextClassLoader());
            BRIDGE_CLASS_NAMES.put("com.vladium.emma.rt.RT", emmaBridge);
            emmaAvailable = true;
        }
        catch (ClassNotFoundException emmaBridge) {
            // empty catch block
        }
        emmaStrategy = EmmaStrategy.get(emmaAvailable);
        try {
            Class<?> jacoco = Class.forName(JACOCO_ENTRYPOINT, false, Thread.currentThread().getContextClassLoader());
            String offlineName = (String)jacoco.getDeclaredField("RUNTIMEPACKAGE").get(jacoco) + ".Offline";
            Class<?> offlineBridge = Class.forName(offlineName, false, Thread.currentThread().getContextClassLoader());
            BRIDGE_CLASS_NAMES.put(offlineName, offlineBridge);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class MySingleJsoImplData
    implements HostedModeClassRewriter.SingleJsoImplData {
        private final SortedSet<String> mangledNames = new TreeSet<String>();
        private final Map<String, List<Method>> mangledNamesToDeclarations = new HashMap<String, List<Method>>();
        private final Map<String, List<Method>> mangledNamesToImplementations = new HashMap<String, List<Method>>();
        private final Set<String> unmodifiableIntfNames = Collections.unmodifiableSet(CompilingClassLoader.access$200(CompilingClassLoader.this));
        private final SortedSet<String> unmodifiableNames = Collections.unmodifiableSortedSet(this.mangledNames);

        public MySingleJsoImplData() {
            block0: for (JClassType jClassType : CompilingClassLoader.this.typeOracle.getSingleJsoImplInterfaces()) {
                assert (jClassType.isInterface() == jClassType) : "Expecting interfaces only";
                for (JMethod intfMethod : jClassType.getOverridableMethods()) {
                    JMethod implementingMethod;
                    assert (intfMethod.isAbstract()) : "Expecting only abstract methods";
                    JClassType implementingType = CompilingClassLoader.this.typeOracle.getSingleJsoImpl(intfMethod.getEnclosingType());
                    if (implementingType == null || implementingType.isAnnotationPresent(GwtScriptOnly.class)) continue block0;
                    CompilingClassLoader.this.singleJsoImplTypes.add(CompilingClassLoader.this.canonicalizeClassName(CompilingClassLoader.this.getBinaryName(jClassType)));
                    String mangledName = CompilingClassLoader.this.getBinaryName(jClassType).replace('.', '_') + "_" + intfMethod.getName();
                    this.mangledNames.add(mangledName);
                    while ((implementingMethod = this.findOverloadUsingErasure(implementingType, intfMethod)) == null) {
                        implementingType = implementingType.getSuperclass();
                    }
                    String decl = CompilingClassLoader.this.getBinaryOrPrimitiveName(intfMethod.getReturnType().getErasedType()) + " " + intfMethod.getName() + "(";
                    for (JParameter param : intfMethod.getParameters()) {
                        decl = decl + ",";
                        decl = decl + CompilingClassLoader.this.getBinaryOrPrimitiveName(param.getType().getErasedType());
                    }
                    decl = decl + ")";
                    Method declaration = Method.getMethod(decl);
                    this.addToMap(this.mangledNamesToDeclarations, mangledName, declaration);
                    String returnName = CompilingClassLoader.this.getBinaryOrPrimitiveName(implementingMethod.getReturnType().getErasedType());
                    String jsoName = CompilingClassLoader.this.getBinaryOrPrimitiveName(implementingType);
                    String decl2 = returnName + " " + intfMethod.getName() + "$ (" + jsoName;
                    for (JParameter param : implementingMethod.getParameters()) {
                        decl2 = decl2 + ",";
                        decl2 = decl2 + CompilingClassLoader.this.getBinaryOrPrimitiveName(param.getType().getErasedType());
                    }
                    decl2 = decl2 + ")";
                    Method toImplement = Method.getMethod(decl2);
                    this.addToMap(this.mangledNamesToImplementations, mangledName, toImplement);
                }
            }
            if (CompilingClassLoader.this.logger.isLoggable(TreeLogger.SPAM)) {
                TreeLogger dumpLogger = CompilingClassLoader.this.logger.branch(TreeLogger.SPAM, "SingleJsoImpl method mappings");
                for (Map.Entry<String, List<Method>> entry : this.mangledNamesToImplementations.entrySet()) {
                    dumpLogger.log(TreeLogger.SPAM, entry.getKey() + " -> " + entry.getValue());
                }
            }
        }

        @Override
        public List<Method> getDeclarations(String mangledName) {
            List<Method> toReturn = this.mangledNamesToDeclarations.get(mangledName);
            return toReturn == null ? null : Collections.unmodifiableList(toReturn);
        }

        @Override
        public List<Method> getImplementations(String mangledName) {
            List<Method> toReturn = this.mangledNamesToImplementations.get(mangledName);
            return toReturn == null ? toReturn : Collections.unmodifiableList(toReturn);
        }

        @Override
        public SortedSet<String> getMangledNames() {
            return this.unmodifiableNames;
        }

        @Override
        public Set<String> getSingleJsoIntfTypes() {
            return this.unmodifiableIntfNames;
        }

        private <K, V> void addToMap(Map<K, List<V>> map, K key, V value) {
            List<V> list = map.get(key);
            if (list == null) {
                map.put(key, Lists.create(value));
            } else {
                List<V> maybeOther = Lists.add(list, value);
                if (maybeOther != list) {
                    map.put(key, maybeOther);
                }
            }
        }

        private JMethod findOverloadUsingErasure(JClassType implementingType, JMethod intfMethod) {
            int numParams = intfMethod.getParameters().length;
            JType[] erasedTypes = new JType[numParams];
            for (int i = 0; i < numParams; ++i) {
                erasedTypes[i] = intfMethod.getParameters()[i].getType().getErasedType();
            }
            block1: for (JMethod method : implementingType.getOverloads(intfMethod.getName())) {
                JParameter[] params = method.getParameters();
                if (params.length != numParams) continue;
                for (int i = 0; i < numParams; ++i) {
                    if (params[i].getType().getErasedType() != erasedTypes[i]) continue block1;
                }
                return method;
            }
            return null;
        }
    }

    private class MyInstanceMethodOracle
    implements HostedModeClassRewriter.InstanceMethodOracle {
        private final Map<String, Set<JClassType>> signatureToDeclaringClasses = new HashMap<String, Set<JClassType>>();

        public MyInstanceMethodOracle(Set<JClassType> jsoTypes, JClassType javaLangObject, HostedModeClassRewriter.SingleJsoImplData jsoData) {
            for (JClassType type : jsoTypes) {
                for (JMethod method : type.getMethods()) {
                    if (method.isStatic()) continue;
                    assert (!method.isAbstract()) : "Abstract method in JSO type " + method;
                    this.add(type, method);
                }
            }
            for (String intfName : jsoData.getSingleJsoIntfTypes()) {
                JClassType intf = CompilingClassLoader.this.typeOracle.findType(Name.InternalName.toSourceName(intfName));
                JClassType jClassType = CompilingClassLoader.this.typeOracle.getSingleJsoImpl(intf);
                for (JMethod method : intf.getMethods()) {
                    JClassType implementingJso = CompilingClassLoader.findImplementingTypeForMethod(jClassType, method);
                    assert (implementingJso != null) : "Jso should contain method: " + method.getJsniSignature();
                    this.add(implementingJso, method);
                }
            }
            for (Iterator<Object> iterator : javaLangObject.getMethods()) {
                if (iterator.isStatic()) continue;
                String signature = this.createSignature((JMethod)((Object)iterator));
                HashSet<JClassType> declaringClasses = new HashSet<JClassType>();
                this.signatureToDeclaringClasses.put(signature, declaringClasses);
                declaringClasses.add(javaLangObject);
            }
        }

        @Override
        public String findOriginalDeclaringClass(String desc, String signature) {
            Set<JClassType> declaringClasses = this.signatureToDeclaringClasses.get(signature);
            assert (declaringClasses != null) : "No classes for " + signature;
            if (declaringClasses.size() == 1) {
                return this.createDescriptor(declaringClasses.iterator().next());
            }
            String sourceName = desc.replace('/', '.');
            sourceName = sourceName.replace('$', '.');
            JClassType declaredType = CompilingClassLoader.this.typeOracle.findType(sourceName);
            if (declaringClasses.contains(declaredType)) {
                return desc;
            }
            for (JClassType possibleSupertype : declaringClasses) {
                if (!declaredType.isAssignableTo(possibleSupertype)) continue;
                return this.createDescriptor(possibleSupertype);
            }
            throw new IllegalArgumentException("Could not resolve signature '" + signature + "' from class '" + desc + "'");
        }

        private void add(JClassType type, JMethod method) {
            String signature = this.createSignature(method);
            Set<JClassType> declaringClasses = this.signatureToDeclaringClasses.get(signature);
            if (declaringClasses == null) {
                declaringClasses = new HashSet<JClassType>();
                this.signatureToDeclaringClasses.put(signature, declaringClasses);
            }
            declaringClasses.add(type);
        }

        private String createDescriptor(JClassType type) {
            String jniSignature = type.getJNISignature();
            return jniSignature.substring(1, jniSignature.length() - 1);
        }

        private String createSignature(JMethod method) {
            StringBuffer sb = new StringBuffer(method.getName());
            sb.append('(');
            for (JParameter param : method.getParameters()) {
                sb.append(param.getType().getJNISignature());
            }
            sb.append(')');
            sb.append(method.getReturnType().getJNISignature());
            String signature = sb.toString();
            return signature;
        }
    }

    private static class MultiParentClassLoader
    extends ClassLoader {
        private final ClassLoader resources;

        public MultiParentClassLoader(ClassLoader parent, ClassLoader resources) {
            super(parent);
            assert (parent != null);
            this.resources = resources;
        }

        @Override
        protected synchronized Class<?> findClass(String name) throws ClassNotFoundException {
            String resourceName = name.replace('.', '/') + ".class";
            URL url = this.resources.getResource(resourceName);
            if (url == null) {
                throw new ClassNotFoundException();
            }
            byte[] bytes = Util.readURLAsBytes(url);
            return this.defineClass(name, bytes, 0, bytes.length);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                Class<?> c = this.findLoadedClass(name);
                if (c != null) {
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
                return this.getParent().loadClass(name);
            }
            catch (Throwable t) {
                Class<?> c = this.findClass(name);
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
    }

    private final class DispatchClassInfoOracle {
        private final ArrayList<DispatchClassInfo> classIdToClassInfo = new ArrayList();
        private final Map<String, DispatchClassInfo> classNameToClassInfo = new HashMap<String, DispatchClassInfo>();

        private DispatchClassInfoOracle() {
        }

        public synchronized void clear() {
            this.classIdToClassInfo.clear();
            this.classNameToClassInfo.clear();
        }

        public synchronized DispatchClassInfo getClassInfoByDispId(int dispId) {
            int classId = this.extractClassIdFromDispId(dispId);
            return this.classIdToClassInfo.get(classId);
        }

        public synchronized int getDispId(String jsniMemberRef) {
            JsniRef parsed;
            if (jsniMemberRef.equals("toString")) {
                jsniMemberRef = "@java.lang.Object::toString()";
            }
            if ((parsed = JsniRef.parse(jsniMemberRef)) == null) {
                CompilingClassLoader.this.logger.log(TreeLogger.ERROR, "Malformed JSNI reference '" + jsniMemberRef + "'; expect subsequent failures", new NoSuchFieldError(jsniMemberRef));
                return -1;
            }
            String className = parsed.className();
            DispatchClassInfo dispClassInfo = this.getClassInfoFromClassName(className);
            if (dispClassInfo != null) {
                String memberName = parsed.memberSignature();
                if (CompilingClassLoader.this.singleJsoImplTypes.contains(CompilingClassLoader.this.canonicalizeClassName(className))) {
                    CompilingClassLoader.this.logger.log(TreeLogger.ERROR, "Invalid JSNI reference to SingleJsoImpl interface (" + className + "); consider using a trampoline. Expect subsequent failures.", new NoSuchFieldError(jsniMemberRef));
                    return -1;
                }
                int memberId = dispClassInfo.getMemberId(memberName);
                if (memberId < 0 && !className.startsWith("java.")) {
                    CompilingClassLoader.this.logger.log(TreeLogger.ERROR, "Member '" + memberName + "' in JSNI reference '" + jsniMemberRef + "' could not be found; expect subsequent failures", new NoSuchFieldError(memberName));
                }
                return this.synthesizeDispId(dispClassInfo.getClassId(), memberId);
            }
            CompilingClassLoader.this.logger.log(TreeLogger.ERROR, "Class '" + className + "' in JSNI reference '" + jsniMemberRef + "' could not be found; expect subsequent failures", new ClassNotFoundException(className));
            return -1;
        }

        private int extractClassIdFromDispId(int dispId) {
            return dispId >> 16 & 0xFFFF;
        }

        private Class<?> getClassFromBinaryName(String binaryClassName) {
            int dims = 0;
            while (binaryClassName.endsWith("[]")) {
                ++dims;
                binaryClassName = binaryClassName.substring(0, binaryClassName.length() - 2);
            }
            Class<?> clazz = (Class<?>)primitiveTypes.get(binaryClassName);
            if (clazz == null) {
                try {
                    clazz = Class.forName(binaryClassName, false, CompilingClassLoader.this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null && binaryClassName.length() == 1 && "ZBCDFIJSV".indexOf(binaryClassName.charAt(0)) >= 0) {
                clazz = this.getDeprecatedPrimitiveType(binaryClassName.charAt(0));
                assert (clazz != null);
            }
            if (dims > 0) {
                return Array.newInstance(clazz, new int[dims]).getClass();
            }
            return clazz;
        }

        private Class<?> getClassFromBinaryOrSourceName(String className) {
            JClassType type = CompilingClassLoader.this.typeOracle.findType(Name.SourceOrBinaryName.toSourceName(className));
            if (type != null) {
                String jniSig = type.getJNISignature();
                jniSig = jniSig.substring(1, jniSig.length() - 1);
                className = Name.InternalName.toBinaryName(jniSig);
            }
            return this.getClassFromBinaryName(className);
        }

        private DispatchClassInfo getClassInfoFromClassName(String className) {
            DispatchClassInfo dispClassInfo = this.classNameToClassInfo.get(className);
            if (dispClassInfo != null) {
                return dispClassInfo;
            }
            Class<?> cls = this.getClassFromBinaryOrSourceName(className);
            if (cls == null) {
                return null;
            }
            if (CompilingClassLoader.this.classRewriter.isJsoIntf(cls.getName())) {
                cls = this.getClassFromBinaryName(cls.getName() + "$");
            }
            int classId = this.classIdToClassInfo.size();
            dispClassInfo = new DispatchClassInfo(cls, classId);
            this.classIdToClassInfo.add(dispClassInfo);
            this.classNameToClassInfo.put(className, dispClassInfo);
            return dispClassInfo;
        }

        @Deprecated
        private Class<?> getDeprecatedPrimitiveType(char c) {
            switch (c) {
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'V': {
                    return Void.TYPE;
                }
            }
            return null;
        }

        private int synthesizeDispId(int classId, int memberId) {
            return classId << 16 | memberId;
        }
    }
}

