/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.dev.shell.Icons;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class CloseButton
extends JPanel {
    private Callback callback;

    public CloseButton(String toolTipText) {
        super(new FlowLayout(0, 0, 0));
        this.setOpaque(false);
        ImageIcon closeIcon = Icons.getClose();
        JButton button = new JButton(closeIcon);
        button.setBorderPainted(false);
        button.setPreferredSize(new Dimension(closeIcon.getIconWidth(), closeIcon.getIconHeight()));
        if (toolTipText != null) {
            button.setToolTipText(toolTipText);
        }
        this.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CloseButton.this.callback != null) {
                    CloseButton.this.callback.onCloseRequest();
                }
            }
        });
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public static interface Callback {
        public void onCloseRequest();
    }
}

