/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.core.ext.linker.impl.StandardLinkerContext;
import com.google.gwt.dev.DevMode;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.shell.BrowserChannelServer;
import com.google.gwt.dev.shell.CodeServerListener;
import com.google.gwt.dev.util.NullOutputFileSet;
import com.google.gwt.dev.util.OutputFileSet;
import com.google.gwt.dev.util.OutputFileSetOnDirectory;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;

public class BrowserListener
implements CodeServerListener {
    private ServerSocket listenSocket;
    private Thread listenThread;
    private boolean ignoreRemoteDeath = false;
    private DevMode.HostedModeOptions options;
    private TreeLogger logger;

    public static String getDevModeURLParams(String address, int port) {
        return "gwt.codesvr=" + address + ":" + port;
    }

    public BrowserListener(TreeLogger treeLogger, DevMode.HostedModeOptions options, final BrowserChannelServer.SessionHandlerServer handler) {
        try {
            this.options = options;
            this.logger = treeLogger;
            this.listenSocket = new ServerSocket();
            this.listenSocket.setReuseAddress(true);
            InetAddress address = InetAddress.getByName(options.getBindAddress());
            this.listenSocket.bind(new InetSocketAddress(address, options.getCodeServerPort()));
            if (this.logger.isLoggable(TreeLogger.TRACE)) {
                this.logger.log(TreeLogger.TRACE, "Started code server on port " + this.listenSocket.getLocalPort(), null);
            }
            this.listenThread = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            int id;
                            while (true) {
                                Socket sock = BrowserListener.this.listenSocket.accept();
                                TreeLogger branch = BrowserListener.this.logger.branch(TreeLogger.TRACE, "Connection received from " + sock.getInetAddress().getCanonicalHostName() + ":" + sock.getPort());
                                try {
                                    sock.setTcpNoDelay(true);
                                    sock.setKeepAlive(true);
                                }
                                catch (SocketException socketException) {
                                    // empty catch block
                                }
                                BrowserChannelServer server = new BrowserChannelServer(branch, sock, handler, BrowserListener.this.ignoreRemoteDeath);
                                id = server.getJavaObjectsExposedInBrowser().add(server);
                                assert (id == 0);
                            }
                        }
                        catch (IOException e) {
                            BrowserListener.this.logger.log(TreeLogger.ERROR, "Communications error", e);
                            continue;
                        }
                        break;
                    }
                }
            };
            this.listenThread.setName("Code server listener");
            this.listenThread.setDaemon(true);
        }
        catch (BindException e) {
            this.logger.log(TreeLogger.ERROR, "Unable to bind socket on port " + options.getPort() + " -- is another session active?", e);
        }
        catch (IOException e) {
            this.logger.log(TreeLogger.ERROR, "Communications error", e);
        }
    }

    @Override
    public int getSocketPort() {
        return this.listenSocket.getLocalPort();
    }

    @Override
    public URL makeStartupUrl(String url) throws UnableToCompleteException {
        URL parsedUrl = null;
        try {
            parsedUrl = new URL(url);
            String path = parsedUrl.getPath();
            String query = parsedUrl.getQuery();
            String hash = parsedUrl.getRef();
            String hostedParam = BrowserListener.getDevModeURLParams(this.options.getConnectAddress(), this.getSocketPort());
            query = query == null ? hostedParam : query + '&' + hostedParam;
            path = path + '?' + query;
            if (hash != null) {
                path = path + '#' + hash;
            }
            parsedUrl = new URL(parsedUrl.getProtocol(), parsedUrl.getHost(), parsedUrl.getPort(), path);
            url = parsedUrl.toExternalForm();
        }
        catch (MalformedURLException e) {
            this.logger.log(TreeLogger.ERROR, "Invalid URL " + url, e);
            throw new UnableToCompleteException();
        }
        return parsedUrl;
    }

    @Override
    public synchronized void writeCompilerOutput(StandardLinkerContext linkerStack, ArtifactSet artifacts, ModuleDef module, boolean isRelink) throws UnableToCompleteException {
        TreeLogger linkLogger = this.logger.branch(TreeLogger.DEBUG, "Linking module '" + module.getName() + "'");
        OutputFileSetOnDirectory outFileSet = new OutputFileSetOnDirectory(this.options.getModuleBaseDir(), module.getName() + "/");
        OutputFileSetOnDirectory deployFileSet = new OutputFileSetOnDirectory(this.options.getDeployDir(), module.getName() + "/");
        OutputFileSet extraFileSet = new NullOutputFileSet();
        if (this.options.getExtraDir() != null) {
            extraFileSet = new OutputFileSetOnDirectory(this.options.getExtraDir(), module.getName() + "/");
        }
        linkerStack.produceOutput(linkLogger, artifacts, EmittedArtifact.Visibility.Public, outFileSet);
        linkerStack.produceOutput(linkLogger, artifacts, EmittedArtifact.Visibility.Deploy, deployFileSet);
        linkerStack.produceOutput(linkLogger, artifacts, EmittedArtifact.Visibility.Private, extraFileSet);
        outFileSet.close();
        deployFileSet.close();
        try {
            extraFileSet.close();
        }
        catch (IOException e) {
            linkLogger.log(TreeLogger.ERROR, "Error emiting extra files", e);
            throw new UnableToCompleteException();
        }
        new File(this.options.getModuleBaseDir() + "/" + module.getName() + "/" + module.getName() + ".nocache.js").setLastModified(System.currentTimeMillis());
    }

    @Override
    public void setIgnoreRemoteDeath(boolean ignoreRemoteDeath) {
        this.ignoreRemoteDeath = ignoreRemoteDeath;
    }

    @Override
    public void start() {
        if (this.listenThread != null) {
            this.listenThread.start();
        }
    }
}

