/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.shell.BrowserChannel;
import com.google.gwt.dev.shell.BrowserChannelException;
import com.google.gwt.dev.shell.CompilingClassLoader;
import com.google.gwt.dev.shell.DevModeSession;
import com.google.gwt.dev.shell.HostedHtmlVersion;
import com.google.gwt.dev.shell.HostedModeException;
import com.google.gwt.dev.shell.JsValue;
import com.google.gwt.dev.shell.JsValueGlue;
import com.google.gwt.dev.shell.JsValueOOPHM;
import com.google.gwt.dev.shell.ModuleSpace;
import com.google.gwt.dev.shell.RemoteObjectTable;
import com.google.gwt.dev.shell.ServerObjectsTable;
import com.google.gwt.dev.util.log.dashboard.DashboardNotifier;
import com.google.gwt.dev.util.log.dashboard.DashboardNotifierFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BrowserChannelServer
extends BrowserChannel
implements Runnable {
    public static final String JSO_CLASS = "com.google.gwt.core.client.JavaScriptObject";
    private static Map<String, byte[]> iconCache = new HashMap<String, byte[]>();
    private static final Object cacheLock = new Object();
    private DevModeSession devModeSession;
    private final SessionHandlerServer handler;
    private final boolean ignoreRemoteDeath;
    private final ServerObjectsTable javaObjectsInBrowser = new ServerObjectsTable();
    private TreeLogger logger;
    private String moduleName;
    private String userAgent;
    private int protocolVersion = -1;

    public BrowserChannelServer(TreeLogger initialLogger, Socket socket, SessionHandlerServer handler, boolean ignoreRemoteDeath) throws IOException {
        super(socket, new ServerObjectRefFactory());
        this.handler = handler;
        this.ignoreRemoteDeath = ignoreRemoteDeath;
        this.init(initialLogger);
    }

    BrowserChannelServer(TreeLogger initialLogger, InputStream inputStream, OutputStream outputStream, SessionHandlerServer handler, boolean ignoreRemoteDeath) {
        super(inputStream, outputStream, new ServerObjectRefFactory());
        this.handler = handler;
        this.ignoreRemoteDeath = ignoreRemoteDeath;
        this.init(initialLogger);
    }

    public void freeJsValue(int[] ids) {
        try {
            new BrowserChannel.FreeMessage(this, ids).send();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HostedModeException("I/O error communicating with client");
        }
    }

    public DevModeSession getDevModeSession() {
        return this.devModeSession;
    }

    public ServerObjectsTable getJavaObjectsExposedInBrowser() {
        return this.javaObjectsInBrowser;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public BrowserChannel.ReturnMessage invoke(String methodName, BrowserChannel.Value vthis, BrowserChannel.Value[] vargs, SessionHandlerServer handler) throws IOException, BrowserChannelException {
        new BrowserChannel.InvokeOnClientMessage(this, methodName, vthis, vargs).send();
        return this.reactToMessagesWhileWaitingForReturn(handler);
    }

    public void invokeJavascript(CompilingClassLoader ccl, JsValueOOPHM jsthis, String methodName, JsValueOOPHM[] args, JsValueOOPHM returnJsValue) throws Throwable {
        ServerObjectsTable remoteObjects = this.getJavaObjectsExposedInBrowser();
        BrowserChannel.Value vthis = this.convertFromJsValue(remoteObjects, jsthis);
        BrowserChannel.Value[] vargs = new BrowserChannel.Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            vargs[i] = this.convertFromJsValue(remoteObjects, args[i]);
        }
        try {
            BrowserChannel.InvokeOnClientMessage invokeMessage = new BrowserChannel.InvokeOnClientMessage(this, methodName, vthis, vargs);
            invokeMessage.send();
            BrowserChannel.ReturnMessage msg = this.reactToMessagesWhileWaitingForReturn(this.handler);
            BrowserChannel.Value returnValue = msg.getReturnValue();
            this.convertToJsValue(ccl, remoteObjects, returnValue, returnJsValue);
            if (msg.isException()) {
                Object exceptionValue;
                if (returnValue.isNull() || returnValue.isUndefined()) {
                    exceptionValue = null;
                } else if (returnValue.isString()) {
                    exceptionValue = returnValue.getString();
                } else if (returnValue.isJsObject()) {
                    exceptionValue = JsValueGlue.createJavaScriptObject(returnJsValue, ccl);
                } else if (returnValue.isJavaObject()) {
                    Object object = remoteObjects.get(returnValue.getJavaObject().getRefid());
                    Object target = ((JsValueOOPHM.DispatchObjectOOPHM)object).getTarget();
                    if (target instanceof Throwable) {
                        throw (Throwable)target;
                    }
                    exceptionValue = target;
                } else {
                    exceptionValue = returnValue.getValue().toString();
                }
                RuntimeException exception = ModuleSpace.createJavaScriptException(ccl, exceptionValue, methodName + "(" + Arrays.toString(args) + ")");
                exception.fillInStackTrace();
                throw exception;
            }
        }
        catch (IOException e) {
            throw new BrowserChannel.RemoteDeathError(e);
        }
        catch (BrowserChannelException e) {
            throw new BrowserChannel.RemoteDeathError(e);
        }
    }

    public void loadJsni(String jsni) {
        try {
            BrowserChannel.LoadJsniMessage jsniMessage = new BrowserChannel.LoadJsniMessage(this, jsni);
            jsniMessage.send();
        }
        catch (IOException e) {
            throw new BrowserChannel.RemoteDeathError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reactToMessages(SessionHandlerServer handler) {
        try {
            BrowserChannel.MessageType messageType;
            block9: while (true) {
                this.getStreamToOtherSide().flush();
                messageType = BrowserChannel.Message.readMessageType(this.getStreamFromOtherSide());
                switch (messageType) {
                    case FREE_VALUE: {
                        BrowserChannel.FreeMessage freeMsg = BrowserChannel.FreeMessage.receive(this);
                        handler.freeValue(this, freeMsg.getIds());
                        continue block9;
                    }
                    case INVOKE: {
                        BrowserChannel.InvokeOnServerMessage imsg = BrowserChannel.InvokeOnServerMessage.receive(this);
                        BrowserChannel.SessionHandler.ExceptionOrReturnValue result = handler.invoke(this, imsg.getThis(), imsg.getMethodDispatchId(), imsg.getArgs());
                        this.sendFreedValues();
                        BrowserChannel.ReturnMessage.send(this, result);
                        continue block9;
                    }
                    case INVOKE_SPECIAL: {
                        this.handleInvokeSpecial(handler);
                        continue block9;
                    }
                    case QUIT: {
                        return;
                    }
                }
                break;
            }
            throw new BrowserChannel.RemoteDeathError(new BrowserChannelException("Invalid message type " + (Object)((Object)messageType)));
        }
        catch (IOException e) {
            throw new BrowserChannel.RemoteDeathError(e);
        }
        catch (BrowserChannelException e) {
            throw new BrowserChannel.RemoteDeathError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BrowserChannel.ReturnMessage reactToMessagesWhileWaitingForReturn(SessionHandlerServer handler) throws BrowserChannelException, BrowserChannel.RemoteDeathError {
        try {
            BrowserChannel.MessageType messageType;
            block10: while (true) {
                this.getStreamToOtherSide().flush();
                messageType = BrowserChannel.Message.readMessageType(this.getStreamFromOtherSide());
                switch (messageType) {
                    case FREE_VALUE: {
                        BrowserChannel.FreeMessage freeMsg = BrowserChannel.FreeMessage.receive(this);
                        handler.freeValue(this, freeMsg.getIds());
                        continue block10;
                    }
                    case RETURN: {
                        return BrowserChannel.ReturnMessage.receive(this);
                    }
                    case INVOKE: {
                        BrowserChannel.InvokeOnServerMessage imsg = BrowserChannel.InvokeOnServerMessage.receive(this);
                        BrowserChannel.SessionHandler.ExceptionOrReturnValue result = handler.invoke(this, imsg.getThis(), imsg.getMethodDispatchId(), imsg.getArgs());
                        this.sendFreedValues();
                        BrowserChannel.ReturnMessage.send(this, result);
                        continue block10;
                    }
                    case INVOKE_SPECIAL: {
                        this.handleInvokeSpecial(handler);
                        continue block10;
                    }
                    case QUIT: {
                        throw new BrowserChannel.RemoteDeathError(null);
                    }
                }
                break;
            }
            throw new BrowserChannelException("Invalid message type " + (Object)((Object)messageType) + " received waiting for return.");
        }
        catch (IOException e) {
            throw new BrowserChannel.RemoteDeathError(e);
        }
        catch (BrowserChannelException e) {
            throw new BrowserChannel.RemoteDeathError(e);
        }
    }

    @Override
    public void run() {
        try {
            this.processConnection();
        }
        catch (IOException e) {
            this.logger.log(TreeLogger.WARN, "Client connection lost", e);
        }
        catch (BrowserChannelException e) {
            this.logger.log(TreeLogger.ERROR, "Unrecognized command for client; closing connection", e);
        }
        finally {
            try {
                this.shutdown();
            }
            catch (IOException e) {}
            this.endSession();
        }
    }

    public void shutdown() throws IOException {
        this.getDashboardNotifier().devModeSessionEnd(this.devModeSession);
        BrowserChannel.QuitMessage.send(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processConnection() throws IOException, BrowserChannelException {
        Object oldLoadModule;
        BrowserChannel.MessageType type = BrowserChannel.Message.readMessageType(this.getStreamFromOtherSide());
        String url = null;
        String tabKey = null;
        String sessionKey = null;
        byte[] iconBytes = null;
        switch (type) {
            case OLD_LOAD_MODULE: {
                oldLoadModule = BrowserChannel.OldLoadModuleMessage.receive(this);
                if (((BrowserChannel.OldLoadModuleMessage)oldLoadModule).getProtoVersion() != 1) {
                    throw new BrowserChannelException("Old LoadModule message used, but not v1 protocol");
                }
                this.moduleName = ((BrowserChannel.OldLoadModuleMessage)oldLoadModule).getModuleName();
                this.userAgent = ((BrowserChannel.OldLoadModuleMessage)oldLoadModule).getUserAgent();
                this.protocolVersion = 1;
                TreeLogger.HelpInfo helpInfo = new TreeLogger.HelpInfo(){

                    @Override
                    public String getAnchorText() {
                        return "UsingOOPHM wiki page";
                    }

                    @Override
                    public URL getURL() {
                        try {
                            return new URL("http://code.google.com/p/google-web-toolkit/wiki/UsingOOPHM");
                        }
                        catch (MalformedURLException e) {
                            return null;
                        }
                    }
                };
                this.logger.log(TreeLogger.WARN, "Connection from old browser plugin -- please upgrade to a later version for full functionality", null, helpInfo);
                break;
            }
            case CHECK_VERSIONS: {
                String connectError = null;
                BrowserChannel.CheckVersionsMessage hello = BrowserChannel.CheckVersionsMessage.receive(this);
                int minVersion = hello.getMinVersion();
                int maxVersion = hello.getMaxVersion();
                String hostedHtmlVersion = hello.getHostedHtmlVersion();
                if (minVersion > 3 || maxVersion < 2) {
                    connectError = "Client supported protocol version range " + minVersion + " - " + maxVersion + "; server " + 2 + " - " + 3;
                } else if (!HostedHtmlVersion.validHostedHtmlVersion(this.logger, hostedHtmlVersion)) {
                    new BrowserChannel.FatalErrorMessage(this, "Invalid hosted.html version - check log window").send();
                    return;
                }
                if (connectError != null) {
                    this.logger.log(TreeLogger.ERROR, "Connection error: " + connectError, null);
                    new BrowserChannel.FatalErrorMessage(this, connectError).send();
                    return;
                }
                this.protocolVersion = Math.min(3, maxVersion);
                new BrowserChannel.ProtocolVersionMessage(this, this.protocolVersion).send();
                type = BrowserChannel.Message.readMessageType(this.getStreamFromOtherSide());
                if (type == BrowserChannel.MessageType.CHOOSE_TRANSPORT) {
                    BrowserChannel.ChooseTransportMessage chooseTransport = BrowserChannel.ChooseTransportMessage.receive(this);
                    String transport = this.selectTransport(chooseTransport.getTransports());
                    String transportArgs = null;
                    if (transport != null) {
                        transportArgs = this.createTransport(transport);
                    }
                    new BrowserChannel.SwitchTransportMessage(this, transport, transportArgs).send();
                    type = BrowserChannel.Message.readMessageType(this.getStreamFromOtherSide());
                }
                if (type != BrowserChannel.MessageType.LOAD_MODULE) {
                    this.logger.log(TreeLogger.ERROR, "Unexpected message type " + (Object)((Object)type) + "; expecting LoadModule");
                    return;
                }
                BrowserChannel.LoadModuleMessage loadModule = BrowserChannel.LoadModuleMessage.receive(this);
                url = loadModule.getUrl();
                tabKey = loadModule.getTabKey();
                sessionKey = loadModule.getSessionKey();
                this.moduleName = loadModule.getModuleName();
                this.userAgent = loadModule.getUserAgent();
                break;
            }
            case REQUEST_PLUGIN: {
                this.logger.log(TreeLogger.ERROR, "Plugin download not supported yet");
                new BrowserChannel.FatalErrorMessage(this, "Plugin download not supported").send();
                return;
            }
            default: {
                this.logger.log(TreeLogger.ERROR, "Unexpected message type " + (Object)((Object)type) + "; expecting CheckVersions");
                return;
            }
        }
        if (this.protocolVersion >= 3) {
            oldLoadModule = cacheLock;
            synchronized (oldLoadModule) {
                if (iconCache.containsKey(this.userAgent)) {
                    iconBytes = iconCache.get(this.userAgent);
                } else {
                    BrowserChannel.RequestIconMessage.send(this);
                    type = BrowserChannel.Message.readMessageType(this.getStreamFromOtherSide());
                    if (type != BrowserChannel.MessageType.USER_AGENT_ICON) {
                        this.logger.log(TreeLogger.ERROR, "Unexpected message type " + (Object)((Object)type) + "; expecting UserAgentIcon");
                        return;
                    }
                    BrowserChannel.UserAgentIconMessage uaIconMessage = BrowserChannel.UserAgentIconMessage.receive(this);
                    iconBytes = uaIconMessage.getIconBytes();
                    iconCache.put(this.userAgent, iconBytes);
                }
            }
        }
        Thread.currentThread().setName("Code server for " + this.moduleName + " from " + this.userAgent + " on " + url + " @ " + sessionKey);
        this.createDevModeSession();
        this.logger = this.handler.loadModule(this, this.moduleName, this.userAgent, url, tabKey, sessionKey, iconBytes);
        if (this.logger == null) {
            try {
                BrowserChannel.Value errMsg = new BrowserChannel.Value();
                errMsg.setString("An error occurred loading the GWT module " + this.moduleName);
                BrowserChannel.ReturnMessage.send(this, true, errMsg);
                return;
            }
            catch (IOException e) {
                throw new BrowserChannel.RemoteDeathError(e);
            }
        }
        try {
            try {
                BrowserChannel.ReturnMessage.send(this, false, new BrowserChannel.Value());
            }
            catch (IOException e) {
                throw new BrowserChannel.RemoteDeathError(e);
            }
            this.reactToMessages(this.handler);
        }
        catch (BrowserChannel.RemoteDeathError e) {
            if (!this.ignoreRemoteDeath) {
                this.logger.log(TreeLogger.ERROR, e.getMessage(), e);
            }
        }
        finally {
            this.handler.unloadModule(this, this.moduleName);
        }
    }

    BrowserChannel.Value convertFromJsValue(ServerObjectsTable localObjects, JsValueOOPHM jsval) {
        BrowserChannel.Value value = new BrowserChannel.Value();
        if (jsval.isNull()) {
            value.setNull();
        } else if (jsval.isUndefined()) {
            value.setUndefined();
        } else if (jsval.isBoolean()) {
            value.setBoolean(jsval.getBoolean());
        } else if (jsval.isInt()) {
            value.setInt(jsval.getInt());
        } else if (jsval.isNumber()) {
            value.setDouble(jsval.getNumber());
        } else if (jsval.isString()) {
            value.setString(jsval.getString());
        } else if (jsval.isJavaScriptObject()) {
            value.setJsObject(jsval.getJavascriptObject());
        } else if (jsval.isWrappedJavaObject()) {
            assert (localObjects != null);
            JsValue.DispatchObject javaObj = jsval.getJavaObjectWrapper();
            value.setJavaObject(new BrowserChannel.JavaObjectRef(localObjects.add(javaObj)));
        } else if (jsval.isWrappedJavaFunction()) {
            assert (localObjects != null);
            value.setJavaObject(new BrowserChannel.JavaObjectRef(localObjects.add(jsval.getWrappedJavaFunction())));
        } else {
            throw new RuntimeException("Unknown JsValue type " + jsval);
        }
        return value;
    }

    void convertToJsValue(CompilingClassLoader ccl, ServerObjectsTable localObjects, BrowserChannel.Value val, JsValueOOPHM jsval) {
        switch (val.getType()) {
            case NULL: {
                jsval.setNull();
                break;
            }
            case BOOLEAN: {
                jsval.setBoolean(val.getBoolean());
                break;
            }
            case BYTE: {
                jsval.setByte(val.getByte());
                break;
            }
            case CHAR: {
                jsval.setChar(val.getChar());
                break;
            }
            case DOUBLE: {
                jsval.setDouble(val.getDouble());
                break;
            }
            case INT: {
                jsval.setInt(val.getInt());
                break;
            }
            case SHORT: {
                jsval.setShort(val.getShort());
                break;
            }
            case STRING: {
                jsval.setString(val.getString());
                break;
            }
            case UNDEFINED: {
                jsval.setUndefined();
                break;
            }
            case JS_OBJECT: {
                jsval.setJavascriptObject(val.getJsObject());
                break;
            }
            case JAVA_OBJECT: {
                assert (ccl != null && localObjects != null);
                jsval.setWrappedJavaObject(ccl, localObjects.get(val.getJavaObject().getRefid()));
            }
        }
    }

    DashboardNotifier getDashboardNotifier() {
        return DashboardNotifierFactory.getNotifier();
    }

    private void createDevModeSession() {
        this.devModeSession = new DevModeSession(this.moduleName, this.userAgent);
        DevModeSession.setSessionForCurrentThread(this.devModeSession);
        this.getDashboardNotifier().devModeSessionBegin(this.devModeSession);
    }

    private String createTransport(String transport) {
        throw new UnsupportedOperationException("No alternate transports supported");
    }

    private void handleInvokeSpecial(SessionHandlerServer handler) throws IOException, BrowserChannelException {
        BrowserChannel.InvokeSpecialMessage ismsg = BrowserChannel.InvokeSpecialMessage.receive(this);
        BrowserChannel.Value[] args = ismsg.getArgs();
        BrowserChannel.SessionHandler.ExceptionOrReturnValue retExc = null;
        switch (ismsg.getDispatchId()) {
            case GetProperty: {
                assert (args.length == 2);
                retExc = handler.getProperty(this, args[0].getInt(), args[1].getInt());
                break;
            }
            case SetProperty: {
                assert (args.length == 3);
                retExc = handler.setProperty(this, args[0].getInt(), args[1].getInt(), args[2]);
                break;
            }
            default: {
                throw new HostedModeException("Unexpected InvokeSpecial method " + (Object)((Object)ismsg.getDispatchId()));
            }
        }
        BrowserChannel.ReturnMessage.send(this, retExc);
    }

    private void init(TreeLogger initialLogger) {
        this.logger = initialLogger;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setName("Code server (initializing)");
        thread.start();
    }

    private String selectTransport(String[] transports) {
        return null;
    }

    private static class ServerObjectRefFactory
    implements BrowserChannel.ObjectRefFactory {
        private final RemoteObjectTable<BrowserChannel.JsObjectRef> remoteObjectTable = new RemoteObjectTable();

        @Override
        public BrowserChannel.JavaObjectRef getJavaObjectRef(int refId) {
            return new BrowserChannel.JavaObjectRef(refId);
        }

        @Override
        public BrowserChannel.JsObjectRef getJsObjectRef(int refId) {
            BrowserChannel.JsObjectRef objectRef = this.remoteObjectTable.getRemoteObjectRef(refId);
            if (objectRef == null) {
                objectRef = new BrowserChannel.JsObjectRef(refId);
                this.remoteObjectTable.putRemoteObjectRef(refId, objectRef);
            }
            return objectRef;
        }

        @Override
        public Set<Integer> getRefIdsForCleanup() {
            return this.remoteObjectTable.getRefIdsForCleanup();
        }
    }

    public static abstract class SessionHandlerServer
    extends BrowserChannel.SessionHandler<BrowserChannelServer> {
        public abstract BrowserChannel.SessionHandler.ExceptionOrReturnValue getProperty(BrowserChannelServer var1, int var2, int var3);

        public abstract BrowserChannel.SessionHandler.ExceptionOrReturnValue invoke(BrowserChannelServer var1, BrowserChannel.Value var2, int var3, BrowserChannel.Value[] var4);

        public abstract TreeLogger loadModule(BrowserChannelServer var1, String var2, String var3, String var4, String var5, String var6, byte[] var7);

        public abstract BrowserChannel.SessionHandler.ExceptionOrReturnValue setProperty(BrowserChannelServer var1, int var2, int var3, BrowserChannel.Value var4);

        public abstract void unloadModule(BrowserChannelServer var1, String var2);
    }
}

