/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.shell;

import com.google.gwt.dev.shell.BrowserChannelException;
import com.google.gwt.util.tools.Utility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Set;

public abstract class BrowserChannel {
    public static final int PROTOCOL_VERSION_CURRENT = 3;
    public static final int PROTOCOL_VERSION_OLDEST = 2;
    public static final int PROTOCOL_VERSION_GET_ICON = 3;
    public static final int SPECIAL_CLIENTMETHODS_OBJECT = 0;
    public static final int SPECIAL_SERVERMETHODS_OBJECT = 0;
    private final ObjectRefFactory objectRefFactory;
    private Socket socket;
    private final DataInputStream streamFromOtherSide;
    private final DataOutputStream streamToOtherSide;

    protected static JavaObjectRef getJavaObjectRef(int refId) {
        return new JavaObjectRef(refId);
    }

    protected static String readUtf8String(DataInputStream stream) throws IOException {
        int len = stream.readInt();
        byte[] data = new byte[len];
        stream.readFully(data);
        return new String(data, "UTF8");
    }

    protected static Value.ValueType readValueType(DataInputStream stream) throws IOException, BrowserChannelException {
        byte type = stream.readByte();
        Value.ValueType[] types = Value.ValueType.values();
        if (type < 0 || type >= types.length) {
            throw new BrowserChannelException("Invalid value type " + type);
        }
        return types[type];
    }

    protected static void writeJavaObject(DataOutputStream stream, JavaObjectRef value) throws IOException {
        stream.writeByte(Value.ValueType.JAVA_OBJECT.getTag());
        stream.writeInt(value.getRefid());
    }

    protected static void writeJsObject(DataOutputStream stream, JsObjectRef value) throws IOException {
        stream.writeByte(Value.ValueType.JS_OBJECT.getTag());
        stream.writeInt(value.getRefid());
    }

    protected static void writeNull(DataOutputStream stream) throws IOException {
        stream.writeByte(Value.ValueType.NULL.getTag());
    }

    protected static void writeTaggedBoolean(DataOutputStream stream, boolean value) throws IOException {
        stream.writeByte(Value.ValueType.BOOLEAN.getTag());
        stream.writeBoolean(value);
    }

    protected static void writeTaggedByte(DataOutputStream stream, byte value) throws IOException {
        stream.writeByte(Value.ValueType.BYTE.getTag());
        stream.writeByte(value);
    }

    protected static void writeTaggedChar(DataOutputStream stream, char value) throws IOException {
        stream.writeByte(Value.ValueType.CHAR.getTag());
        stream.writeChar(value);
    }

    protected static void writeTaggedDouble(DataOutputStream stream, double value) throws IOException {
        stream.writeByte(Value.ValueType.DOUBLE.getTag());
        stream.writeDouble(value);
    }

    protected static void writeTaggedInt(DataOutputStream stream, int value) throws IOException {
        stream.writeByte(Value.ValueType.INT.getTag());
        stream.writeInt(value);
    }

    protected static void writeTaggedShort(DataOutputStream stream, short value) throws IOException {
        stream.writeByte(Value.ValueType.SHORT.getTag());
        stream.writeShort(value);
    }

    protected static void writeTaggedString(DataOutputStream stream, String data) throws IOException {
        stream.writeByte(Value.ValueType.STRING.getTag());
        BrowserChannel.writeUtf8String(stream, data);
    }

    protected static void writeUtf8String(DataOutputStream stream, String data) throws IOException {
        try {
            byte[] bytes = data.getBytes("UTF8");
            stream.writeInt(bytes.length);
            stream.write(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    private static void writeUndefined(DataOutputStream stream) throws IOException {
        stream.writeByte(Value.ValueType.UNDEFINED.getTag());
    }

    public BrowserChannel(Socket socket, ObjectRefFactory objectRefFactory) throws IOException {
        this(new BufferedInputStream(socket.getInputStream()), new BufferedOutputStream(socket.getOutputStream()), objectRefFactory);
        this.socket = socket;
    }

    protected BrowserChannel(InputStream inputStream, OutputStream outputStream, ObjectRefFactory objectRefFactory) {
        this.streamFromOtherSide = new DataInputStream(inputStream);
        this.streamToOtherSide = new DataOutputStream(outputStream);
        this.socket = null;
        this.objectRefFactory = objectRefFactory;
    }

    public void endSession() {
        Utility.close(this.streamFromOtherSide);
        Utility.close(this.streamToOtherSide);
        Utility.close(this.socket);
    }

    public Set<Integer> getRefIdsForCleanup() {
        return this.objectRefFactory.getRefIdsForCleanup();
    }

    public String getRemoteEndpoint() {
        if (this.socket == null) {
            return "";
        }
        return this.socket.getInetAddress().getCanonicalHostName() + ":" + this.socket.getPort();
    }

    protected DataInputStream getStreamFromOtherSide() {
        return this.streamFromOtherSide;
    }

    protected DataOutputStream getStreamToOtherSide() {
        return this.streamToOtherSide;
    }

    protected Value readValue(DataInputStream stream) throws IOException {
        Value.ValueType tag;
        try {
            tag = BrowserChannel.readValueType(stream);
        }
        catch (BrowserChannelException e) {
            IOException ee = new IOException();
            ee.initCause(e);
            throw ee;
        }
        Value value = new Value();
        switch (tag) {
            case NULL: {
                value.setNull();
                break;
            }
            case UNDEFINED: {
                value.setUndefined();
                break;
            }
            case BOOLEAN: {
                value.setBoolean(stream.readByte() != 0);
                break;
            }
            case BYTE: {
                value.setByte(stream.readByte());
                break;
            }
            case CHAR: {
                value.setChar(stream.readChar());
                break;
            }
            case INT: {
                value.setInt(stream.readInt());
                break;
            }
            case DOUBLE: {
                value.setDouble(stream.readDouble());
                break;
            }
            case SHORT: {
                value.setShort(stream.readShort());
                break;
            }
            case STRING: {
                value.setString(BrowserChannel.readUtf8String(stream));
                break;
            }
            case JS_OBJECT: {
                value.setJsObject(this.objectRefFactory.getJsObjectRef(stream.readInt()));
                break;
            }
            case JAVA_OBJECT: {
                value.setJavaObject(this.objectRefFactory.getJavaObjectRef(stream.readInt()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)tag));
            }
        }
        return value;
    }

    protected void sendFreedValues() throws IOException {
        Set<Integer> freed = this.objectRefFactory.getRefIdsForCleanup();
        int n = freed.size();
        if (n > 0) {
            int[] ids = new int[n];
            int i = 0;
            for (Integer id : freed) {
                ids[i++] = id;
            }
            FreeMessage.send(this, ids);
        }
    }

    protected void writeValue(DataOutputStream stream, Value value) throws IOException {
        if (value.isNull()) {
            BrowserChannel.writeNull(stream);
        } else if (value.isUndefined()) {
            BrowserChannel.writeUndefined(stream);
        } else if (value.isJsObject()) {
            BrowserChannel.writeJsObject(stream, value.getJsObject());
        } else if (value.isJavaObject()) {
            BrowserChannel.writeJavaObject(stream, value.getJavaObject());
        } else if (value.isBoolean()) {
            BrowserChannel.writeTaggedBoolean(stream, value.getBoolean());
        } else if (value.isByte()) {
            BrowserChannel.writeTaggedByte(stream, value.getByte());
        } else if (value.isChar()) {
            BrowserChannel.writeTaggedChar(stream, value.getChar());
        } else if (value.isShort()) {
            BrowserChannel.writeTaggedShort(stream, value.getShort());
        } else if (value.isDouble()) {
            BrowserChannel.writeTaggedDouble(stream, value.getDouble());
        } else if (value.isInt()) {
            BrowserChannel.writeTaggedInt(stream, value.getInt());
        } else if (value.isString()) {
            BrowserChannel.writeTaggedString(stream, value.getString());
        } else {
            throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)value.getType()));
        }
    }

    protected static class UserAgentIconMessage
    extends Message {
        private byte[] iconBytes;

        public static UserAgentIconMessage receive(BrowserChannel channel) throws IOException {
            byte[] iconBytes = null;
            DataInputStream stream = channel.getStreamFromOtherSide();
            int len = stream.readInt();
            if (len > 0) {
                iconBytes = new byte[len];
                for (int i = 0; i < len; ++i) {
                    iconBytes[i] = stream.readByte();
                }
            }
            return new UserAgentIconMessage(channel, iconBytes);
        }

        public static void send(BrowserChannel channel, byte[] iconBytes) throws IOException {
            DataOutputStream stream = channel.getStreamToOtherSide();
            stream.writeByte(MessageType.USER_AGENT_ICON.getId());
            if (iconBytes == null) {
                stream.writeInt(0);
            } else {
                stream.writeInt(iconBytes.length);
                for (byte b : iconBytes) {
                    stream.writeByte(b);
                }
            }
            stream.flush();
        }

        public UserAgentIconMessage(BrowserChannel channel, byte[] iconBytes) {
            super(channel);
            this.iconBytes = iconBytes;
        }

        public byte[] getIconBytes() {
            return this.iconBytes;
        }

        @Override
        public void send() throws IOException {
            UserAgentIconMessage.send(this.getBrowserChannel(), this.iconBytes);
        }
    }

    protected static class SwitchTransportMessage
    extends Message {
        private final String transport;
        private final String transportArgs;

        public static SwitchTransportMessage receive(BrowserChannel channel) throws IOException {
            DataInputStream stream = channel.getStreamFromOtherSide();
            String transport = BrowserChannel.readUtf8String(stream);
            String transportArgs = BrowserChannel.readUtf8String(stream);
            return new SwitchTransportMessage(channel, transport, transportArgs);
        }

        public SwitchTransportMessage(BrowserChannel channel, String transport, String transportArgs) {
            super(channel);
            if (transport == null) {
                transport = "";
            }
            if (transportArgs == null) {
                transportArgs = "";
            }
            this.transport = transport;
            this.transportArgs = transportArgs;
        }

        public String getTransport() {
            return this.transport;
        }

        public String getTransportArgs() {
            return this.transportArgs;
        }

        @Override
        public void send() throws IOException {
            DataOutputStream stream = this.getBrowserChannel().getStreamToOtherSide();
            stream.writeByte(MessageType.SWITCH_TRANSPORT.getId());
            BrowserChannel.writeUtf8String(stream, this.transport);
            BrowserChannel.writeUtf8String(stream, this.transportArgs);
            stream.flush();
        }
    }

    protected static class ReturnMessage
    extends Message {
        private final boolean isException;
        private final Value returnValue;

        public static ReturnMessage receive(BrowserChannel channel) throws IOException {
            DataInputStream stream = channel.getStreamFromOtherSide();
            boolean isException = stream.readBoolean();
            Value returnValue = channel.readValue(stream);
            return new ReturnMessage(channel, isException, returnValue);
        }

        public static void send(BrowserChannel channel, boolean isException, Value returnValue) throws IOException {
            DataOutputStream stream = channel.getStreamToOtherSide();
            stream.writeByte(MessageType.RETURN.getId());
            stream.writeBoolean(isException);
            channel.writeValue(stream, returnValue);
            stream.flush();
        }

        public static void send(BrowserChannel channel, SessionHandler.ExceptionOrReturnValue returnOrException) throws IOException {
            ReturnMessage.send(channel, returnOrException.isException(), returnOrException.getReturnValue());
        }

        public ReturnMessage(BrowserChannel channel, boolean isException, Value returnValue) {
            super(channel);
            this.returnValue = returnValue;
            this.isException = isException;
        }

        public Value getReturnValue() {
            return this.returnValue;
        }

        public boolean isException() {
            return this.isException;
        }

        @Override
        public void send() throws IOException {
            ReturnMessage.send(this.getBrowserChannel(), this.isException, this.returnValue);
        }
    }

    protected static class RequestIconMessage
    extends Message {
        public static RequestIconMessage receive(BrowserChannel channel) throws IOException {
            return new RequestIconMessage(channel);
        }

        public static void send(BrowserChannel channel) throws IOException {
            DataOutputStream stream = channel.getStreamToOtherSide();
            stream.writeByte(MessageType.REQUEST_ICON.getId());
            stream.flush();
        }

        public RequestIconMessage(BrowserChannel channel) {
            super(channel);
        }

        @Override
        public void send() throws IOException {
            RequestIconMessage.send(this.getBrowserChannel());
        }
    }

    protected static class QuitMessage
    extends Message {
        public static QuitMessage receive(BrowserChannel channel) {
            return new QuitMessage(channel);
        }

        public static void send(BrowserChannel channel) throws IOException {
            DataOutputStream stream = channel.getStreamToOtherSide();
            stream.writeByte(MessageType.QUIT.getId());
            stream.flush();
        }

        public QuitMessage(BrowserChannel channel) {
            super(channel);
        }

        @Override
        public void send() throws IOException {
            QuitMessage.send(this.getBrowserChannel());
        }
    }

    protected static class ProtocolVersionMessage
    extends Message {
        private final int protocolVersion;

        public static ProtocolVersionMessage receive(BrowserChannel channel) throws IOException {
            DataInputStream stream = channel.getStreamFromOtherSide();
            int protocolVersion = stream.readInt();
            return new ProtocolVersionMessage(channel, protocolVersion);
        }

        public ProtocolVersionMessage(BrowserChannel channel, int protocolVersion) {
            super(channel);
            this.protocolVersion = protocolVersion;
        }

        public int getProtocolVersion() {
            return this.protocolVersion;
        }

        @Override
        public void send() throws IOException {
            DataOutputStream stream = this.getBrowserChannel().getStreamToOtherSide();
            stream.writeByte(MessageType.PROTOCOL_VERSION.getId());
            stream.writeInt(this.protocolVersion);
            stream.flush();
        }
    }

    protected static class OldLoadModuleMessage
    extends Message {
        private final String moduleName;
        private final int protoVersion;
        private final String userAgent;

        public static OldLoadModuleMessage receive(BrowserChannel channel) throws IOException {
            DataInputStream stream = channel.getStreamFromOtherSide();
            int protoVersion = stream.readInt();
            String moduleName = BrowserChannel.readUtf8String(stream);
            String userAgent = BrowserChannel.readUtf8String(stream);
            return new OldLoadModuleMessage(channel, protoVersion, moduleName, userAgent);
        }

        public OldLoadModuleMessage(BrowserChannel channel, int protoVersion, String moduleName, String userAgent) {
            super(channel);
            this.protoVersion = protoVersion;
            this.moduleName = moduleName;
            this.userAgent = userAgent;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public int getProtoVersion() {
            return this.protoVersion;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        @Override
        public void send() throws IOException {
            DataOutputStream stream = this.getBrowserChannel().getStreamToOtherSide();
            stream.writeByte(MessageType.OLD_LOAD_MODULE.getId());
            stream.writeInt(this.protoVersion);
            BrowserChannel.writeUtf8String(stream, this.moduleName);
            BrowserChannel.writeUtf8String(stream, this.userAgent);
            stream.flush();
        }
    }

    protected static interface ObjectRefFactory {
        public JavaObjectRef getJavaObjectRef(int var1);

        public JsObjectRef getJsObjectRef(int var1);

        public Set<Integer> getRefIdsForCleanup();
    }

    protected static abstract class Message {
        private final BrowserChannel channel;

        public static MessageType readMessageType(DataInputStream stream) throws IOException, BrowserChannelException {
            stream.mark(1);
            byte type = stream.readByte();
            MessageType[] types = MessageType.values();
            if (type < 0 || type >= types.length) {
                stream.reset();
                throw new BrowserChannelException("Invalid message type " + type);
            }
            return types[type];
        }

        public Message(BrowserChannel channel) {
            this.channel = channel;
        }

        public final BrowserChannel getBrowserChannel() {
            return this.channel;
        }

        public boolean isAsynchronous() {
            return false;
        }

        public void send() throws IOException {
            throw new UnsupportedOperationException(this.getClass().getName() + " is a message format that can only be received.");
        }
    }

    protected static class LoadModuleMessage
    extends Message {
        private final String moduleName;
        private final String sessionKey;
        private final String tabKey;
        private final String url;
        private final String userAgent;

        public static LoadModuleMessage receive(BrowserChannel channel) throws IOException {
            DataInputStream stream = channel.getStreamFromOtherSide();
            String url = BrowserChannel.readUtf8String(stream);
            String tabKey = BrowserChannel.readUtf8String(stream);
            String sessionKey = BrowserChannel.readUtf8String(stream);
            String moduleName = BrowserChannel.readUtf8String(stream);
            String userAgent = BrowserChannel.readUtf8String(stream);
            return new LoadModuleMessage(channel, url, tabKey, sessionKey, moduleName, userAgent);
        }

        public LoadModuleMessage(BrowserChannel channel, String url, String tabKey, String sessionKey, String moduleName, String userAgent) {
            super(channel);
            assert (url != null);
            assert (tabKey != null);
            assert (sessionKey != null);
            assert (moduleName != null);
            assert (userAgent != null);
            this.url = url;
            this.tabKey = tabKey;
            this.sessionKey = sessionKey;
            this.moduleName = moduleName;
            this.userAgent = userAgent;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getSessionKey() {
            return this.sessionKey;
        }

        public String getTabKey() {
            return this.tabKey;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        @Override
        public void send() throws IOException {
            DataOutputStream stream = this.getBrowserChannel().getStreamToOtherSide();
            stream.writeByte(MessageType.LOAD_MODULE.getId());
            BrowserChannel.writeUtf8String(stream, this.url);
            BrowserChannel.writeUtf8String(stream, this.tabKey);
            BrowserChannel.writeUtf8String(stream, this.sessionKey);
            BrowserChannel.writeUtf8String(stream, this.moduleName);
            BrowserChannel.writeUtf8String(stream, this.userAgent);
            stream.flush();
        }
    }

    protected static class LoadJsniMessage
    extends Message {
        private final String js;

        public static LoadJsniMessage receive(BrowserChannel channel) throws IOException {
            DataInputStream stream = channel.getStreamFromOtherSide();
            String js = BrowserChannel.readUtf8String(stream);
            return new LoadJsniMessage(channel, js);
        }

        public static void send(BrowserChannel channel, String js) throws IOException {
            DataOutputStream stream = channel.getStreamToOtherSide();
            stream.write(MessageType.LOAD_JSNI.getId());
            BrowserChannel.writeUtf8String(stream, js);
            stream.flush();
        }

        public LoadJsniMessage(BrowserChannel channel, String js) {
            super(channel);
            this.js = js;
        }

        public String getJsni() {
            return this.js;
        }

        @Override
        public boolean isAsynchronous() {
            return true;
        }

        @Override
        public void send() throws IOException {
            LoadJsniMessage.send(this.getBrowserChannel(), this.js);
        }
    }

    protected static class InvokeSpecialMessage
    extends Message {
        private final Value[] args;
        private final SessionHandler.SpecialDispatchId dispatchId;

        public static InvokeSpecialMessage receive(BrowserChannel channel) throws IOException, BrowserChannelException {
            DataInputStream stream = channel.getStreamFromOtherSide();
            byte specialMethodInt = stream.readByte();
            SessionHandler.SpecialDispatchId[] ids = SessionHandler.SpecialDispatchId.values();
            if (specialMethodInt < 0 || specialMethodInt >= ids.length) {
                throw new BrowserChannelException("Invalid dispatch id " + specialMethodInt);
            }
            SessionHandler.SpecialDispatchId dispatchId = ids[specialMethodInt];
            int argLen = stream.readInt();
            Value[] args = new Value[argLen];
            for (int i = 0; i < argLen; ++i) {
                args[i] = channel.readValue(stream);
            }
            return new InvokeSpecialMessage(channel, dispatchId, args);
        }

        public InvokeSpecialMessage(BrowserChannel channel, SessionHandler.SpecialDispatchId dispatchId, Value[] args) {
            super(channel);
            this.dispatchId = dispatchId;
            this.args = args;
        }

        public Value[] getArgs() {
            return this.args;
        }

        public SessionHandler.SpecialDispatchId getDispatchId() {
            return this.dispatchId;
        }

        @Override
        public void send() throws IOException {
            DataOutputStream stream = this.getBrowserChannel().getStreamToOtherSide();
            stream.writeByte(MessageType.INVOKE_SPECIAL.getId());
            stream.writeByte(this.dispatchId.getId());
            stream.writeInt(this.args.length);
            for (int i = 0; i < this.args.length; ++i) {
                this.getBrowserChannel().writeValue(stream, this.args[i]);
            }
            stream.flush();
        }
    }

    protected static class InvokeOnServerMessage
    extends Message {
        private final Value[] args;
        private final int methodDispatchId;
        private final Value thisRef;

        public static InvokeOnServerMessage receive(BrowserChannel channel) throws IOException {
            DataInputStream stream = channel.getStreamFromOtherSide();
            int methodDispatchId = stream.readInt();
            Value thisRef = channel.readValue(stream);
            int argLen = stream.readInt();
            Value[] args = new Value[argLen];
            for (int i = 0; i < argLen; ++i) {
                args[i] = channel.readValue(stream);
            }
            return new InvokeOnServerMessage(channel, methodDispatchId, thisRef, args);
        }

        public InvokeOnServerMessage(BrowserChannel channel, int methodDispatchId, Value thisRef, Value[] args) {
            super(channel);
            this.thisRef = thisRef;
            this.methodDispatchId = methodDispatchId;
            this.args = args;
        }

        public Value[] getArgs() {
            return this.args;
        }

        public int getMethodDispatchId() {
            return this.methodDispatchId;
        }

        public Value getThis() {
            return this.thisRef;
        }

        @Override
        public void send() throws IOException {
            DataOutputStream stream = this.getBrowserChannel().getStreamToOtherSide();
            stream.writeByte(MessageType.INVOKE.getId());
            stream.writeInt(this.methodDispatchId);
            this.getBrowserChannel().writeValue(stream, this.thisRef);
            stream.writeInt(this.args.length);
            for (int i = 0; i < this.args.length; ++i) {
                this.getBrowserChannel().writeValue(stream, this.args[i]);
            }
            stream.flush();
        }
    }

    protected static class InvokeOnClientMessage
    extends Message {
        private final Value[] args;
        private final String methodName;
        private final Value thisRef;

        public static InvokeOnClientMessage receive(BrowserChannel channel) throws IOException {
            DataInputStream stream = channel.getStreamFromOtherSide();
            String methodName = BrowserChannel.readUtf8String(stream);
            Value thisRef = channel.readValue(stream);
            int argLen = stream.readInt();
            Value[] args = new Value[argLen];
            for (int i = 0; i < argLen; ++i) {
                args[i] = channel.readValue(stream);
            }
            return new InvokeOnClientMessage(channel, methodName, thisRef, args);
        }

        public InvokeOnClientMessage(BrowserChannel channel, String methodName, Value thisRef, Value[] args) {
            super(channel);
            this.thisRef = thisRef;
            this.methodName = methodName;
            this.args = args;
        }

        public Value[] getArgs() {
            return this.args;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Value getThis() {
            return this.thisRef;
        }

        @Override
        public void send() throws IOException {
            DataOutputStream stream = this.getBrowserChannel().getStreamToOtherSide();
            stream.writeByte(MessageType.INVOKE.getId());
            BrowserChannel.writeUtf8String(stream, this.methodName);
            this.getBrowserChannel().writeValue(stream, this.thisRef);
            stream.writeInt(this.args.length);
            for (int i = 0; i < this.args.length; ++i) {
                this.getBrowserChannel().writeValue(stream, this.args[i]);
            }
            stream.flush();
        }
    }

    protected static class FreeMessage
    extends Message {
        private final int[] ids;

        public static FreeMessage receive(BrowserChannel channel) throws IOException {
            DataInputStream stream = channel.getStreamFromOtherSide();
            int numIds = stream.readInt();
            int[] ids = new int[numIds];
            for (int i = 0; i < numIds; ++i) {
                ids[i] = stream.readInt();
            }
            return new FreeMessage(channel, ids);
        }

        public static void send(BrowserChannel channel, int[] ids) throws IOException {
            DataOutputStream stream = channel.getStreamToOtherSide();
            stream.writeByte(MessageType.FREE_VALUE.getId());
            stream.writeInt(ids.length);
            for (int id : ids) {
                stream.writeInt(id);
            }
            stream.flush();
        }

        public FreeMessage(BrowserChannel channel, int[] ids) {
            super(channel);
            this.ids = ids;
        }

        public int[] getIds() {
            return this.ids;
        }

        @Override
        public boolean isAsynchronous() {
            return true;
        }

        @Override
        public void send() throws IOException {
            FreeMessage.send(this.getBrowserChannel(), this.ids);
        }
    }

    protected static class FatalErrorMessage
    extends Message {
        private final String error;

        public static FatalErrorMessage receive(BrowserChannel channel) throws IOException {
            DataInputStream stream = channel.getStreamFromOtherSide();
            String error = BrowserChannel.readUtf8String(stream);
            return new FatalErrorMessage(channel, error);
        }

        public FatalErrorMessage(BrowserChannel channel, String error) {
            super(channel);
            this.error = error;
        }

        public String getError() {
            return this.error;
        }

        @Override
        public void send() throws IOException {
            DataOutputStream stream = this.getBrowserChannel().getStreamToOtherSide();
            stream.writeByte(MessageType.FATAL_ERROR.getId());
            BrowserChannel.writeUtf8String(stream, this.error);
        }
    }

    protected static class ChooseTransportMessage
    extends Message {
        private final String[] transports;

        public static ChooseTransportMessage receive(BrowserChannel channel) throws IOException {
            DataInputStream stream = channel.getStreamFromOtherSide();
            int n = stream.readInt();
            String[] transports = new String[n];
            for (int i = 0; i < n; ++i) {
                transports[i] = BrowserChannel.readUtf8String(stream);
            }
            return new ChooseTransportMessage(channel, transports);
        }

        public ChooseTransportMessage(BrowserChannel channel, String[] transports) {
            super(channel);
            this.transports = transports;
        }

        public String[] getTransports() {
            return this.transports;
        }

        @Override
        public void send() throws IOException {
            DataOutputStream stream = this.getBrowserChannel().getStreamToOtherSide();
            stream.writeByte(MessageType.CHOOSE_TRANSPORT.getId());
            stream.writeInt(this.transports.length);
            for (String transport : this.transports) {
                BrowserChannel.writeUtf8String(stream, transport);
            }
        }
    }

    protected static class CheckVersionsMessage
    extends Message {
        private final String hostedHtmlVersion;
        private final int maxVersion;
        private final int minVersion;

        public static CheckVersionsMessage receive(BrowserChannel channel) throws IOException {
            DataInputStream stream = channel.getStreamFromOtherSide();
            int minVersion = stream.readInt();
            int maxVersion = stream.readInt();
            String hostedHtmlVersion = BrowserChannel.readUtf8String(stream);
            return new CheckVersionsMessage(channel, minVersion, maxVersion, hostedHtmlVersion);
        }

        public CheckVersionsMessage(BrowserChannel channel, int minVersion, int maxVersion, String hostedHtmlVersion) {
            super(channel);
            this.minVersion = minVersion;
            this.maxVersion = maxVersion;
            this.hostedHtmlVersion = hostedHtmlVersion;
        }

        public String getHostedHtmlVersion() {
            return this.hostedHtmlVersion;
        }

        public int getMaxVersion() {
            return this.maxVersion;
        }

        public int getMinVersion() {
            return this.minVersion;
        }

        @Override
        public void send() throws IOException {
            DataOutputStream stream = this.getBrowserChannel().getStreamToOtherSide();
            stream.writeByte(MessageType.CHECK_VERSIONS.getId());
            stream.writeInt(this.minVersion);
            stream.writeInt(this.maxVersion);
            BrowserChannel.writeUtf8String(stream, this.hostedHtmlVersion);
            stream.flush();
        }
    }

    public static class Value {
        private ValueType type = ValueType.UNDEFINED;
        private Object value = null;

        public Value() {
        }

        public Value(Object obj) {
            this.convertFromJavaValue(obj);
        }

        public void convertFromJavaValue(Object obj) {
            if (obj == null) {
                this.type = ValueType.NULL;
            } else if (obj instanceof Boolean) {
                this.type = ValueType.BOOLEAN;
            } else if (obj instanceof Byte) {
                this.type = ValueType.BYTE;
            } else if (obj instanceof Character) {
                this.type = ValueType.CHAR;
            } else if (obj instanceof Double) {
                this.type = ValueType.DOUBLE;
            } else if (obj instanceof Integer) {
                this.type = ValueType.INT;
            } else if (obj instanceof Short) {
                this.type = ValueType.SHORT;
            } else if (obj instanceof String) {
                this.type = ValueType.STRING;
            } else if (obj instanceof JsObjectRef) {
                this.type = ValueType.JS_OBJECT;
            } else if (obj instanceof JavaObjectRef) {
                this.type = ValueType.JAVA_OBJECT;
            } else {
                throw new IllegalArgumentException("Unexpected type: " + obj.getClass());
            }
            this.value = obj;
        }

        public boolean getBoolean() {
            assert (this.type == ValueType.BOOLEAN);
            return (Boolean)this.value;
        }

        public byte getByte() {
            assert (this.type == ValueType.BYTE);
            return (Byte)this.value;
        }

        public char getChar() {
            assert (this.type == ValueType.CHAR);
            return ((Character)this.value).charValue();
        }

        public double getDouble() {
            assert (this.type == ValueType.DOUBLE);
            return (Double)this.value;
        }

        public int getInt() {
            assert (this.type == ValueType.INT);
            return (Integer)this.value;
        }

        public JavaObjectRef getJavaObject() {
            assert (this.type == ValueType.JAVA_OBJECT);
            return (JavaObjectRef)this.value;
        }

        public JsObjectRef getJsObject() {
            assert (this.type == ValueType.JS_OBJECT);
            return (JsObjectRef)this.value;
        }

        public short getShort() {
            assert (this.type == ValueType.SHORT);
            return (Short)this.value;
        }

        public String getString() {
            assert (this.type == ValueType.STRING);
            return (String)this.value;
        }

        public ValueType getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isBoolean() {
            return this.type == ValueType.BOOLEAN;
        }

        public boolean isByte() {
            return this.type == ValueType.BYTE;
        }

        public boolean isChar() {
            return this.type == ValueType.CHAR;
        }

        public boolean isDouble() {
            return this.type == ValueType.DOUBLE;
        }

        public boolean isInt() {
            return this.type == ValueType.INT;
        }

        public boolean isJavaObject() {
            return this.type == ValueType.JAVA_OBJECT;
        }

        public boolean isJsObject() {
            return this.type == ValueType.JS_OBJECT;
        }

        public boolean isNull() {
            return this.type == ValueType.NULL;
        }

        public boolean isNumber() {
            switch (this.type) {
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case INT: 
                case SHORT: {
                    return true;
                }
            }
            return false;
        }

        public boolean isPrimitive() {
            switch (this.type) {
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case INT: 
                case SHORT: 
                case BOOLEAN: {
                    return true;
                }
            }
            return false;
        }

        public boolean isShort() {
            return this.type == ValueType.SHORT;
        }

        public boolean isString() {
            return this.type == ValueType.STRING;
        }

        public boolean isUndefined() {
            return this.type == ValueType.UNDEFINED;
        }

        public void setBoolean(boolean val) {
            this.type = ValueType.BOOLEAN;
            this.value = val;
        }

        public void setByte(byte val) {
            this.type = ValueType.BYTE;
            this.value = val;
        }

        public void setChar(char val) {
            this.type = ValueType.CHAR;
            this.value = Character.valueOf(val);
        }

        public void setDouble(double val) {
            this.type = ValueType.DOUBLE;
            this.value = val;
        }

        public void setInt(int val) {
            this.type = ValueType.INT;
            this.value = val;
        }

        public void setJavaObject(JavaObjectRef val) {
            this.type = ValueType.JAVA_OBJECT;
            this.value = val;
        }

        public void setJsObject(JsObjectRef val) {
            this.type = ValueType.JS_OBJECT;
            this.value = val;
        }

        public void setLong(long val) {
            this.type = ValueType.BOOLEAN;
            this.value = val;
        }

        public void setNull() {
            this.type = ValueType.NULL;
            this.value = null;
        }

        public void setShort(short val) {
            this.type = ValueType.SHORT;
            this.value = val;
        }

        public void setString(String val) {
            this.type = ValueType.STRING;
            this.value = val;
        }

        public void setUndefined() {
            this.type = ValueType.UNDEFINED;
            this.value = null;
        }

        public String toString() {
            return (Object)((Object)this.type) + ": " + this.value;
        }

        public static enum ValueType {
            NULL(0),
            BOOLEAN(1),
            BYTE(2),
            CHAR(3),
            SHORT(4),
            INT(5),
            LONG_UNUSED(6),
            FLOAT_UNUSED(7),
            DOUBLE(8),
            STRING(9),
            JAVA_OBJECT(10),
            JS_OBJECT(11),
            UNDEFINED(12);

            private final int id;

            private ValueType(int id) {
                this.id = id;
            }

            byte getTag() {
                return (byte)this.id;
            }
        }
    }

    public static abstract class SessionHandler<T extends BrowserChannel> {
        public abstract void freeValue(T var1, int[] var2);

        public static enum SpecialDispatchId {
            HasMethod(0),
            HasProperty(1),
            GetProperty(2),
            SetProperty(3);

            private final int id;

            private SpecialDispatchId(int id) {
                this.id = id;
            }

            public int getId() {
                return this.id;
            }
        }

        public static class ExceptionOrReturnValue {
            private final boolean isException;
            private final Value returnValue;

            public ExceptionOrReturnValue(boolean isException, Value returnValue) {
                this.isException = isException;
                this.returnValue = returnValue;
            }

            public Value getReturnValue() {
                return this.returnValue;
            }

            public boolean isException() {
                return this.isException;
            }
        }
    }

    public static interface RemoteObjectRef {
        public int getRefid();
    }

    public static enum MessageType {
        INVOKE(0),
        RETURN(1),
        OLD_LOAD_MODULE(2),
        QUIT(3),
        LOAD_JSNI(4),
        INVOKE_SPECIAL(5),
        FREE_VALUE(6),
        FATAL_ERROR(7),
        CHECK_VERSIONS(8),
        PROTOCOL_VERSION(9),
        CHOOSE_TRANSPORT(10),
        SWITCH_TRANSPORT(11),
        LOAD_MODULE(12),
        REQUEST_ICON(13),
        USER_AGENT_ICON(14),
        REQUEST_PLUGIN(15);

        private final int id;

        private MessageType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    public static class JsObjectRef
    implements RemoteObjectRef {
        private int refId;

        public JsObjectRef(int refId) {
            this.refId = refId;
        }

        public boolean equals(Object o) {
            return o instanceof JsObjectRef && ((JsObjectRef)o).refId == this.refId;
        }

        @Override
        public int getRefid() {
            return Math.abs(this.refId);
        }

        public int hashCode() {
            return this.refId;
        }

        public boolean isException() {
            return this.refId < 0;
        }

        public String toString() {
            return "JsObjectRef(" + this.refId + ")";
        }
    }

    public static class JavaObjectRef
    implements RemoteObjectRef {
        private int refId;

        public JavaObjectRef(int refId) {
            this.refId = refId;
        }

        @Override
        public int getRefid() {
            return Math.abs(this.refId);
        }

        public int hashCode() {
            return this.refId;
        }

        public boolean isException() {
            return this.refId < 0;
        }

        public String toString() {
            return "JavaObjectRef(ref=" + this.refId + ")";
        }
    }

    public static class RemoteDeathError
    extends Error {
        public RemoteDeathError(Throwable cause) {
            super("Remote connection lost", cause);
        }
    }
}

