/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.resource.impl;

import com.google.gwt.dev.resource.impl.AbstractResource;
import com.google.gwt.dev.resource.impl.ZipFileClassPathEntry;
import com.google.gwt.dev.util.StringInterner;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;

public class ZipFileResource
extends AbstractResource {
    private ZipFileClassPathEntry classPathEntry;
    private final String entryName;
    private String filePath;
    private final long lastModified;
    private final String[] pathParts;
    private final ZipFile zipFile;

    public ZipFileResource(ZipFileClassPathEntry classPathEntry, String entryName) {
        this.classPathEntry = classPathEntry;
        this.entryName = StringInterner.get().intern(entryName);
        this.pathParts = entryName.split("/");
        this.zipFile = classPathEntry.getZipFile();
        this.filePath = classPathEntry.getLocation();
        assert (this.filePath.startsWith("file:/"));
        this.lastModified = classPathEntry.lastModified();
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getLocation() {
        return "jar:" + this.filePath + "!/" + this.entryName;
    }

    @Override
    public String getPath() {
        return this.entryName;
    }

    public String[] getPathParts() {
        return this.pathParts;
    }

    @Override
    public InputStream openContents() throws IOException {
        return this.zipFile.getInputStream(this.zipFile.getEntry(this.entryName));
    }
}

