/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.resource.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.resource.impl.AbstractResource;
import com.google.gwt.dev.resource.impl.ClassPathEntry;
import com.google.gwt.dev.resource.impl.PathPrefixSet;
import com.google.gwt.dev.resource.impl.ResourceResolution;
import com.google.gwt.dev.resource.impl.ZipFileResource;
import com.google.gwt.dev.util.collect.IdentityHashMap;
import com.google.gwt.dev.util.collect.IdentityHashSet;
import com.google.gwt.dev.util.collect.IdentityMaps;
import com.google.gwt.dev.util.collect.Sets;
import com.google.gwt.dev.util.msg.Message1String;
import com.google.gwt.thirdparty.guava.common.collect.MapMaker;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileClassPathEntry
extends ClassPathEntry {
    private static final Map<String, ZipFileClassPathEntry> entryCache = Maps.newHashMap();
    private Set<ZipFileResource> allZipFileResources;
    private final Map<PathPrefixSet, ZipFileSnapshot> cachedSnapshots = new MapMaker().weakKeys().makeMap();
    private final long lastModified;
    private final String location;
    private final ZipFile zipFile;

    public static void clearCache() {
        entryCache.clear();
    }

    public static synchronized ZipFileClassPathEntry get(File zipFile) throws IOException {
        String location = zipFile.toURI().toString();
        ZipFileClassPathEntry entry = entryCache.get(location);
        if (entry == null) {
            entry = new ZipFileClassPathEntry(zipFile);
            entryCache.put(location, entry);
        }
        return entry;
    }

    private ZipFileClassPathEntry(File zipFile) throws IOException {
        assert (zipFile.isAbsolute());
        this.lastModified = zipFile.lastModified();
        this.zipFile = new ZipFile(zipFile);
        this.location = zipFile.toURI().toString();
    }

    @Override
    public synchronized Map<AbstractResource, ResourceResolution> findApplicableResources(TreeLogger logger, PathPrefixSet pathPrefixSet) {
        this.index(logger);
        ZipFileSnapshot snapshot = this.cachedSnapshots.get(pathPrefixSet);
        if (snapshot == null || snapshot.prefixSetSize != pathPrefixSet.getSize()) {
            snapshot = new ZipFileSnapshot(pathPrefixSet.getSize(), this.computeApplicableResources(logger, pathPrefixSet));
            this.cachedSnapshots.put(pathPrefixSet, snapshot);
        }
        return snapshot.cachedAnswers;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public long lastModified() {
        return this.lastModified;
    }

    synchronized void index(TreeLogger logger) {
        if (this.allZipFileResources == null) {
            this.allZipFileResources = this.buildIndex(logger);
        }
    }

    private Set<ZipFileResource> buildIndex(TreeLogger logger) {
        logger = Messages.BUILDING_INDEX.branch(logger, this.zipFile.getName(), null);
        IdentityHashSet<ZipFileResource> results = new IdentityHashSet<ZipFileResource>();
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry zipEntry = e.nextElement();
            if (zipEntry.isDirectory() || zipEntry.getName().startsWith("META-INF/")) continue;
            ZipFileResource zipResource = new ZipFileResource(this, zipEntry.getName());
            results.add(zipResource);
            Messages.READ_ZIP_ENTRY.log(logger, zipEntry.getName(), null);
        }
        return Sets.normalize(results);
    }

    private Map<AbstractResource, ResourceResolution> computeApplicableResources(TreeLogger logger, PathPrefixSet pathPrefixSet) {
        logger = Messages.FINDING_INCLUDED_RESOURCES.branch(logger, this.zipFile.getName(), null);
        IdentityHashMap<ZipFileResource, ResourceResolution> results = new IdentityHashMap<ZipFileResource, ResourceResolution>();
        for (ZipFileResource r : this.allZipFileResources) {
            String path = r.getPath();
            String[] pathParts = r.getPathParts();
            ResourceResolution resourceResolution = null;
            resourceResolution = pathPrefixSet.includesResource(path, pathParts);
            if (resourceResolution != null) {
                Messages.INCLUDING_RESOURCE.log(logger, path, null);
                results.put(r, resourceResolution);
                continue;
            }
            Messages.EXCLUDING_RESOURCE.log(logger, path, null);
        }
        return IdentityMaps.normalize(results);
    }

    private static class ZipFileSnapshot {
        private final Map<AbstractResource, ResourceResolution> cachedAnswers;
        private final int prefixSetSize;

        ZipFileSnapshot(int prefixSetSize, Map<AbstractResource, ResourceResolution> cachedAnswers) {
            this.prefixSetSize = prefixSetSize;
            this.cachedAnswers = cachedAnswers;
        }
    }

    private static class Messages {
        static final Message1String BUILDING_INDEX = new Message1String(TreeLogger.TRACE, "Indexing zip file: $0");
        static final Message1String EXCLUDING_RESOURCE = new Message1String(TreeLogger.DEBUG, "Excluding $0");
        static final Message1String FINDING_INCLUDED_RESOURCES = new Message1String(TreeLogger.DEBUG, "Searching for included resources in $0");
        static final Message1String INCLUDING_RESOURCE = new Message1String(TreeLogger.DEBUG, "Including $0");
        static final Message1String READ_ZIP_ENTRY = new Message1String(TreeLogger.DEBUG, "$0");

        private Messages() {
        }
    }
}

