/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.resource.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.cfg.ResourceLoader;
import com.google.gwt.dev.cfg.ResourceLoaders;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.resource.impl.AbstractResource;
import com.google.gwt.dev.resource.impl.AbstractResourceOracle;
import com.google.gwt.dev.resource.impl.ClassPathEntry;
import com.google.gwt.dev.resource.impl.DirectoryClassPathEntry;
import com.google.gwt.dev.resource.impl.PathPrefix;
import com.google.gwt.dev.resource.impl.PathPrefixSet;
import com.google.gwt.dev.resource.impl.ResourceResolution;
import com.google.gwt.dev.resource.impl.ZipFileClassPathEntry;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.dev.util.msg.Message0;
import com.google.gwt.dev.util.msg.Message1String;
import com.google.gwt.thirdparty.guava.common.collect.HashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.MapMaker;
import com.google.gwt.thirdparty.guava.common.collect.SetMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.guava.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ResourceOracleImpl
extends AbstractResourceOracle {
    private static final Map<ResourceLoader, List<ClassPathEntry>> classPathCache = new MapMaker().weakKeys().makeMap();
    private SetMultimap<String, String> sourceModulesByTypeSourceName = HashMultimap.create();
    private final List<ClassPathEntry> classPathEntries;
    private Set<String> exposedPathNames = Collections.emptySet();
    private Map<String, Resource> exposedResourceMap = Collections.emptyMap();
    private Set<Resource> exposedResources = Collections.emptySet();
    private PathPrefixSet pathPrefixSet = new PathPrefixSet();

    public static void clearCache() {
        classPathCache.clear();
    }

    public static ClassPathEntry createEntryForUrl(TreeLogger logger, URL url) throws URISyntaxException, IOException {
        if (url.getProtocol().equals("file")) {
            File f = new File(url.toURI());
            String lowerCaseFileName = f.getName().toLowerCase(Locale.ROOT);
            if (f.isDirectory()) {
                return new DirectoryClassPathEntry(f);
            }
            if (f.isFile() && lowerCaseFileName.endsWith(".jar")) {
                return ZipFileClassPathEntry.get(f);
            }
            if (f.isFile() && lowerCaseFileName.endsWith(".zip")) {
                return ZipFileClassPathEntry.get(f);
            }
            try {
                return ZipFileClassPathEntry.get(f);
            }
            catch (Exception exception) {
                if (logger.isLoggable(TreeLogger.TRACE)) {
                    logger.log(TreeLogger.TRACE, "Unexpected entry in classpath; " + f + " is neither a directory nor an archive (.jar or .zip)");
                }
                return null;
            }
        }
        logger.log(TreeLogger.WARN, "Unknown URL type for " + url, null);
        return null;
    }

    public static void preload(TreeLogger logger) {
        ResourceOracleImpl.preload(logger, ResourceLoaders.fromContextClassLoader());
    }

    public static void preload(TreeLogger logger, ResourceLoader resources) {
        SpeedTracerLogger.Event resourceOracle = SpeedTracerLogger.start(CompilerEventType.RESOURCE_ORACLE, "phase", "preload");
        List<ClassPathEntry> entries = ResourceOracleImpl.getAllClassPathEntries(logger, resources);
        for (ClassPathEntry entry : entries) {
            if (!(entry instanceof ZipFileClassPathEntry)) continue;
            ZipFileClassPathEntry zpe = (ZipFileClassPathEntry)entry;
            zpe.index(logger);
        }
        resourceOracle.end(new String[0]);
    }

    public SetMultimap<String, String> getSourceModulesByTypeSourceName() {
        return this.sourceModulesByTypeSourceName;
    }

    public synchronized void scanResources(TreeLogger logger) {
        SpeedTracerLogger.Event resourceOracle = SpeedTracerLogger.start(CompilerEventType.RESOURCE_ORACLE, "phase", "refresh");
        TreeLogger refreshBranch = Messages.REFRESHING_RESOURCES.branch(logger, null);
        LinkedHashMap<String, ResourceDescription> resourceDescriptionsByPath = new LinkedHashMap<String, ResourceDescription>();
        for (ClassPathEntry classPathEntry : this.classPathEntries) {
            TreeLogger branchForClassPathEntry = Messages.EXAMINING_PATH_ROOT.branch(refreshBranch, classPathEntry.getLocation(), null);
            Map<AbstractResource, ResourceResolution> prefixesByResource = classPathEntry.findApplicableResources(branchForClassPathEntry, this.pathPrefixSet);
            for (Map.Entry<AbstractResource, ResourceResolution> entry : prefixesByResource.entrySet()) {
                AbstractResource resource = entry.getKey();
                ResourceResolution resourceResolution = entry.getValue();
                ResourceDescription resourceDescription = new ResourceDescription(resource, resourceResolution.getPathPrefix());
                String resourcePath = resourceDescription.resource.getPath();
                this.maybeRecordTypeForModule(resourceResolution, resourcePath);
                if (resourceDescriptionsByPath.containsKey(resourcePath)) {
                    ResourceDescription oldResourceDescription = (ResourceDescription)resourceDescriptionsByPath.get(resourcePath);
                    if (resourceDescription.isPreferredOver(oldResourceDescription)) {
                        resourceDescriptionsByPath.put(resourcePath, resourceDescription);
                        continue;
                    }
                    Messages.IGNORING_SHADOWED_RESOURCE.log(branchForClassPathEntry, resourcePath, null);
                    continue;
                }
                resourceDescriptionsByPath.put(resourcePath, resourceDescription);
            }
        }
        HashMap<String, AbstractResource> resourcesByPath = new HashMap<String, AbstractResource>();
        for (Map.Entry entry : resourceDescriptionsByPath.entrySet()) {
            resourcesByPath.put((String)entry.getKey(), ((ResourceDescription)entry.getValue()).resource);
        }
        this.exposedResources = Collections.unmodifiableSet(Sets.newHashSet(resourcesByPath.values()));
        this.exposedResourceMap = Collections.unmodifiableMap(resourcesByPath);
        this.exposedPathNames = Collections.unmodifiableSet(resourcesByPath.keySet());
        resourceOracle.end(new String[0]);
    }

    private void maybeRecordTypeForModule(ResourceResolution resourceResolution, String resourcePath) {
        if (this.pathPrefixSet.mergePathPrefixes()) {
            return;
        }
        this.sourceModulesByTypeSourceName.putAll(this.asTypeSourceName(resourcePath), resourceResolution.getSourceModuleNames());
    }

    private String asTypeSourceName(String resourcePath) {
        return resourcePath.replace(".java", "").replace("/", ".");
    }

    private static void addAllClassPathEntries(TreeLogger logger, ResourceLoader loader, List<ClassPathEntry> classPath) {
        HashSet<URI> seenEntries = new HashSet<URI>();
        for (URL url : loader.getClassPath()) {
            Exception caught;
            URI uri;
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                logger.log(TreeLogger.WARN, "Error processing classpath URL '" + url + "'", e);
                continue;
            }
            if (seenEntries.contains(uri)) continue;
            seenEntries.add(uri);
            try {
                ClassPathEntry entry = ResourceOracleImpl.createEntryForUrl(logger, url);
                if (entry == null) continue;
                classPath.add(entry);
                continue;
            }
            catch (AccessControlException e) {
                if (!logger.isLoggable(TreeLogger.DEBUG)) continue;
                logger.log(TreeLogger.DEBUG, "Skipping URL due to access restrictions: " + url);
                continue;
            }
            catch (URISyntaxException e) {
                caught = e;
            }
            catch (IOException e) {
                caught = e;
            }
            logger.log(TreeLogger.WARN, "Error processing classpath URL '" + url + "'", caught);
        }
    }

    private static synchronized List<ClassPathEntry> getAllClassPathEntries(TreeLogger logger, ResourceLoader resources) {
        List<ClassPathEntry> classPath = classPathCache.get(resources);
        if (classPath == null) {
            classPath = new ArrayList<ClassPathEntry>();
            ResourceOracleImpl.addAllClassPathEntries(logger, resources, classPath);
            classPathCache.put(resources, classPath);
        }
        return classPath;
    }

    public ResourceOracleImpl(List<ClassPathEntry> classPathEntries) {
        this.classPathEntries = classPathEntries;
    }

    public ResourceOracleImpl(TreeLogger logger) {
        this(logger, ResourceLoaders.fromContextClassLoader());
    }

    public ResourceOracleImpl(TreeLogger logger, ResourceLoader resources) {
        this(ResourceOracleImpl.getAllClassPathEntries(logger, resources));
    }

    @Override
    public void clear() {
        this.sourceModulesByTypeSourceName.clear();
        this.exposedPathNames = Collections.emptySet();
        this.exposedResourceMap = Collections.emptyMap();
        this.exposedResources = Collections.emptySet();
    }

    @Override
    public Set<String> getPathNames() {
        return this.exposedPathNames;
    }

    public PathPrefixSet getPathPrefixes() {
        return this.pathPrefixSet;
    }

    @Override
    public Set<Resource> getResources() {
        return this.exposedResources;
    }

    public void setPathPrefixes(PathPrefixSet pathPrefixSet) {
        this.pathPrefixSet = pathPrefixSet;
    }

    List<ClassPathEntry> getClassPathEntries() {
        return this.classPathEntries;
    }

    @Override
    public Resource getResource(String pathName) {
        pathName = Files.simplifyPath(pathName);
        return this.exposedResourceMap.get(pathName);
    }

    private static class ResourceDescription
    implements Comparable<ResourceDescription> {
        public final PathPrefix pathPrefix;
        public final AbstractResource resource;

        public ResourceDescription(AbstractResource resource, PathPrefix pathPrefix) {
            this.resource = pathPrefix.shouldReroot() ? new RerootedResource(resource, pathPrefix) : resource;
            this.pathPrefix = pathPrefix;
        }

        public boolean isPreferredOver(ResourceDescription that) {
            return this.compareTo(that) > 0;
        }

        @Override
        public int compareTo(ResourceDescription other) {
            if (this.resource.wasRerooted() != other.resource.wasRerooted()) {
                return this.resource.wasRerooted() ? 1 : -1;
            }
            return this.pathPrefix.getPriority() - other.pathPrefix.getPriority();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ResourceDescription)) {
                return false;
            }
            ResourceDescription other = (ResourceDescription)o;
            return this.pathPrefix.getPriority() == other.pathPrefix.getPriority() && this.resource.wasRerooted() == other.resource.wasRerooted();
        }

        public int hashCode() {
            return (this.pathPrefix.getPriority() << 1) + (this.resource.wasRerooted() ? 1 : 0);
        }

        public String toString() {
            return "{" + this.resource + "," + this.pathPrefix + "}";
        }
    }

    private static class RerootedResource
    extends AbstractResource {
        private final String path;
        private final AbstractResource resource;

        public RerootedResource(AbstractResource resource, PathPrefix pathPrefix) {
            this.path = pathPrefix.getRerootedPath(resource.getPath());
            this.resource = resource;
        }

        @Override
        public long getLastModified() {
            return this.resource.getLastModified();
        }

        @Override
        public String getLocation() {
            return this.resource.getLocation();
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getPathPrefix() {
            int fullPathLen = this.resource.getPath().length();
            return this.resource.getPath().substring(0, fullPathLen - this.path.length());
        }

        @Override
        public InputStream openContents() throws IOException {
            return this.resource.openContents();
        }

        @Override
        public boolean wasRerooted() {
            return true;
        }
    }

    private static class Messages {
        static final Message1String EXAMINING_PATH_ROOT = new Message1String(TreeLogger.DEBUG, "Searching for resources within $0");
        static final Message1String IGNORING_SHADOWED_RESOURCE = new Message1String(TreeLogger.DEBUG, "Resource '$0' is being shadowed by another resource higher in the classpath having the same name; this one will not be used");
        static final Message0 REFRESHING_RESOURCES = new Message0(TreeLogger.TRACE, "Refreshing resources");

        private Messages() {
        }
    }
}

