/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.resource.impl;

import com.google.gwt.dev.resource.impl.AbstractResource;
import com.google.gwt.dev.resource.impl.DirectoryClassPathEntry;
import com.google.gwt.dev.resource.impl.PathPrefixSet;
import com.google.gwt.dev.resource.impl.ResourceAccumulator;
import com.google.gwt.dev.resource.impl.ResourceResolution;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

class ResourceAccumulatorManager {
    private static Map<DirectoryAndPathPrefix, ResourceAccumulator> resourceAccumulators = Maps.newHashMap();

    ResourceAccumulatorManager() {
    }

    public static synchronized Map<AbstractResource, ResourceResolution> getResources(DirectoryClassPathEntry directoryClassPathEntry, PathPrefixSet pathPrefixSet) throws IOException {
        DirectoryAndPathPrefix directoryAndPathPrefix = new DirectoryAndPathPrefix(directoryClassPathEntry, pathPrefixSet);
        ResourceAccumulator resourceAccumulator = resourceAccumulators.get(directoryAndPathPrefix);
        if (resourceAccumulator == null) {
            Path path = directoryClassPathEntry.getDirectory().toPath();
            resourceAccumulator = new ResourceAccumulator(path, pathPrefixSet);
            resourceAccumulators.put(directoryAndPathPrefix, resourceAccumulator);
        }
        resourceAccumulator.refreshResources();
        return ImmutableMap.copyOf(resourceAccumulator.getResources());
    }

    public static synchronized void refreshResources() throws IOException {
        Iterator<Map.Entry<DirectoryAndPathPrefix, ResourceAccumulator>> entriesIterator = resourceAccumulators.entrySet().iterator();
        while (entriesIterator.hasNext()) {
            Map.Entry<DirectoryAndPathPrefix, ResourceAccumulator> entry = entriesIterator.next();
            DirectoryAndPathPrefix directoryAndPathPrefix = entry.getKey();
            ResourceAccumulator resourceAccumulator = entry.getValue();
            if (directoryAndPathPrefix.isOld()) {
                resourceAccumulator.shutdown();
                entriesIterator.remove();
                continue;
            }
            if (!resourceAccumulator.isWatchServiceActive()) continue;
            resourceAccumulator.refreshResources();
        }
    }

    @VisibleForTesting
    static int getActiveListenerCount() throws IOException {
        ResourceAccumulatorManager.refreshResources();
        return resourceAccumulators.size();
    }

    @VisibleForTesting
    static boolean isListening(DirectoryClassPathEntry directoryClassPathEntry, PathPrefixSet pathPrefixSet) {
        return resourceAccumulators.containsKey(new DirectoryAndPathPrefix(directoryClassPathEntry, pathPrefixSet));
    }

    static {
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            ResourceAccumulatorManager.refreshResources();
                            Thread.sleep(10L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    private static class DirectoryAndPathPrefix {
        private final WeakReference<DirectoryClassPathEntry> directoryClassPathEntryRef;
        private final WeakReference<PathPrefixSet> pathPrefixSetRef;
        private int hashCode;

        public DirectoryAndPathPrefix(DirectoryClassPathEntry directoryClassPathEntry, PathPrefixSet pathPrefixSet) {
            this.directoryClassPathEntryRef = new WeakReference<DirectoryClassPathEntry>(directoryClassPathEntry);
            this.pathPrefixSetRef = new WeakReference<PathPrefixSet>(pathPrefixSet);
            this.hashCode = Objects.hash(directoryClassPathEntry, pathPrefixSet);
        }

        public boolean equals(Object object) {
            if (object instanceof DirectoryAndPathPrefix) {
                DirectoryAndPathPrefix other = (DirectoryAndPathPrefix)object;
                return this.directoryClassPathEntryRef.get() == other.directoryClassPathEntryRef.get() && this.pathPrefixSetRef.get() == other.pathPrefixSetRef.get();
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean isOld() {
            return this.directoryClassPathEntryRef.get() == null || this.pathPrefixSetRef.get() == null;
        }
    }
}

