/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.resource.impl;

import com.google.gwt.dev.resource.impl.AbstractResource;
import com.google.gwt.dev.resource.impl.FileResource;
import com.google.gwt.dev.resource.impl.PathPrefixSet;
import com.google.gwt.dev.resource.impl.ResourceResolution;
import com.google.gwt.thirdparty.guava.common.collect.ArrayListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;

class ResourceAccumulator {
    private static final boolean WATCH_FILE_CHANGES_DEFAULT = Boolean.parseBoolean(System.getProperty("gwt.watchFileChanges", "true"));
    private Map<AbstractResource, ResourceResolution> resolutionsByResource;
    private Multimap<Path, Path> childPathsByParentPath;
    private Path rootDirectory;
    private WeakReference<PathPrefixSet> pathPrefixSetRef;
    private WatchService watchService;
    private boolean watchFileChanges = WATCH_FILE_CHANGES_DEFAULT;

    public ResourceAccumulator(Path rootDirectory, PathPrefixSet pathPrefixSet) {
        this.rootDirectory = rootDirectory;
        this.pathPrefixSetRef = new WeakReference<PathPrefixSet>(pathPrefixSet);
    }

    public boolean isWatchServiceActive() {
        return this.watchService != null;
    }

    public void refreshResources() throws IOException {
        if (this.isWatchServiceActive()) {
            this.refresh();
        } else {
            this.fullRefresh();
        }
    }

    public Map<AbstractResource, ResourceResolution> getResources() {
        return this.resolutionsByResource;
    }

    public void shutdown() throws IOException {
        this.stopWatchService();
    }

    private void fullRefresh() throws IOException {
        this.resolutionsByResource = Maps.newIdentityHashMap();
        this.childPathsByParentPath = ArrayListMultimap.create();
        this.maybeInitializeWatchService();
        this.onNewDirectory(this.rootDirectory);
    }

    private void maybeInitializeWatchService() throws IOException {
        if (this.watchFileChanges) {
            this.stopWatchService();
            try {
                this.watchService = FileSystems.getDefault().newWatchService();
            }
            catch (IOException e) {
                this.watchFileChanges = false;
            }
        }
    }

    private void stopWatchService() throws IOException {
        if (this.watchService != null) {
            this.watchService.close();
        }
    }

    private void refresh() throws IOException {
        WatchKey watchKey;
        while ((watchKey = this.watchService.poll()) != null) {
            Path parentDir = (Path)watchKey.watchable();
            for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                WatchEvent.Kind<?> eventKind = watchEvent.kind();
                if (eventKind == StandardWatchEventKinds.OVERFLOW) {
                    this.fullRefresh();
                    return;
                }
                Path child = parentDir.resolve((Path)watchEvent.context());
                if (eventKind == StandardWatchEventKinds.ENTRY_CREATE) {
                    this.onNewPath(child);
                    continue;
                }
                if (eventKind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                this.onRemovedPath(child);
            }
            watchKey.reset();
        }
        return;
    }

    private void onNewPath(Path path) throws IOException {
        try {
            if (Files.isHidden(path)) {
                return;
            }
            if (Files.isRegularFile(path, new LinkOption[0])) {
                this.onNewFile(path);
            } else {
                this.onNewDirectory(path);
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            // empty catch block
        }
    }

    private void onNewDirectory(Path directory) throws IOException {
        String relativePath = this.getRelativePath(directory);
        if (!relativePath.isEmpty() && !this.getPathPrefixSet().includesDirectory(relativePath)) {
            return;
        }
        if (this.watchService != null) {
            directory.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path child : stream) {
                this.childPathsByParentPath.put(directory, child);
                this.onNewPath(child);
            }
        }
    }

    private void onNewFile(Path file) {
        FileResource resource = this.toFileResource(file);
        ResourceResolution resourceResolution = this.getPathPrefixSet().includesResource(resource.getPath());
        if (resourceResolution != null) {
            this.resolutionsByResource.put(resource, resourceResolution);
        }
    }

    private void onRemovedPath(Path path) {
        this.resolutionsByResource.remove(this.toFileResource(path));
        for (Path child : this.childPathsByParentPath.get(path)) {
            this.onRemovedPath(child);
        }
    }

    private FileResource toFileResource(Path path) {
        String relativePath = this.getRelativePath(path);
        return FileResource.of(relativePath, path.toFile());
    }

    private String getRelativePath(Path directory) {
        return this.rootDirectory.relativize(directory).toString().replace(File.separator, "/");
    }

    private PathPrefixSet getPathPrefixSet() {
        PathPrefixSet pathPrefixSet = (PathPrefixSet)this.pathPrefixSetRef.get();
        assert (pathPrefixSet != null);
        return pathPrefixSet;
    }
}

