/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.resource.impl;

import com.google.gwt.dev.resource.impl.PathPrefix;
import com.google.gwt.dev.resource.impl.ResourceResolution;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.dev.util.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PathPrefixSet {
    private boolean mergePathPrefixes = true;
    private final List<PathPrefix> prefixes = new ArrayList<PathPrefix>();
    private final TrieNode rootTrieNode = new TrieNode("/");

    public PathPrefixSet() {
        this(true);
    }

    public PathPrefixSet(boolean mergePathPrefixes) {
        this.mergePathPrefixes = mergePathPrefixes;
    }

    public boolean add(PathPrefix prefix) {
        prefix.setPriority(this.prefixes.size());
        this.prefixes.add(prefix);
        String pathPrefix = prefix.getPrefix();
        if ("".equals(pathPrefix)) {
            this.rootTrieNode.addPathPrefix(prefix);
            return false;
        }
        String[] parts = pathPrefix.split("/");
        TrieNode parentNode = this.rootTrieNode;
        boolean didAdd = false;
        for (String part : parts) {
            TrieNode childNode = parentNode.findChild(part);
            if (childNode != null) {
                parentNode = childNode;
                continue;
            }
            parentNode = parentNode.addChild(part);
            didAdd = true;
        }
        assert (parentNode != null);
        parentNode.addPathPrefix(prefix);
        return didAdd;
    }

    public int getSize() {
        return this.prefixes.size();
    }

    public boolean includesDirectory(String dirPath) {
        String[] parts;
        this.assertValidAbstractDirectoryPathName(dirPath);
        if (this.rootTrieNode.hasPrefixes) {
            return true;
        }
        TrieNode parentNode = this.rootTrieNode;
        for (String part : parts = dirPath.split("/")) {
            assert (!"".equals(part));
            TrieNode childNode = parentNode.findChild(part);
            if (childNode != null) {
                if (childNode.hasPrefixes) {
                    return true;
                }
            } else {
                return false;
            }
            parentNode = childNode;
        }
        return true;
    }

    public ResourceResolution includesResource(String resourceAbstractPathName) {
        String[] parts = resourceAbstractPathName.split("/");
        return this.includesResource(resourceAbstractPathName, parts);
    }

    public ResourceResolution includesResource(String resourceAbstractPathName, String[] parts) {
        this.assertValidAbstractResourcePathName(resourceAbstractPathName);
        ResourceResolution resourceResolution = new ResourceResolution();
        TrieNode currentNode = this.rootTrieNode;
        List<PathPrefix> mostSpecificPrefixes = this.rootTrieNode.getPathPrefixes();
        for (String part : parts) {
            assert (!"".equals(part));
            TrieNode childNode = currentNode.findChild(part);
            if (childNode == null) break;
            if (childNode.hasPrefixes) {
                List<PathPrefix> moreSpecificPrefixes = childNode.getPathPrefixes();
                if (!this.mergePathPrefixes) {
                    for (PathPrefix candidatePrefix : moreSpecificPrefixes) {
                        if (!candidatePrefix.getJudgement(resourceAbstractPathName).isInclude()) continue;
                        resourceResolution.addSourceModuleName(candidatePrefix.getModuleName());
                    }
                }
                mostSpecificPrefixes = moreSpecificPrefixes;
            }
            currentNode = childNode;
        }
        PathPrefix chiefPrefix = null;
        PathPrefix.Judgement chiefJudgement = null;
        for (PathPrefix candidatePrefix : mostSpecificPrefixes) {
            PathPrefix.Judgement judgement = candidatePrefix.getJudgement(resourceAbstractPathName);
            if (chiefJudgement != null && judgement.getPriority() <= chiefJudgement.getPriority()) continue;
            chiefPrefix = candidatePrefix;
            chiefJudgement = judgement;
        }
        if (chiefPrefix == null || !chiefJudgement.isInclude()) {
            return null;
        }
        resourceResolution.setPathPrefix(chiefPrefix);
        return resourceResolution;
    }

    public boolean mergePathPrefixes() {
        return this.mergePathPrefixes;
    }

    public String toString() {
        return this.rootTrieNode.toString();
    }

    public Collection<PathPrefix> values() {
        return Collections.unmodifiableCollection(this.prefixes);
    }

    private void assertValidAbstractDirectoryPathName(String name) {
        assert (name != null);
        assert (!name.startsWith("/"));
    }

    private void assertValidAbstractResourcePathName(String name) {
        assert (name != null);
        assert (!"".equals(name));
        assert (!name.startsWith("/") && !name.endsWith("/"));
    }

    private class TrieNode {
        private Map<String, TrieNode> children = Maps.create();
        private final String part;
        private List<PathPrefix> prefixes = Lists.newArrayList();
        private boolean hasPrefixes = false;

        public TrieNode(String part) {
            this.part = StringInterner.get().intern(part);
        }

        public TrieNode addChild(String part) {
            part = StringInterner.get().intern(part);
            TrieNode newChild = new TrieNode(part);
            assert (!this.children.containsKey(part));
            this.children = Maps.put(this.children, part, newChild);
            return newChild;
        }

        public void addPathPrefix(PathPrefix prefix) {
            this.hasPrefixes = true;
            if (PathPrefixSet.this.mergePathPrefixes) {
                if (this.prefixes.isEmpty()) {
                    this.prefixes.add(prefix);
                } else {
                    this.prefixes.get(0).merge(prefix);
                }
            } else {
                this.prefixes.add(prefix);
            }
        }

        public TrieNode findChild(String part) {
            return this.children.get(part);
        }

        public List<PathPrefix> getPathPrefixes() {
            return this.prefixes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb, "");
            return sb.toString();
        }

        private void toString(StringBuilder sb, String indent) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(indent);
            sb.append(' ');
            sb.append(this.part);
            for (TrieNode child : this.children.values()) {
                child.toString(sb, indent + "  ");
            }
        }
    }
}

